/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_1.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.ExpressionConverter;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.InformationItem;
import org.kie.dmn.model.v1_1.List;
import org.kie.dmn.model.v1_1.Relation;

public class RelationConverter
extends ExpressionConverter {
    public static final String EXPRESSION = "expression";
    public static final String ROW = "row";
    public static final String COLUMN = "column";

    @Override
    protected void assignChildElement(Object parent, String nodeName, Object child) {
        Relation r = (Relation)parent;
        if (COLUMN.equals(nodeName)) {
            r.getColumn().add((InformationItem)child);
        } else if (ROW.equals(nodeName)) {
            r.getRow().add((List)child);
        } else {
            super.assignChildElement(parent, nodeName, child);
        }
    }

    @Override
    protected void assignAttributes(HierarchicalStreamReader reader, Object parent) {
        super.assignAttributes(reader, parent);
    }

    @Override
    protected void writeChildren(HierarchicalStreamWriter writer, MarshallingContext context, Object parent) {
        super.writeChildren(writer, context, parent);
        Relation r = (Relation)parent;
        for (InformationItem c : r.getColumn()) {
            this.writeChildrenNode(writer, context, c, COLUMN);
        }
        for (List row : r.getRow()) {
            this.writeChildrenNode(writer, context, row, ROW);
        }
    }

    @Override
    protected void writeAttributes(HierarchicalStreamWriter writer, Object parent) {
        super.writeAttributes(writer, parent);
    }

    public RelationConverter(XStream xstream) {
        super(xstream);
    }

    @Override
    protected DMNModelInstrumentedBase createModelObject() {
        return new Relation();
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Relation.class);
    }
}

