/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.List;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.ast.FunctionDefNode;
import org.kie.dmn.feel.lang.impl.CompiledExpressionImpl;

public class DMNLiteralExpressionEvaluator
implements DMNExpressionEvaluator {
    private CompiledExpression expression;

    public DMNLiteralExpressionEvaluator(CompiledExpression expression) {
        this.expression = expression;
    }

    public boolean isFunctionDefinition() {
        return ((CompiledExpressionImpl)this.expression).getExpression() instanceof FunctionDefNode;
    }

    public CompiledExpression getExpression() {
        return this.expression;
    }

    @Override
    public EvaluatorResult evaluate(DMNRuntimeEventManager dmrem, DMNResult result) {
        List<DMNProfile> profiles = ((DMNRuntimeImpl)dmrem.getRuntime()).getProfiles();
        Object val = FEEL.newInstance(profiles).evaluate(this.expression, result.getContext().getAll());
        return new EvaluatorResultImpl(val, EvaluatorResult.ResultType.SUCCESS);
    }
}

