/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerHelper;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DRGElementCompiler;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.DRGElement;
import org.kie.dmn.model.v1_1.Decision;
import org.kie.dmn.model.v1_1.NamedElement;

public class DecisionCompiler
implements DRGElementCompiler {
    @Override
    public boolean accept(DRGElement de) {
        return de instanceof Decision;
    }

    @Override
    public void compileNode(DRGElement de, DMNCompilerImpl compiler, DMNModelImpl model) {
        Decision decision = (Decision)de;
        DecisionNodeImpl dn = new DecisionNodeImpl(decision);
        DMNType type = null;
        if (decision.getVariable() == null) {
            DMNCompilerHelper.reportMissingVariable(model, de, (DMNModelInstrumentedBase)decision, Msg.MISSING_VARIABLE_FOR_DECISION);
            return;
        }
        DMNCompilerHelper.checkVariableName(model, (NamedElement)decision, decision.getName());
        type = decision.getVariable() != null && decision.getVariable().getTypeRef() != null ? compiler.resolveTypeRef(model, dn, (NamedElement)decision, (DMNModelInstrumentedBase)decision.getVariable(), decision.getVariable().getTypeRef()) : compiler.resolveTypeRef(model, dn, (NamedElement)decision, (DMNModelInstrumentedBase)decision, null);
        dn.setResultType(type);
        model.addDecision(dn);
    }

    @Override
    public boolean accept(DMNNode node) {
        return node instanceof DecisionNodeImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compileEvaluator(DMNNode node, DMNCompilerImpl compiler, DMNCompilerContext ctx, DMNModelImpl model) {
        DecisionNodeImpl di = (DecisionNodeImpl)node;
        compiler.linkRequirements(model, di);
        ctx.enterFrame();
        try {
            for (DMNNode dep : di.getDependencies().values()) {
                if (dep instanceof DecisionNode) {
                    ctx.setVariable(dep.getName(), ((DecisionNode)dep).getResultType());
                    continue;
                }
                if (dep instanceof InputDataNode) {
                    ctx.setVariable(dep.getName(), ((InputDataNode)dep).getType());
                    continue;
                }
                if (!(dep instanceof BusinessKnowledgeModelNode)) continue;
                ctx.setVariable(dep.getName(), ((BusinessKnowledgeModelNode)dep).getResultType());
            }
            DMNExpressionEvaluator evaluator = compiler.getEvaluatorCompiler().compileExpression(ctx, model, di, di.getName(), di.getDecision().getExpression());
            di.setEvaluator(evaluator);
        }
        finally {
            ctx.exitFrame();
        }
    }
}

