/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.ast.InputDataNodeImpl;
import org.kie.dmn.core.compiler.DMNCompilerHelper;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DMNTypeRegistry;
import org.kie.dmn.core.compiler.DRGElementCompiler;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.DRGElement;
import org.kie.dmn.model.v1_1.InputData;
import org.kie.dmn.model.v1_1.NamedElement;

public class InputDataCompiler
implements DRGElementCompiler {
    @Override
    public boolean accept(DRGElement de) {
        return de instanceof InputData;
    }

    @Override
    public void compileNode(DRGElement de, DMNCompilerImpl compiler, DMNModelImpl model) {
        InputData input = (InputData)de;
        InputDataNodeImpl idn = new InputDataNodeImpl(input);
        if (input.getVariable() != null) {
            DMNCompilerHelper.checkVariableName(model, (NamedElement)input, input.getName());
            DMNType type = compiler.resolveTypeRef(model, idn, (NamedElement)de, (DMNModelInstrumentedBase)input.getVariable(), input.getVariable().getTypeRef());
            idn.setType(type);
        } else {
            idn.setType(DMNTypeRegistry.UNKNOWN);
            DMNCompilerHelper.reportMissingVariable(model, de, (DMNModelInstrumentedBase)input, Msg.MISSING_VARIABLE_FOR_INPUT);
        }
        model.addInput(idn);
    }
}

