/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.kie.dmn.model.v1_1.ItemDefinition;

public class ItemDefinitionDependenciesSorter {
    private final String modelNamespace;

    public ItemDefinitionDependenciesSorter(String modelNamespace) {
        this.modelNamespace = modelNamespace;
    }

    public List<ItemDefinition> sort(List<ItemDefinition> ins) {
        ArrayList<ItemDefinition> todos = new ArrayList<ItemDefinition>(ins);
        ArrayList<ItemDefinition> ordered = new ArrayList<ItemDefinition>(ins.size());
        while (todos.size() > 0) {
            ItemDefinition c1 = (ItemDefinition)todos.get(0);
            for (int i = 1; i < todos.size(); ++i) {
                ItemDefinition other = (ItemDefinition)todos.get(i);
                QName otherQName = new QName(this.modelNamespace, other.getName());
                if (!ItemDefinitionDependenciesSorter.recurseFind(c1, otherQName)) continue;
                c1 = other;
            }
            ordered.add(c1);
            todos.remove(c1);
        }
        return ordered;
    }

    private static boolean recurseFind(ItemDefinition o1, QName qname2) {
        if (o1.getTypeRef() != null && o1.getTypeRef().equals(qname2)) {
            return true;
        }
        for (ItemDefinition ic : o1.getItemComponent()) {
            if (!ItemDefinitionDependenciesSorter.recurseFind(ic, qname2)) continue;
            return true;
        }
        return false;
    }

    private static boolean directFind(ItemDefinition o1, QName qname2) {
        if (o1.getTypeRef() != null && o1.getTypeRef().equals(qname2)) {
            return true;
        }
        for (ItemDefinition ic : o1.getItemComponent()) {
            if (!(ic.getTypeRef() == null ? ItemDefinitionDependenciesSorter.directFind(ic, qname2) : ic.getTypeRef().equals(qname2))) continue;
            return true;
        }
        return false;
    }

    public static void displayDependencies(List<ItemDefinition> ins, String namespaceURI) {
        for (ItemDefinition in : ins) {
            System.out.println(in.getName());
            ArrayList<ItemDefinition> others = new ArrayList<ItemDefinition>(ins);
            others.remove(in);
            for (ItemDefinition other : others) {
                QName otherQName = new QName(namespaceURI, other.getName());
                if (ItemDefinitionDependenciesSorter.directFind(in, otherQName)) {
                    System.out.println(" direct depends on: " + other.getName());
                    continue;
                }
                if (!ItemDefinitionDependenciesSorter.recurseFind(in, otherQName)) continue;
                System.out.println(" indir. depends on: " + other.getName());
            }
        }
    }
}

