/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.decisiontables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class SingleValueOrContextCollector<T>
implements Collector<T, List<T>, Object> {
    private final List<String> outputNames;

    public SingleValueOrContextCollector(List<String> outputNames) {
        ArrayList<String> names = new ArrayList<String>(outputNames);
        this.outputNames = Collections.unmodifiableList(names);
    }

    @Override
    public Supplier<List<T>> supplier() {
        return () -> new ArrayList();
    }

    @Override
    public BiConsumer<List<T>, T> accumulator() {
        return (list, obj) -> list.add(obj);
    }

    @Override
    public BinaryOperator<List<T>> combiner() {
        return (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        };
    }

    @Override
    public Function<List<T>, Object> finisher() {
        return list -> {
            if (list.size() == 1) {
                return list.get(0);
            }
            HashMap res = new HashMap();
            for (int i = 0; i < this.outputNames.size(); ++i) {
                res.put(this.outputNames.get(i), list.get(i));
            }
            return res;
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }
}

