/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.namespace;

import java.util.ArrayList;
import java.util.List;
import org.kie.spring.factorybeans.EnvironmentDefFactoryBean;
import org.kie.spring.namespace.DefinitionParserHelper;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class EnvironmentDefinitionParser
extends AbstractBeanDefinitionParser {
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_REF = "ref";
    public static final String ATTRIBUTE_SCOPE = "scope";
    public static final String ATTRIBUTE_STRATEGY_ACCEPTOR_REF = "strategy-acceptor-ref";
    public static final String ATTRIBUTE_ENV_REF = "env-ref";
    public static final String ELEMENT_ENTITY_MANAGER_FACTORY = "entity-manager-factory";
    public static final String ELEMENT_TRANSACTION_MANAGER = "transaction-manager";
    public static final String ELEMENT_GLOBALS = "globals";
    public static final String ELEMENT_DATE_FORMATS = "date-formats";
    public static final String ELEMENT_CALENDARS = "calendars";
    public static final String ELEMENT_OBJECT_MARSHALLING_STRATEGIES = "object-marshalling-strategies";
    public static final String ELEMENT_SERIALIZABLE_PLACEHOLDER_RESOLVER_STRATEGY = "serializable-placeholder-resolver-strategy";
    public static final String ELEMENT_IDENTITY_PLACEHOLDER_RESOLVER_STRATEGY = "identity-placeholder-resolver-strategy";
    public static final String ELEMENT_PROCESS_INSTANCE_RESOLVER_STRATEGY = "process-instance-resolver-strategy";
    public static final String ELEMENT_JPA_PLACEHOLDER_RESOLVER_STRATEGY = "jpa-placeholder-resolver-strategy";
    public static final String ELEMENT_SCOPED_ENTITY_MANAGER = "scoped-entity-manager";
    public static final String ELEMENT_CUSTOM_MARSHALLING_STRATEGY = "custom-marshalling-strategy";
    public static final String ELEMENT_BEAN = "bean";
    public static final String ELEMENT_STRATEGY_ACCEPTOR = "strategy-acceptor";
    public static final String PROPERTY_ENTITY_MANAGER_FACTORY = "entityManagerFactory";
    public static final String PROPERTY_TRANSACTION_MANAGER = "transactionManager";
    public static final String PROPERTY_GLOBALS = "globals";
    public static final String PROPERTY_CALENDARS = "calendars";
    public static final String PROPERTY_DATE_FORMATS = "dateFormats";
    public static final String PROPERTY_JPA_PLACE_HOLDER_RESOLVER_STRATEGY_ENV = "jpaPlaceHolderResolverStrategyEnv";
    public static final String PROPERTY_APP_SCOPED_ENTITY_MANAGER = "appScopedEntityManager";
    public static final String PROPERTY_CMD_SCOPED_ENTITY_MANAGER = "cmdScopedEntityManager";
    public static final String PROPERTY_SERIALIZABLE_PLACEHOLDER_RESOLVER_STRATEGY_ACCEPTOR = "serializablePlaceholderResolverStrategyAcceptor";
    public static final String PROPERTY_IDENTITY_PLACEHOLDER_RESOLVER_STRATEGY_ACCEPTOR = "identityPlaceholderResolverStrategyAcceptor";
    public static final String PROPERTY_CUSTOM_MARSHALLING_STRATEGY = "customMarshallingStrategies";
    public static final String PROPERTY_OBJECT_MARSHALLING_ORDER = "objectMarshallersOrder";
    public static final String PROPERTY_NAME = "name";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        Element scopedEM;
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(EnvironmentDefFactoryBean.class);
        String id = element.getAttribute(ATTRIBUTE_ID);
        DefinitionParserHelper.emptyAttributeCheck(element.getLocalName(), ATTRIBUTE_ID, id);
        factory.addPropertyValue(PROPERTY_NAME, (Object)id);
        this.checkRefOrNestedBean(element, ELEMENT_ENTITY_MANAGER_FACTORY, PROPERTY_ENTITY_MANAGER_FACTORY, ATTRIBUTE_REF, factory, parserContext);
        this.checkRefOrNestedBean(element, ELEMENT_TRANSACTION_MANAGER, PROPERTY_TRANSACTION_MANAGER, ATTRIBUTE_REF, factory, parserContext);
        this.checkRefOrNestedBean(element, "globals", "globals", ATTRIBUTE_REF, factory, parserContext);
        this.checkRefOrNestedBean(element, ELEMENT_DATE_FORMATS, PROPERTY_DATE_FORMATS, ATTRIBUTE_REF, factory, parserContext);
        this.checkRefOrNestedBean(element, "calendars", "calendars", ATTRIBUTE_REF, factory, parserContext);
        Element objectMarshallingStrategiesElement = DomUtils.getChildElementByTagName((Element)element, (String)ELEMENT_OBJECT_MARSHALLING_STRATEGIES);
        if (objectMarshallingStrategiesElement != null) {
            ArrayList<String> marshallerOrderList = new ArrayList<String>();
            List children = DomUtils.getChildElements((Element)objectMarshallingStrategiesElement);
            ManagedList managedCustomList = new ManagedList();
            for (Element child : children) {
                String localName = child.getLocalName();
                marshallerOrderList.add(localName);
                if (ELEMENT_SERIALIZABLE_PLACEHOLDER_RESOLVER_STRATEGY.equalsIgnoreCase(localName)) {
                    this.parsePlaceholderResolverStrategyElement(parserContext, factory, child, PROPERTY_SERIALIZABLE_PLACEHOLDER_RESOLVER_STRATEGY_ACCEPTOR);
                    continue;
                }
                if (ELEMENT_IDENTITY_PLACEHOLDER_RESOLVER_STRATEGY.equalsIgnoreCase(localName)) {
                    this.parsePlaceholderResolverStrategyElement(parserContext, factory, child, PROPERTY_IDENTITY_PLACEHOLDER_RESOLVER_STRATEGY_ACCEPTOR);
                    continue;
                }
                if (ELEMENT_PROCESS_INSTANCE_RESOLVER_STRATEGY.equalsIgnoreCase(localName)) continue;
                if (ELEMENT_JPA_PLACEHOLDER_RESOLVER_STRATEGY.equalsIgnoreCase(localName)) {
                    String envRef = child.getAttribute(ATTRIBUTE_ENV_REF);
                    if (!StringUtils.hasText((String)envRef)) continue;
                    factory.addPropertyValue(PROPERTY_JPA_PLACE_HOLDER_RESOLVER_STRATEGY_ENV, (Object)new RuntimeBeanReference(envRef));
                    continue;
                }
                if (!ELEMENT_CUSTOM_MARSHALLING_STRATEGY.equalsIgnoreCase(localName)) continue;
                String ref = child.getAttribute(ATTRIBUTE_REF);
                if (StringUtils.hasText((String)ref)) {
                    managedCustomList.add((Object)new RuntimeBeanReference(ref));
                    continue;
                }
                Element nestedBean = DomUtils.getChildElementByTagName((Element)child, (String)ELEMENT_BEAN);
                if (nestedBean != null) {
                    Object obj = parserContext.getDelegate().parsePropertySubElement(nestedBean, null, null);
                    managedCustomList.add(obj);
                    continue;
                }
                throw new IllegalArgumentException("custom-marshalling-strategy must have either a ref attribute or an embedded bean child element!");
            }
            factory.addPropertyValue(PROPERTY_CUSTOM_MARSHALLING_STRATEGY, (Object)managedCustomList);
            factory.addPropertyValue(PROPERTY_OBJECT_MARSHALLING_ORDER, marshallerOrderList);
        }
        if ((scopedEM = DomUtils.getChildElementByTagName((Element)element, (String)ELEMENT_SCOPED_ENTITY_MANAGER)) != null) {
            String ref = scopedEM.getAttribute(ATTRIBUTE_REF);
            Object runtimeBean = null;
            if (StringUtils.hasText((String)ref)) {
                runtimeBean = new RuntimeBeanReference(ref);
            } else {
                Element beanElement = DomUtils.getChildElementByTagName((Element)scopedEM, (String)ELEMENT_BEAN);
                if (beanElement != null) {
                    runtimeBean = parserContext.getDelegate().parsePropertySubElement(beanElement, null, null);
                } else {
                    throw new IllegalArgumentException("scoped-entity-manager must have an embedded bean element, or a 'ref' attribute");
                }
            }
            String scope = scopedEM.getAttribute(ATTRIBUTE_SCOPE);
            if ("app".equalsIgnoreCase(scope)) {
                factory.addPropertyValue(PROPERTY_APP_SCOPED_ENTITY_MANAGER, runtimeBean);
            } else if ("cmd".equalsIgnoreCase(scope)) {
                factory.addPropertyValue(PROPERTY_CMD_SCOPED_ENTITY_MANAGER, runtimeBean);
            } else {
                throw new IllegalArgumentException("scoped-entity-manager: 'scope' attribute must be either 'app' or 'cmd'");
            }
        }
        return factory.getBeanDefinition();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parsePlaceholderResolverStrategyElement(ParserContext parserContext, BeanDefinitionBuilder factory, Element actualElement, String strategyAcceptorPropName) {
        if (actualElement == null) return;
        String ref = actualElement.getAttribute(ATTRIBUTE_STRATEGY_ACCEPTOR_REF);
        if (StringUtils.hasText((String)ref)) {
            factory.addPropertyValue(strategyAcceptorPropName, (Object)new RuntimeBeanReference(ref));
            return;
        } else {
            Element acceptorElement = DomUtils.getChildElementByTagName((Element)actualElement, (String)ELEMENT_STRATEGY_ACCEPTOR);
            if (acceptorElement == null) throw new IllegalArgumentException(actualElement.getTagName() + " must have either a " + ATTRIBUTE_STRATEGY_ACCEPTOR_REF + " attribute or an embedded " + ELEMENT_STRATEGY_ACCEPTOR + " child element!");
            Element beanElement = DomUtils.getChildElementByTagName((Element)acceptorElement, (String)ELEMENT_BEAN);
            if (beanElement == null) throw new IllegalArgumentException("strategy-acceptor must have an embedded bean element!");
            Object obj = parserContext.getDelegate().parsePropertySubElement(beanElement, null, null);
            factory.addPropertyValue(strategyAcceptorPropName, obj);
        }
    }

    protected void checkRefOrNestedBean(Element environmentElement, String tagName, String property, String refAttribute, BeanDefinitionBuilder factory, ParserContext parserContext) {
        Element element = DomUtils.getChildElementByTagName((Element)environmentElement, (String)tagName);
        if (element != null) {
            String ref = element.getAttribute(refAttribute);
            if (StringUtils.hasText((String)ref)) {
                factory.addPropertyValue(property, (Object)new RuntimeBeanReference(ref));
            } else {
                Element nestedBean = DomUtils.getChildElementByTagName((Element)element, (String)ELEMENT_BEAN);
                if (nestedBean != null) {
                    Object obj = parserContext.getDelegate().parsePropertySubElement(nestedBean, null, null);
                    factory.addPropertyValue(property, obj);
                } else {
                    throw new IllegalArgumentException(tagName + " must have either a " + refAttribute + " attribute or an embedded " + ELEMENT_BEAN + " child element!");
                }
            }
        }
    }
}

