/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.persistence;

import org.ldaptive.AddOperation;
import org.ldaptive.AddRequest;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DeleteOperation;
import org.ldaptive.DeleteRequest;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.beans.LdapEntryMapper;
import org.ldaptive.beans.persistence.LdapEntryManager;
import org.ldaptive.ext.MergeOperation;
import org.ldaptive.ext.MergeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLdapEntryManager<T>
implements LdapEntryManager<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LdapEntryMapper<T> ldapEntryMapper;
    private final ConnectionFactory connectionFactory;
    private final String[] returnAttributes;

    public DefaultLdapEntryManager(LdapEntryMapper<T> mapper, ConnectionFactory factory) {
        this(mapper, factory, null);
    }

    public DefaultLdapEntryManager(LdapEntryMapper<T> mapper, ConnectionFactory factory, String[] attrs) {
        this.ldapEntryMapper = mapper;
        this.connectionFactory = factory;
        this.returnAttributes = attrs;
    }

    public LdapEntryMapper<T> getLdapEntryMapper() {
        return this.ldapEntryMapper;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public String[] getReturnAttributes() {
        return this.returnAttributes;
    }

    @Override
    public T find(T object) throws LdapException {
        String dn = this.getLdapEntryMapper().mapDn(object);
        Object[] attrs = ReturnAttributes.ALL.value();
        if (this.returnAttributes != null) {
            attrs = (String[])LdapUtils.concatArrays((Object[])attrs, (Object[][])new String[][]{this.returnAttributes});
        }
        SearchRequest request = SearchRequest.newObjectScopeSearchRequest((String)dn, (String[])attrs);
        try (Connection conn = this.getConnectionFactory().getConnection();){
            conn.open();
            SearchOperation search = new SearchOperation(conn);
            Response response = search.execute((Request)request);
            if (((SearchResult)response.getResult()).size() == 0) {
                throw new IllegalArgumentException(String.format("Unable to find ldap entry %s, no entries returned: %s", dn, response));
            }
            if (((SearchResult)response.getResult()).size() > 1) {
                throw new IllegalArgumentException(String.format("Unable to find ldap entry %s, multiple entries returned: %s", dn, response));
            }
            this.getLdapEntryMapper().map(((SearchResult)response.getResult()).getEntry(), object);
        }
        return object;
    }

    @Override
    public Response<Void> add(T object) throws LdapException {
        LdapEntry entry = new LdapEntry();
        this.getLdapEntryMapper().map(object, entry);
        AddRequest request = new AddRequest(entry.getDn(), entry.getAttributes());
        try (Connection conn = this.getConnectionFactory().getConnection();){
            conn.open();
            AddOperation add = new AddOperation(conn);
            Response response = add.execute((Request)request);
            return response;
        }
    }

    @Override
    public Response<Void> merge(T object) throws LdapException {
        LdapEntry entry = new LdapEntry();
        this.getLdapEntryMapper().map(object, entry);
        MergeRequest request = new MergeRequest(entry);
        try (Connection conn = this.getConnectionFactory().getConnection();){
            conn.open();
            MergeOperation merge = new MergeOperation(conn);
            Response response = merge.execute((Request)request);
            return response;
        }
    }

    @Override
    public Response<Void> delete(T object) throws LdapException {
        String dn = this.getLdapEntryMapper().mapDn(object);
        DeleteRequest request = new DeleteRequest(dn);
        try (Connection conn = this.getConnectionFactory().getConnection();){
            conn.open();
            DeleteOperation delete = new DeleteOperation(conn);
            Response response = delete.execute((Request)request);
            return response;
        }
    }
}

