/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.reflect;

import java.util.Collection;
import java.util.Collections;
import org.ldaptive.beans.AttributeValueMutator;
import org.ldaptive.beans.DnValueMutator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDnValueMutator
implements DnValueMutator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AttributeValueMutator dnMutator;

    public DefaultDnValueMutator(AttributeValueMutator mutator) {
        this.dnMutator = mutator;
    }

    @Override
    public String getValue(Object object) {
        Collection<String> c = this.dnMutator.getStringValues(object);
        if (c != null && !c.isEmpty()) {
            return c.iterator().next();
        }
        return null;
    }

    @Override
    public void setValue(Object object, String value) {
        this.dnMutator.setStringValues(object, Collections.singletonList(value));
    }

    public String toString() {
        return String.format("[%s@%d::dnMutator=%s]", this.getClass().getName(), this.hashCode(), this.dnMutator);
    }
}

