/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.spring.parser;

import org.ldaptive.beans.spring.parser.AbstractAuthenticatorBeanDefinitionParser;
import org.ldaptive.beans.spring.parser.AbstractConnectionFactoryBeanDefinitionParser;
import org.ldaptive.pool.BlockingConnectionPool;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.pool.PoolConfig;
import org.ldaptive.pool.SearchValidator;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public abstract class AbstractConnectionPoolBeanDefinitionParser
extends AbstractConnectionFactoryBeanDefinitionParser {
    protected BeanDefinitionBuilder parseConnectionPool(BeanDefinitionBuilder builder, String name, Element element, boolean includeConnectionInitializer) {
        BeanDefinitionBuilder pool = builder;
        if (pool == null) {
            pool = BeanDefinitionBuilder.genericBeanDefinition(BlockingConnectionPool.class);
        }
        pool.addPropertyValue("name", (Object)name);
        pool.addPropertyValue("connectionFactory", (Object)this.parseDefaultConnectionFactory(null, element, includeConnectionInitializer).getBeanDefinition());
        pool.addPropertyValue("poolConfig", (Object)this.parsePoolConfig(null, element).getBeanDefinition());
        BeanDefinitionBuilder blockWaitTime = BeanDefinitionBuilder.rootBeanDefinition(AbstractAuthenticatorBeanDefinitionParser.class, (String)"parseDuration");
        blockWaitTime.addConstructorArgValue((Object)element.getAttribute("blockWaitTime"));
        pool.addPropertyValue("blockWaitTime", (Object)blockWaitTime.getBeanDefinition());
        pool.addPropertyValue("failFastInitialize", (Object)element.getAttribute("failFastInitialize"));
        BeanDefinitionBuilder pruneStrategy = BeanDefinitionBuilder.genericBeanDefinition(IdlePruneStrategy.class);
        BeanDefinitionBuilder prunePeriod = BeanDefinitionBuilder.rootBeanDefinition(AbstractAuthenticatorBeanDefinitionParser.class, (String)"parseDuration");
        prunePeriod.addConstructorArgValue((Object)element.getAttribute("prunePeriod"));
        BeanDefinitionBuilder idleTime = BeanDefinitionBuilder.rootBeanDefinition(AbstractAuthenticatorBeanDefinitionParser.class, (String)"parseDuration");
        idleTime.addConstructorArgValue((Object)element.getAttribute("idleTime"));
        pruneStrategy.addPropertyValue("prunePeriod", (Object)prunePeriod.getBeanDefinition());
        pruneStrategy.addPropertyValue("idleTime", (Object)idleTime.getBeanDefinition());
        pool.addPropertyValue("pruneStrategy", (Object)pruneStrategy.getBeanDefinition());
        pool.addPropertyValue("validator", (Object)new SearchValidator());
        if (element.hasAttribute("ldapUrl")) {
            pool.setInitMethodName("initialize");
        } else {
            this.logger.info("No ldapUrl attribute found for element {}, pool not initialized.", (Object)name);
        }
        return pool;
    }

    protected BeanDefinitionBuilder parsePoolConfig(BeanDefinitionBuilder builder, Element element) {
        BeanDefinitionBuilder poolConfig = builder;
        if (poolConfig == null) {
            poolConfig = BeanDefinitionBuilder.genericBeanDefinition(PoolConfig.class);
        }
        poolConfig.addPropertyValue("minPoolSize", (Object)element.getAttribute("minPoolSize"));
        poolConfig.addPropertyValue("maxPoolSize", (Object)element.getAttribute("maxPoolSize"));
        poolConfig.addPropertyValue("validateOnCheckOut", (Object)element.getAttribute("validateOnCheckOut"));
        poolConfig.addPropertyValue("validatePeriodically", (Object)element.getAttribute("validatePeriodically"));
        BeanDefinitionBuilder validatePeriod = BeanDefinitionBuilder.rootBeanDefinition(AbstractAuthenticatorBeanDefinitionParser.class, (String)"parseDuration");
        validatePeriod.addConstructorArgValue((Object)element.getAttribute("validatePeriod"));
        poolConfig.addPropertyValue("validatePeriod", (Object)validatePeriod.getBeanDefinition());
        return poolConfig;
    }
}

