/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.analyzer.v5x;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.lionsoul.jcseg.analyzer.v5x.JcsegFilter;
import org.lionsoul.jcseg.analyzer.v5x.JcsegTokenizer;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.DictionaryFactory;
import org.lionsoul.jcseg.tokenizer.core.JcsegException;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;

public class JcsegAnalyzer5X
extends Analyzer {
    private int mode;
    private JcsegTaskConfig config = null;
    private ADictionary dic = null;

    public JcsegAnalyzer5X(int mode) {
        this(mode, new JcsegTaskConfig(true));
    }

    public JcsegAnalyzer5X(int mode, String proFile) {
        this(mode, new JcsegTaskConfig(proFile));
    }

    public JcsegAnalyzer5X(int mode, JcsegTaskConfig config) {
        this(mode, config, DictionaryFactory.createSingletonDictionary((JcsegTaskConfig)config));
    }

    public JcsegAnalyzer5X(int mode, JcsegTaskConfig config, ADictionary dic) {
        this.mode = mode;
        this.config = config;
        this.dic = dic;
    }

    public void setConfig(JcsegTaskConfig config) {
        this.config = config;
    }

    public void setDict(ADictionary dic) {
        this.dic = dic;
    }

    public JcsegTaskConfig getTaskConfig() {
        return this.config;
    }

    public ADictionary getDict() {
        return this.dic;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        try {
            JcsegTokenizer tokenizer = new JcsegTokenizer(this.mode, this.config, this.dic);
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new JcsegFilter((TokenStream)tokenizer));
        }
        catch (JcsegException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

