/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.analyzer.v5x;

import java.io.IOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.ISegment;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.tokenizer.core.JcsegException;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;
import org.lionsoul.jcseg.tokenizer.core.SegmentFactory;

public class JcsegTokenizer
extends Tokenizer {
    private ISegment segmentor;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

    public JcsegTokenizer(int mode, JcsegTaskConfig config, ADictionary dic) throws JcsegException, IOException {
        this.segmentor = SegmentFactory.createJcseg((int)mode, (Object[])new Object[]{config, dic});
        this.segmentor.reset(this.input);
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        IWord word = this.segmentor.next();
        if (word == null) {
            this.end();
            return false;
        }
        char[] token = word.getValue().toCharArray();
        this.termAtt.copyBuffer(token, 0, token.length);
        this.offsetAtt.setOffset(word.getPosition(), word.getPosition() + word.getLength());
        this.typeAtt.setType("word");
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.segmentor.reset(this.input);
    }
}

