/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.analyzer.v5x;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.lionsoul.jcseg.analyzer.v5x.JcsegTokenizer;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.DictionaryFactory;
import org.lionsoul.jcseg.tokenizer.core.JcsegException;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;

public class JcsegTokenizerFactory
extends TokenizerFactory {
    private int mode;
    private JcsegTaskConfig config = null;
    private ADictionary dic = null;

    public JcsegTokenizerFactory(Map<String, String> args) {
        super(args);
        String _mode = args.get("mode");
        this.mode = _mode == null ? 2 : ("simple".equals(_mode = _mode.toLowerCase()) ? 1 : ("detect".equals(_mode) ? 3 : ("search".equals(_mode) ? 4 : 2)));
        this.config = new JcsegTaskConfig(true);
        this.dic = DictionaryFactory.createSingletonDictionary((JcsegTaskConfig)this.config);
    }

    public void setConfig(JcsegTaskConfig config) {
        this.config = config;
    }

    public void setDict(ADictionary dic) {
        this.dic = dic;
    }

    public JcsegTaskConfig getTaskConfig() {
        return this.config;
    }

    public ADictionary getDict() {
        return this.dic;
    }

    public Tokenizer create(AttributeFactory factory) {
        try {
            return new JcsegTokenizer(this.mode, this.config, this.dic);
        }
        catch (JcsegException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

