/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.extractor.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.lionsoul.jcseg.extractor.KeywordsExtractor;
import org.lionsoul.jcseg.tokenizer.core.ISegment;
import org.lionsoul.jcseg.tokenizer.core.IWord;

public class TextRankKeywordsExtractor
extends KeywordsExtractor {
    public static final float D = 0.85f;
    protected int keywordsNum = 10;
    protected int maxIterateNum = 120;
    protected int windowSize = 5;
    protected boolean autoFilter = false;

    public TextRankKeywordsExtractor(ISegment seg) {
        super(seg);
    }

    @Override
    public List<String> getKeywords(Reader reader) throws IOException {
        HashMap winMap = new HashMap();
        ArrayList<String> words = new ArrayList<String>();
        IWord w = null;
        this.seg.reset(reader);
        while ((w = this.seg.next()) != null) {
            if (!this.filter(w)) continue;
            String word = w.getValue();
            if (!winMap.containsKey(word)) {
                winMap.put(word, new LinkedList());
            }
            words.add(word);
        }
        for (int i = 0; i < words.size(); ++i) {
            String word = (String)words.get(i);
            List support = (List)winMap.get(word);
            int sIdx = Math.max(0, i - this.windowSize);
            int eIdx = Math.min(i + this.windowSize, words.size() - 1);
            for (int j = sIdx; j <= eIdx; ++j) {
                if (j == i) continue;
                support.add(words.get(j));
            }
        }
        HashMap<String, Float> score = new HashMap<String, Float>();
        for (int c = 0; c < this.maxIterateNum; ++c) {
            for (Map.Entry entry : winMap.entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                float f = 0.0f;
                for (String ele : value) {
                    int size = ((List)winMap.get(ele)).size();
                    if (ele.equals(key) || size == 0) continue;
                    float Sy = 0.0f;
                    if (score != null && score.containsKey(ele)) {
                        Sy = ((Float)score.get(ele)).floatValue();
                    }
                    f += Sy / (float)size;
                }
                score.put(key, Float.valueOf(0.14999998f + 0.85f * f));
            }
        }
        ArrayList entryList = new ArrayList(score.entrySet());
        Collections.sort(entryList, new Comparator<Map.Entry<String, Float>>(){

            @Override
            public int compare(Map.Entry<String, Float> o1, Map.Entry<String, Float> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        float tScores = 0.0f;
        float avgScores = 0.0f;
        float stdScores = 0.0f;
        for (Map.Entry entry : entryList) {
            tScores += ((Float)entry.getValue()).floatValue();
        }
        avgScores = tScores / (float)words.size();
        stdScores = avgScores * 1.85f;
        int len = Math.min(this.keywordsNum, entryList.size());
        ArrayList<String> arrayList = new ArrayList<String>(len);
        for (int i = 0; i < entryList.size(); ++i) {
            Map.Entry e = (Map.Entry)entryList.get(i);
            if (i >= len || this.autoFilter && ((Float)e.getValue()).floatValue() < stdScores) break;
            arrayList.add((String)e.getKey());
        }
        winMap.clear();
        words.clear();
        winMap = null;
        words = null;
        score = null;
        entryList = null;
        return arrayList;
    }

    public int getKeywordsNum() {
        return this.keywordsNum;
    }

    public void setKeywordsNum(int keywordsNum) {
        this.keywordsNum = keywordsNum;
    }

    public int getMaxIterateNum() {
        return this.maxIterateNum;
    }

    public void setMaxIterateNum(int maxIterateNum) {
        this.maxIterateNum = maxIterateNum;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public boolean isAutoFilter() {
        return this.autoFilter;
    }

    public void setAutoFilter(boolean autoFilter) {
        this.autoFilter = autoFilter;
    }
}

