/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.extractor.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lionsoul.jcseg.extractor.SummaryExtractor;
import org.lionsoul.jcseg.tokenizer.Sentence;
import org.lionsoul.jcseg.tokenizer.SentenceSeg;
import org.lionsoul.jcseg.tokenizer.core.ISegment;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.util.IStringBuffer;
import org.lionsoul.jcseg.util.Sort;

public class TextRankSummaryExtractor
extends SummaryExtractor {
    public static final float D = 0.85f;
    public static final float K1 = 2.0f;
    public static final float B = 0.75f;
    protected int sentenceNum = 6;
    protected int maxIterateNum = 120;

    public TextRankSummaryExtractor(ISegment wordSeg, SentenceSeg sentenceSeg) {
        super(wordSeg, sentenceSeg);
    }

    List<Sentence> textToSentence(Reader reader) throws IOException {
        ArrayList<Sentence> sentence = new ArrayList<Sentence>();
        Sentence sen = null;
        this.sentenceSeg.reset(reader);
        while ((sen = this.sentenceSeg.next()) != null) {
            sentence.add(sen);
        }
        return sentence;
    }

    List<List<IWord>> sentenceTokenize(List<Sentence> sentence) throws IOException {
        ArrayList<List<IWord>> senWords = new ArrayList<List<IWord>>();
        for (Sentence sen : sentence) {
            ArrayList<IWord> words = new ArrayList<IWord>();
            this.wordSeg.reset(new StringReader(sen.getValue()));
            IWord word = null;
            while ((word = this.wordSeg.next()) != null) {
                words.add(word);
            }
            senWords.add(words);
        }
        return senWords;
    }

    /*
     * WARNING - void declaration
     */
    double[][] BM25RelevanceMatixBuild(List<Sentence> sentence, List<List<IWord>> senWords) {
        void var13_23;
        int docNum = sentence.size();
        double avgdl = 0.0;
        for (List<IWord> words : senWords) {
            avgdl += (double)words.size();
        }
        avgdl /= (double)docNum;
        Map[] tf = new Map[docNum];
        HashMap<IWord, Integer> df = new HashMap<IWord, Integer>();
        int index = 0;
        for (List<IWord> words : senWords) {
            HashMap<IWord, Integer> f = new HashMap<IWord, Integer>();
            for (IWord iWord : words) {
                f.put(iWord, f.containsKey(iWord) ? (Integer)f.get(iWord) + 1 : 1);
            }
            tf[index++] = f;
            for (Map.Entry entry : f.entrySet()) {
                IWord key;
                df.put(key, df.containsKey(key = (IWord)entry.getKey()) ? (Integer)df.get(key) + 1 : 1);
            }
        }
        HashMap<IWord, Double> idf = new HashMap<IWord, Double>();
        for (Map.Entry entry : df.entrySet()) {
            IWord key = (IWord)entry.getKey();
            int n = (Integer)df.get(key);
            idf.put(key, Math.log(((double)(docNum - n) + 0.5) / ((double)n + 0.5)));
        }
        double[][] scores = new double[docNum][docNum];
        for (int i = 0; i < docNum; ++i) {
            int j = 0;
            int n = senWords.get(i).size();
            double dlRelative = 2.0 * (0.25 + (double)(0.75f * (float)n) / avgdl);
            for (List<IWord> query : senWords) {
                double score = 0.0;
                for (IWord q : query) {
                    int fi = tf[i].containsKey(q) ? (Integer)tf[i].get(q) : 0;
                    double rel = (double)((float)fi * 3.0f) / ((double)fi + dlRelative);
                    score += (Double)idf.get(q) * rel;
                }
                scores[i][j++] = score;
            }
        }
        Map[] arr$ = tf;
        int len$ = arr$.length;
        boolean bl = false;
        while (var13_23 < len$) {
            Map m = arr$[var13_23];
            m.clear();
            ++var13_23;
        }
        tf = null;
        df.clear();
        df = null;
        idf.clear();
        idf = null;
        return scores;
    }

    static double sum(double[] score) {
        double r = 0.0;
        for (double d : score) {
            r += d;
        }
        return r;
    }

    protected Document[] textRankSortedDocuments(List<Sentence> sentence, List<List<IWord>> senWords) throws IOException {
        int i;
        int docNum = sentence.size();
        double[][] relevance = this.BM25RelevanceMatixBuild(sentence, senWords);
        double[] score = new double[docNum];
        double[] weight_sum = new double[docNum];
        for (int i2 = 0; i2 < docNum; ++i2) {
            weight_sum[i2] = TextRankSummaryExtractor.sum(relevance[i2]) - relevance[i2][i2];
            score[i2] = 0.0;
        }
        for (int c = 0; c < this.maxIterateNum; ++c) {
            for (i = 0; i < docNum; ++i) {
                double sigema = 0.0;
                for (int j = 0; j < docNum; ++j) {
                    if (i == j || weight_sum[j] == 0.0) continue;
                    sigema += relevance[j][i] / weight_sum[j] * score[j];
                }
                score[i] = 0.1499999761581421 + (double)0.85f * sigema;
            }
        }
        Comparable[] docs = new Document[docNum];
        for (i = 0; i < docNum; ++i) {
            docs[i] = new Document(i, sentence.get(i), senWords.get(i), score[i]);
        }
        Sort.shellSort((Comparable[])docs);
        relevance = null;
        score = null;
        weight_sum = null;
        return docs;
    }

    @Override
    public List<String> getKeySentence(Reader reader) throws IOException {
        List<Sentence> sentence = this.textToSentence(reader);
        if (sentence.size() == 1) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(sentence.get(0).getValue());
            return list;
        }
        List<List<IWord>> senWords = this.sentenceTokenize(sentence);
        int docNum = sentence.size();
        Document[] docs = this.textRankSortedDocuments(sentence, senWords);
        int len = Math.min(this.sentenceNum, docNum);
        ArrayList<String> topSentence = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            topSentence.add(docs[i].getSentence().getValue());
        }
        docs = null;
        sentence.clear();
        sentence = null;
        senWords.clear();
        senWords = null;
        return topSentence;
    }

    @Override
    public String getSummary(Reader reader, int length) throws IOException {
        int i;
        List<Sentence> sentence = this.textToSentence(reader);
        if (sentence.size() == 1) {
            String summary = sentence.get(0).getValue();
            return length >= summary.length() ? summary.substring(0) : summary.substring(0, length);
        }
        List<List<IWord>> senWords = this.sentenceTokenize(sentence);
        int docNum = sentence.size();
        Document[] docs = this.textRankSortedDocuments(sentence, senWords);
        int less = length;
        int sIdx = docs[0].getIndex();
        for (i = docs[0].getIndex(); i < docNum && (less -= sentence.get(i).getLength()) > 0; ++i) {
        }
        if (less > 0) {
            for (i = docs[0].getIndex() - 1; i >= 0; --i) {
                if ((less -= sentence.get(i).getLength()) > 0) continue;
                sIdx = i;
                break;
            }
            if (less > 0) {
                sIdx = 0;
            }
        }
        IStringBuffer isb = new IStringBuffer();
        for (int i2 = sIdx; i2 < docNum; ++i2) {
            int senLen = isb.length() + sentence.get(i2).getLength();
            if (senLen < length) {
                isb.append(sentence.get(i2).getValue());
                continue;
            }
            if (!(((float)length - (float)isb.length()) / (float)length >= 0.15f)) break;
            isb.append(sentence.get(i2).getValue());
        }
        docs = null;
        sentence.clear();
        sentence = null;
        senWords.clear();
        senWords = null;
        return isb.toString();
    }

    public int getSentenceNum() {
        return this.sentenceNum;
    }

    public void setSentenceNum(int sentenceNum) {
        this.sentenceNum = sentenceNum;
    }

    public int getMaxIterateNum() {
        return this.maxIterateNum;
    }

    public void setMaxIterateNum(int maxIterateNum) {
        this.maxIterateNum = maxIterateNum;
    }

    public class Document
    implements Comparable<Document> {
        private double score;
        private Sentence sentence;
        private int index;
        private List<IWord> words;

        public Document(int index, Sentence sentence, List<IWord> words, double score) {
            this.index = index;
            this.sentence = sentence;
            this.words = words;
            this.score = score;
        }

        public double getScore() {
            return this.score;
        }

        public void setScore(double score) {
            this.score = score;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public Sentence getSentence() {
            return this.sentence;
        }

        public void setSentence(Sentence sentence) {
            this.sentence = sentence;
        }

        public List<IWord> getWords() {
            return this.words;
        }

        public void setWords(List<IWord> words) {
            this.words = words;
        }

        @Override
        public int compareTo(Document o) {
            double v = o.getScore() - this.score;
            if (v > 0.0) {
                return 1;
            }
            if (v < 0.0) {
                return -1;
            }
            return 0;
        }
    }
}

