/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import org.lionsoul.jcseg.tokenizer.Word;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.IChunk;
import org.lionsoul.jcseg.tokenizer.core.ISegment;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;
import org.lionsoul.jcseg.util.IPushbackReader;
import org.lionsoul.jcseg.util.IStringBuffer;
import org.lionsoul.jcseg.util.IntArrayList;
import org.lionsoul.jcseg.util.NumericUtil;
import org.lionsoul.jcseg.util.StringUtil;

public abstract class ASegment
implements ISegment {
    protected int idx;
    protected IPushbackReader reader = null;
    protected LinkedList<IWord> wordPool = null;
    protected IStringBuffer isb;
    protected IntArrayList ialist;
    protected int ctrlMask = 0;
    protected ADictionary dic;
    protected JcsegTaskConfig config;

    public ASegment(Reader input, JcsegTaskConfig config, ADictionary dic) throws IOException {
        this.config = config;
        this.dic = dic;
        this.wordPool = new LinkedList();
        this.isb = new IStringBuffer(64);
        this.ialist = new IntArrayList(15);
        this.reset(input);
    }

    public ASegment(JcsegTaskConfig config, ADictionary dic) throws IOException {
        this(null, config, dic);
    }

    @Override
    public void reset(Reader input) throws IOException {
        if (input != null) {
            this.reader = new IPushbackReader(new BufferedReader(input));
        }
        this.idx = -1;
    }

    protected int readNext() throws IOException {
        int c = this.reader.read();
        if (c != -1) {
            ++this.idx;
        }
        return c;
    }

    protected void pushBack(int data) throws IOException {
        this.reader.unread(data);
        --this.idx;
    }

    @Override
    public int getStreamPosition() {
        return this.idx + 1;
    }

    public void setDict(ADictionary dic) {
        this.dic = dic;
    }

    public ADictionary getDict() {
        return this.dic;
    }

    public void setConfig(JcsegTaskConfig config) {
        this.config = config;
    }

    public JcsegTaskConfig getConfig() {
        return this.config;
    }

    @Override
    public IWord next() throws IOException {
        int c;
        if (this.wordPool.size() > 0) {
            return this.wordPool.remove();
        }
        IWord word = null;
        while ((c = this.readNext()) != -1) {
            String str;
            String val;
            if (StringUtil.isWhitespace(c)) continue;
            int pos = this.idx;
            if (StringUtil.isCJKChar(c)) {
                word = this.getNextCJKWord(c, pos);
            } else if (StringUtil.isEnChar(c)) {
                word = this.getNextLatinWord(c, pos);
            } else if (this.config.PPT_MAX_LENGTH > 0 && StringUtil.isPairPunctuation((char)c)) {
                word = this.getNextPunctuationPairWord(c, pos);
            } else if (StringUtil.isLetterNumber(c)) {
                val = this.nextLetterNumber(c);
                if (this.config.CLEAR_STOPWORD && this.dic.match(9, val)) continue;
                word = new Word(val, 7);
                word.setPartSpeech(IWord.NUMERIC_POSPEECH);
                word.setPosition(pos);
            } else if (StringUtil.isOtherNumber(c)) {
                val = this.nextOtherNumber(c);
                if (this.config.CLEAR_STOPWORD && this.dic.match(9, val)) continue;
                word = new Word(val, 7);
                word.setPartSpeech(IWord.NUMERIC_POSPEECH);
                word.setPosition(pos);
            } else if (StringUtil.isCnPunctuation(c)) {
                str = String.valueOf((char)c);
                if (this.config.CLEAR_STOPWORD && this.dic.match(9, str)) continue;
                word = new Word(str, 10);
                word.setPartSpeech(IWord.PUNCTUATION);
                word.setPosition(pos);
            } else if (this.config.KEEP_UNREG_WORDS) {
                str = String.valueOf((char)c);
                if (this.config.CLEAR_STOPWORD && this.dic.match(9, str)) continue;
                word = new Word(str, 11);
                word.setPartSpeech(IWord.UNRECOGNIZE);
                word.setPosition(pos);
            }
            if (word != null) {
                return word;
            }
            if (this.wordPool.size() <= 0) continue;
            return this.wordPool.removeFirst();
        }
        return null;
    }

    protected IWord getNextCJKWord(int c, int pos) throws IOException {
        char[] chars = this.nextCJKSentence(c);
        int cjkidx = 0;
        IWord w = null;
        while (cjkidx < chars.length) {
            StringBuilder sb;
            w = null;
            if (cjkidx + 1 < chars.length && NumericUtil.isCNNumeric(chars[cjkidx]) > -1) {
                String num = this.nextCNNumeric(chars, cjkidx);
                int NUMLEN = num.length();
                if ((this.ctrlMask & 2) != 0) {
                    w = new Word(num, 9);
                    w.setPosition(pos + cjkidx);
                    w.setPartSpeech(IWord.NUMERIC_POSPEECH);
                    this.wordPool.add(w);
                    if (this.config.CNFRA_TO_ARABIC) {
                        String[] split = num.split("\u5206\u4e4b");
                        Word wd = new Word(NumericUtil.cnNumericToArabic(split[1], true) + "/" + NumericUtil.cnNumericToArabic(split[0], true), 9);
                        wd.setPosition(w.getPosition());
                        wd.setPartSpeech(IWord.NUMERIC_POSPEECH);
                        this.wordPool.add(wd);
                    }
                } else if (NumericUtil.isCNNumeric(chars[cjkidx + 1]) > -1 || this.dic.match(1, chars[cjkidx + 1] + "")) {
                    sb = new StringBuilder();
                    String temp = null;
                    String ONUM = num;
                    sb.append(num);
                    boolean matched = false;
                    for (int j = num.length(); cjkidx + j < chars.length && j < this.config.MAX_LENGTH; ++j) {
                        sb.append(chars[cjkidx + j]);
                        temp = sb.toString();
                        if (!this.dic.match(0, temp)) continue;
                        w = this.dic.get(0, temp);
                        num = temp;
                        matched = true;
                    }
                    if (matched && num.length() - NUMLEN == 1 && this.dic.match(1, num.substring(NUMLEN))) {
                        num = ONUM;
                        matched = false;
                    }
                    Word wd = null;
                    if (!matched && this.config.CNNUM_TO_ARABIC) {
                        String arabic = NumericUtil.cnNumericToArabic(num, true) + "";
                        if (cjkidx + num.length() < chars.length && this.dic.match(1, chars[cjkidx + num.length()] + "")) {
                            char units = chars[cjkidx + num.length()];
                            num = num + units;
                            arabic = arabic + units;
                        }
                        wd = new Word(arabic, 9);
                        wd.setPartSpeech(IWord.NUMERIC_POSPEECH);
                        wd.setPosition(pos + cjkidx);
                    }
                    if (this.config.CLEAR_STOPWORD && this.dic.match(9, num)) {
                        cjkidx += num.length();
                        continue;
                    }
                    if (w == null) {
                        w = new Word(num, 9);
                        w.setPartSpeech(IWord.NUMERIC_POSPEECH);
                    } else {
                        w = w.clone();
                    }
                    w.setPosition(pos + cjkidx);
                    this.wordPool.add(w);
                    if (wd != null) {
                        this.wordPool.add(wd);
                    }
                }
                if (w != null) {
                    cjkidx += w.getLength();
                    this.appendWordFeatures(w);
                    continue;
                }
            }
            IChunk chunk = this.getBestCJKChunk(chars, cjkidx);
            w = chunk.getWords()[0];
            int T = -1;
            if (this.config.I_CN_NAME && w.getLength() <= 2 && chunk.getWords().length > 1) {
                sb = new StringBuilder();
                sb.append(w.getValue());
                String str = null;
                if (this.dic.match(3, w.getValue()) && (str = this.findCHName(chars, 0, chunk)) != null) {
                    T = 3;
                    sb.append(str);
                } else if (this.dic.match(7, w.getValue()) && chunk.getWords()[1].getLength() <= 2 && this.dic.match(3, chunk.getWords()[1].getValue())) {
                    T = 4;
                    sb.append(chunk.getWords()[1].getValue());
                }
                if (T != -1) {
                    w = new Word(sb.toString(), T);
                    w.setPartSpeech(IWord.NAME_POSPEECH);
                }
            }
            if (this.config.CLEAR_STOPWORD && this.dic.match(9, w.getValue())) {
                cjkidx += w.getLength();
                continue;
            }
            IWord enAfter = null;
            IWord ce = null;
            if ((this.ctrlMask & 1) != 0 && cjkidx + w.getLength() >= chars.length) {
                enAfter = this.nextBasicLatin(this.readNext());
                String cestr = w.getValue() + enAfter.getValue();
                if (!(this.config.CLEAR_STOPWORD && this.dic.match(9, cestr) || !this.dic.match(10, cestr))) {
                    ce = this.dic.get(10, cestr).clone();
                    ce.setPosition(pos + cjkidx);
                    this.wordPool.add(ce);
                    cjkidx += w.getLength();
                    enAfter = null;
                }
            }
            if (ce == null) {
                if (T == -1) {
                    w = w.clone();
                }
                w.setPosition(pos + cjkidx);
                this.wordPool.add(w);
                cjkidx += w.getLength();
            } else {
                w = ce;
            }
            if (T == -1) {
                this.appendWordFeatures(w);
            }
            if (enAfter == null || this.config.CLEAR_STOPWORD && this.dic.match(9, enAfter.getValue())) continue;
            enAfter.setPosition(pos + chars.length);
            if (this.config.EN_SECOND_SEG && (this.ctrlMask & 4) != 0) {
                this.enSecondSeg(enAfter, false);
            }
            this.wordPool.add(enAfter);
            if (!this.config.APPEND_CJK_SYN) continue;
            this.appendLatinSyn(enAfter);
        }
        if (this.wordPool.size() == 0) {
            return null;
        }
        return this.wordPool.remove();
    }

    protected IWord getNextLatinWord(int c, int pos) throws IOException {
        if (StringUtil.isEnPunctuation(c)) {
            String str = String.valueOf((char)c);
            if (this.config.CLEAR_STOPWORD && this.dic.match(9, str)) {
                return null;
            }
            Word w = new Word(str, 10);
            w.setPosition(pos);
            w.setPartSpeech(IWord.PUNCTUATION);
            return w;
        }
        IWord w = this.nextBasicLatin(c);
        w.setPosition(pos);
        if (this.config.EN_SECOND_SEG && (this.ctrlMask & 4) != 0) {
            this.enSecondSeg(w, false);
        }
        if (this.config.CLEAR_STOPWORD && this.dic.match(9, w.getValue())) {
            w = null;
            return null;
        }
        if (this.config.APPEND_CJK_SYN) {
            this.appendLatinSyn(w);
        }
        return w;
    }

    protected IWord getNextPunctuationPairWord(int c, int pos) throws IOException {
        Word w = null;
        Word w2 = null;
        String text = this.getPairPunctuationText(c);
        String str = String.valueOf((char)c);
        if (!this.config.CLEAR_STOPWORD || !this.dic.match(9, str)) {
            w = new Word(str, 10);
            w.setPartSpeech(IWord.PUNCTUATION);
            w.setPosition(pos);
        }
        if (!(text == null || this.config.CLEAR_STOPWORD && this.dic.match(9, text))) {
            w2 = new Word(text, 0);
            w2.setPartSpeech(IWord.PPT_POSPEECH);
            w2.setPosition(pos + 1);
            if (w == null) {
                w = w2;
            } else {
                this.wordPool.add(w2);
            }
        }
        if (w == null && w2 == null) {
            return null;
        }
        return w;
    }

    protected void appendWordFeatures(IWord word) {
        if (this.config.APPEND_CJK_PINYIN && this.config.LOAD_CJK_PINYIN && word.getPinyin() != null) {
            Word pinyin = new Word(word.getPinyin(), 8);
            pinyin.setPosition(word.getPosition());
            this.wordPool.add(pinyin);
        }
        String[] syns = null;
        Word syn = null;
        if (this.config.APPEND_CJK_SYN && this.config.LOAD_CJK_SYN && (syns = word.getSyn()) != null) {
            for (int j = 0; j < syns.length; ++j) {
                syn = new Word(syns[j], word.getType());
                syn.setPartSpeech(word.getPartSpeech());
                syn.setPosition(word.getPosition());
                this.wordPool.add(syn);
            }
        }
    }

    protected void appendLatinSyn(IWord w) {
        IWord ew = w.getSyn() == null ? this.dic.get(11, w.getValue()) : w;
        if (ew != null && ew.getSyn() != null) {
            Word sw = null;
            String[] syns = ew.getSyn();
            for (int j = 0; j < syns.length; ++j) {
                sw = new Word(syns[j], w.getType());
                sw.setPartSpeech(w.getPartSpeech());
                sw.setPosition(w.getPosition());
                this.wordPool.add(sw);
            }
        }
    }

    protected IWord enSecondSeg(IWord w, boolean retfw) {
        int j;
        this.isb.clear();
        char[] chars = w.getValue().toCharArray();
        int _TYPE = StringUtil.getEnCharType(chars[0]);
        int start = 0;
        int p = 0;
        this.isb.append(chars[0]);
        Word sword = null;
        Word fword = null;
        String _str = null;
        for (j = 1; j < chars.length; ++j) {
            int _ctype = StringUtil.getEnCharType(chars[j]);
            if (_ctype == 2) {
                _TYPE = 2;
                ++p;
                continue;
            }
            if (_ctype == _TYPE) {
                this.isb.append(chars[j]);
                continue;
            }
            start = j - this.isb.length() - p;
            if (this.isb.length() >= this.config.STOKEN_MIN_LEN) {
                _str = this.isb.toString();
                if (!this.config.CLEAR_STOPWORD || !this.dic.match(9, _str)) {
                    sword = new Word(_str, w.getType());
                    sword.setPartSpeech(w.getPartSpeech());
                    sword.setPosition(w.getPosition() + start);
                    if (retfw && fword == null) {
                        fword = sword;
                    } else {
                        this.wordPool.add(sword);
                    }
                }
            }
            this.isb.clear();
            this.isb.append(chars[j]);
            p = 0;
            _TYPE = _ctype;
        }
        if (this.isb.length() >= this.config.STOKEN_MIN_LEN) {
            start = j - this.isb.length() - p;
            _str = this.isb.toString();
            if (!this.config.CLEAR_STOPWORD || !this.dic.match(9, _str)) {
                sword = new Word(_str, w.getType());
                sword.setPartSpeech(w.getPartSpeech());
                sword.setPosition(w.getPosition() + start);
                if (retfw && fword == null) {
                    fword = sword;
                } else {
                    this.wordPool.add(sword);
                }
            }
        }
        chars = null;
        return fword;
    }

    protected IWord[] getNextMatch(char[] chars, int index) {
        ArrayList<IWord> mList = new ArrayList<IWord>(8);
        this.isb.clear();
        char c = chars[index];
        this.isb.append(c);
        String temp = this.isb.toString();
        if (this.dic.match(0, temp)) {
            mList.add(this.dic.get(0, temp));
        }
        String _key = null;
        for (int j = 1; j < this.config.MAX_LENGTH && j + index < chars.length; ++j) {
            this.isb.append(chars[j + index]);
            _key = this.isb.toString();
            if (!this.dic.match(0, _key)) continue;
            mList.add(this.dic.get(0, _key));
        }
        if (mList.isEmpty()) {
            mList.add(new Word(temp, 15));
        }
        IWord[] words = new IWord[mList.size()];
        mList.toArray(words);
        mList.clear();
        return words;
    }

    protected String findCHName(char[] chars, int index, IChunk chunk) {
        StringBuilder isb = new StringBuilder();
        if (chunk.getWords().length == 2) {
            IWord w = chunk.getWords()[1];
            switch (w.getLength()) {
                case 1: {
                    if (this.dic.match(4, w.getValue())) {
                        isb.append(w.getValue());
                        return isb.toString();
                    }
                    return null;
                }
                case 2: 
                case 3: {
                    IWord iw;
                    String d1 = new String(w.getValue().charAt(0) + "");
                    String d2 = new String(w.getValue().charAt(1) + "");
                    if (this.dic.match(5, d1) && this.dic.match(6, d2)) {
                        isb.append(d1);
                        isb.append(d2);
                        return isb.toString();
                    }
                    if (this.dic.match(4, d1) && (iw = this.dic.get(0, d2)) != null && iw.getFrequency() >= this.config.NAME_SINGLE_THRESHOLD) {
                        isb.append(d1);
                        return isb.toString();
                    }
                    return null;
                }
            }
        } else {
            IWord w1 = chunk.getWords()[1];
            IWord w2 = chunk.getWords()[2];
            switch (w1.getLength()) {
                case 1: {
                    if (this.dic.match(5, w1.getValue())) {
                        if (w2.getLength() == 1) {
                            if (this.dic.match(6, w2.getValue())) {
                                isb.append(w1.getValue());
                                isb.append(w2.getValue());
                                return isb.toString();
                            }
                            if (this.dic.match(4, w1.getValue())) {
                                isb.append(w1.getValue());
                                return isb.toString();
                            }
                        } else {
                            String d1 = new String(w2.getValue().charAt(0) + "");
                            int index_ = index + chunk.getWords()[0].getLength() + 2;
                            IWord[] ws = this.getNextMatch(chars, index_);
                            if (this.dic.match(6, d1) && (ws.length > 1 || ws[0].getFrequency() >= this.config.NAME_SINGLE_THRESHOLD)) {
                                isb.append(w1.getValue());
                                isb.append(d1);
                                return isb.toString();
                            }
                            if (this.dic.match(4, w1.getValue())) {
                                isb.append(w1.getValue());
                                return isb.toString();
                            }
                        }
                    } else if (this.dic.match(4, w1.getValue())) {
                        isb.append(w1.getValue());
                        return isb.toString();
                    }
                    return null;
                }
                case 2: {
                    IWord iw;
                    String d1 = new String(w1.getValue().charAt(0) + "");
                    String d2 = new String(w1.getValue().charAt(1) + "");
                    if (this.dic.match(5, d1) && this.dic.match(6, d2)) {
                        isb.append(w1.getValue());
                        return isb.toString();
                    }
                    if (this.dic.match(4, d1) && (iw = this.dic.get(0, d2)) != null && iw.getFrequency() >= this.config.NAME_SINGLE_THRESHOLD) {
                        isb.append(d1);
                        return isb.toString();
                    }
                    return null;
                }
                case 3: {
                    String c1 = new String(w1.getValue().charAt(0) + "");
                    String c2 = new String(w1.getValue().charAt(1) + "");
                    IWord w3 = this.dic.get(0, w1.getValue().charAt(2) + "");
                    if (this.dic.match(5, c1) && this.dic.match(6, c2) && (w3 == null || w3.getFrequency() >= this.config.NAME_SINGLE_THRESHOLD)) {
                        isb.append(c1);
                        isb.append(c2);
                        return isb.toString();
                    }
                    return null;
                }
            }
        }
        return null;
    }

    @Deprecated
    public boolean findCHName(IWord w, IChunk chunk) {
        String s1 = new String(w.getValue().charAt(0) + "");
        String s2 = new String(w.getValue().charAt(1) + "");
        if (this.dic.match(3, s1) && this.dic.match(5, s2)) {
            IWord sec = chunk.getWords()[1];
            switch (sec.getLength()) {
                case 1: {
                    if (this.dic.match(6, sec.getValue())) {
                        return true;
                    }
                }
                case 2: {
                    String d1 = new String(sec.getValue().charAt(0) + "");
                    IWord _w = this.dic.get(0, sec.getValue().charAt(1) + "");
                    if (!this.dic.match(6, d1) || _w != null && _w.getFrequency() < this.config.NAME_SINGLE_THRESHOLD) break;
                    return true;
                }
            }
        }
        return false;
    }

    protected char[] nextCJKSentence(int c) throws IOException {
        int ch;
        this.isb.clear();
        this.isb.append((char)c);
        this.ctrlMask &= 0xFFFFFFFE;
        while ((ch = this.readNext()) != -1) {
            if (StringUtil.isWhitespace(ch)) {
                this.pushBack(ch);
                break;
            }
            if (!StringUtil.isCJKChar(ch)) {
                this.pushBack(ch);
                if (!StringUtil.isEnLetter(ch) && !StringUtil.isEnNumeric(ch)) break;
                this.ctrlMask |= 1;
                break;
            }
            this.isb.append((char)ch);
        }
        return this.isb.toString().toCharArray();
    }

    protected IWord nextBasicLatin(int c) throws IOException {
        boolean ssseg;
        int ch;
        this.isb.clear();
        if (c > 65280) {
            c -= 65248;
        }
        if (c >= 65 && c <= 90) {
            c += 32;
        }
        this.isb.append((char)c);
        boolean _check = false;
        boolean _wspace = false;
        int _ctype = 0;
        int tcount = 1;
        int _TYPE = StringUtil.getEnCharType(c);
        this.ctrlMask &= 0xFFFFFFFB;
        while ((ch = this.readNext()) != -1) {
            if (ch > 65280) {
                ch -= 65248;
            }
            if ((_ctype = StringUtil.getEnCharType(ch)) == 3) {
                _wspace = true;
                break;
            }
            if (_ctype == 2 && !this.config.isKeepPunctuation((char)ch)) {
                this.pushBack(ch);
                break;
            }
            if (_ctype == -1) {
                this.pushBack(ch);
                if (!StringUtil.isCJKChar(ch)) break;
                _check = true;
                break;
            }
            if (ch >= 65 && ch <= 90) {
                ch += 32;
            }
            this.isb.append((char)ch);
            if (_ctype == _TYPE) continue;
            ++tcount;
            _TYPE = _ctype;
        }
        String __str = this.isb.toString();
        IWord w = null;
        boolean chkunits = true;
        _ctype = 0;
        for (int t = this.isb.length() - 1; t > 0 && this.isb.charAt(t) != '%' && StringUtil.isEnPunctuation(this.isb.charAt(t)); --t) {
            if (this.dic.match(8, __str)) {
                w = this.dic.get(8, __str).clone();
                w.setPartSpeech(IWord.EN_POSPEECH);
                chkunits = false;
                break;
            }
            this.pushBack(this.isb.charAt(t));
            this.isb.deleteCharAt(t);
            __str = this.isb.toString();
            if (_ctype != 0) continue;
            --tcount;
            _ctype = 1;
        }
        boolean bl = ssseg = tcount > 1 && chkunits;
        if (ch == -1 || _wspace) {
            w = new Word(__str, 5);
            w.setPartSpeech(IWord.EN_POSPEECH);
            if (ssseg) {
                this.ctrlMask |= 4;
            }
            return w;
        }
        if (!_check) {
            if (chkunits && (StringUtil.isDigit(__str) || StringUtil.isDecimal(__str))) {
                ch = this.readNext();
                if (this.dic.match(1, (char)ch + "")) {
                    w = new Word(new String(__str + (char)ch), 2);
                    w.setPartSpeech(IWord.NUMERIC_POSPEECH);
                } else {
                    this.pushBack(ch);
                }
            }
            if (w == null) {
                w = new Word(__str, 5);
                w.setPartSpeech(IWord.EN_POSPEECH);
                if (ssseg) {
                    this.ctrlMask |= 4;
                }
            }
            return w;
        }
        IStringBuffer ibuffer = new IStringBuffer();
        ibuffer.append(__str);
        String _temp = null;
        int mc = 0;
        this.ialist.clear();
        for (int j = 0; j < this.config.MIX_CN_LENGTH && (ch = this.readNext()) != -1; ++j) {
            if (StringUtil.isWhitespace(ch)) {
                this.pushBack(ch);
                break;
            }
            ibuffer.append((char)ch);
            this.ialist.add(ch);
            _temp = ibuffer.toString();
            if (!this.dic.match(2, _temp)) continue;
            w = this.dic.get(2, _temp);
            mc = j + 1;
        }
        ibuffer.clear();
        ibuffer = null;
        for (int i = j - 1; i >= mc; --i) {
            this.pushBack(this.ialist.get(i));
        }
        if (chkunits && mc == 0 && (StringUtil.isDigit(__str) || StringUtil.isDecimal(__str))) {
            ch = this.readNext();
            if (this.dic.match(1, (char)ch + "")) {
                w = new Word(new String(__str + (char)ch), 2);
                w.setPartSpeech(IWord.NUMERIC_POSPEECH);
            } else {
                this.pushBack(ch);
            }
        }
        if (w == null) {
            w = new Word(__str, 5);
            w.setPartSpeech(IWord.EN_POSPEECH);
            if (ssseg) {
                this.ctrlMask |= 4;
            }
        } else if (mc > 0) {
            w = w.clone();
        }
        return w;
    }

    protected String nextLetterNumber(int c) throws IOException {
        int ch;
        this.isb.clear();
        this.isb.append((char)c);
        while ((ch = this.readNext()) != -1) {
            if (StringUtil.isWhitespace(ch)) {
                this.pushBack(ch);
                break;
            }
            if (!StringUtil.isLetterNumber(ch)) {
                this.pushBack(ch);
                break;
            }
            this.isb.append((char)ch);
        }
        return this.isb.toString();
    }

    protected String nextOtherNumber(int c) throws IOException {
        int ch;
        this.isb.clear();
        this.isb.append((char)c);
        while ((ch = this.readNext()) != -1) {
            if (StringUtil.isWhitespace(ch)) {
                this.pushBack(ch);
                break;
            }
            if (!StringUtil.isOtherNumber(ch)) {
                this.pushBack(ch);
                break;
            }
            this.isb.append((char)ch);
        }
        return this.isb.toString();
    }

    protected String nextCNNumeric(char[] chars, int index) throws IOException {
        this.isb.clear();
        this.isb.append(chars[index]);
        this.ctrlMask &= 0xFFFFFFFD;
        for (int j = index + 1; j < chars.length; ++j) {
            if (NumericUtil.isCNNumeric(chars[j]) == -1) {
                if (j + 2 >= chars.length || chars[j] != '\u5206' || chars[j + 1] != '\u4e4b' || NumericUtil.isCNNumeric(chars[j + 2]) == -1) break;
                this.isb.append(chars[j++]);
                this.isb.append(chars[j++]);
                this.isb.append(chars[j]);
                this.ctrlMask |= 2;
                continue;
            }
            this.isb.append(chars[j]);
        }
        return this.isb.toString();
    }

    protected String getPairPunctuationText(int c) throws IOException {
        int ch;
        this.isb.clear();
        char echar = StringUtil.getPunctuationPair((char)c);
        boolean matched = false;
        this.ialist.clear();
        for (int j = 0; j < this.config.PPT_MAX_LENGTH && (ch = this.readNext()) != -1; ++j) {
            if (ch == echar) {
                matched = true;
                this.pushBack(ch);
                break;
            }
            this.isb.append((char)ch);
            this.ialist.add(ch);
        }
        if (!matched) {
            for (int i = j - 1; i >= 0; --i) {
                this.pushBack(this.ialist.get(i));
            }
            return null;
        }
        return this.isb.toString();
    }

    protected abstract IChunk getBestCJKChunk(char[] var1, int var2) throws IOException;
}

