/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lionsoul.jcseg.tokenizer.Word;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;

public class Dictionary
extends ADictionary {
    private Map<String, IWord>[] dics = new Map[12];

    public Dictionary(JcsegTaskConfig config, Boolean sync) {
        super(config, sync);
        if (this.sync) {
            for (int j = 0; j < 12; ++j) {
                this.dics[j] = new ConcurrentHashMap<String, IWord>(16, 0.8f);
            }
        } else {
            for (int j = 0; j < 12; ++j) {
                this.dics[j] = new HashMap<String, IWord>(16, 0.8f);
            }
        }
    }

    @Override
    public boolean match(int t, String key) {
        if (t < 0 || t >= 12) {
            return false;
        }
        return this.dics[t].containsKey(key);
    }

    @Override
    public void add(int t, String key, int type) {
        if (t < 0 || t >= 12) {
            return;
        }
        if (this.dics[t].get(key) == null) {
            this.dics[t].put(key, new Word(key, type));
        }
    }

    @Override
    public void add(int t, String key, int fre, int type) {
        if (t < 0 || t >= 12) {
            return;
        }
        if (this.dics[t].get(key) == null) {
            this.dics[t].put(key, new Word(key, fre, type));
        }
    }

    @Override
    public IWord get(int t, String key) {
        if (t < 0 || t >= 12) {
            return null;
        }
        return this.dics[t].get(key);
    }

    @Override
    public void remove(int t, String key) {
        if (t < 0 || t >= 12) {
            return;
        }
        this.dics[t].remove(key);
    }

    @Override
    public int size(int t) {
        if (t < 0 || t >= 12) {
            return 0;
        }
        return this.dics[t].size();
    }
}

