/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.lionsoul.jcseg.tokenizer.ASegment;
import org.lionsoul.jcseg.tokenizer.Word;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.IChunk;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;

public class SearchSeg
extends ASegment {
    public SearchSeg(JcsegTaskConfig config, ADictionary dic) throws IOException {
        super(config, dic);
    }

    public SearchSeg(Reader input, JcsegTaskConfig config, ADictionary dic) throws IOException {
        super(input, config, dic);
    }

    @Override
    protected IWord getNextCJKWord(int c, int pos) throws IOException {
        String key = null;
        char[] chars = this.nextCJKSentence(c);
        int cjkidx = 0;
        int ignidx = 0;
        boolean mnum = false;
        IWord word = null;
        ArrayList<IWord> mList = new ArrayList<IWord>(8);
        while (cjkidx < chars.length) {
            mnum = false;
            this.isb.clear().append(chars[cjkidx]);
            for (int j = 1; j < this.config.MAX_LENGTH && cjkidx + j < chars.length; ++j) {
                this.isb.append(chars[cjkidx + j]);
                key = this.isb.toString();
                if (!this.dic.match(0, key)) continue;
                mnum = true;
                ignidx = Math.max(ignidx, cjkidx + j);
                word = this.dic.get(0, key).clone();
                word.setPosition(pos + cjkidx);
                mList.add(word);
            }
            if (!(mnum || cjkidx != 0 && cjkidx <= ignidx)) {
                String temp = String.valueOf(chars[cjkidx]);
                if (!this.dic.match(0, temp)) {
                    word = new Word(temp, 15);
                    word.setPosition(pos + cjkidx);
                    mList.add(new Word(temp, 15));
                } else {
                    word = this.dic.get(0, temp).clone();
                    word.setPosition(pos + cjkidx);
                    mList.add(word);
                    this.appendWordFeatures(word);
                }
            }
            if (++cjkidx <= chars.length) continue;
        }
        for (IWord w : mList) {
            key = w.getValue();
            if (this.config.CLEAR_STOPWORD && this.dic.match(9, key)) continue;
            this.wordPool.add(w);
            this.appendWordFeatures(w);
        }
        mList.clear();
        mList = null;
        return this.wordPool.size() == 0 ? null : (IWord)this.wordPool.remove();
    }

    @Override
    protected IChunk getBestCJKChunk(char[] chars, int index) throws IOException {
        return null;
    }
}

