/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.CodeSource;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.lionsoul.jcseg.tokenizer.core.AutoLoadFile;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;
import org.lionsoul.jcseg.util.StringUtil;

public abstract class ADictionary {
    public static final String AL_TODO_FILE = "lex-autoload.todo";
    protected JcsegTaskConfig config;
    protected boolean sync;
    private Thread autoloadThread = null;

    public ADictionary(JcsegTaskConfig config, Boolean sync) {
        this.sync = sync;
        this.config = config;
    }

    public void load(File file) throws NumberFormatException, FileNotFoundException, IOException {
        ADictionary.loadWords(this.config, this, file);
    }

    public void load(String file) throws NumberFormatException, FileNotFoundException, IOException {
        ADictionary.loadWords(this.config, this, file);
    }

    public void load(InputStream is) throws NumberFormatException, IOException {
        ADictionary.loadWords(this.config, this, is);
    }

    public void loadDirectory(String lexDir) throws IOException {
        File[] files;
        File path = new File(lexDir);
        if (!path.exists()) {
            throw new IOException("Lexicon directory [" + lexDir + "] does'n exists.");
        }
        final String __suffix = this.config.getLexiconFileSuffix();
        final String __prefix = this.config.getLexiconFilePrefix();
        for (File file : files = path.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(__prefix) && name.endsWith(__suffix);
            }
        })) {
            this.load(file);
        }
    }

    public void loadClassPath() throws IOException {
        String __suffix = this.config.getLexiconFileSuffix();
        String __prefix = this.config.getLexiconFilePrefix();
        Class<?> dClass = this.getClass();
        CodeSource codeSrc = this.getClass().getProtectionDomain().getCodeSource();
        if (codeSrc == null) {
            return;
        }
        String codePath = codeSrc.getLocation().getPath();
        if (codePath.toLowerCase().endsWith(".jar")) {
            ZipEntry e;
            ZipInputStream zip = new ZipInputStream(codeSrc.getLocation().openStream());
            while ((e = zip.getNextEntry()) != null) {
                String fileName = e.getName();
                if (!fileName.startsWith("lexicon/" + __prefix) || !fileName.endsWith(__suffix)) continue;
                this.load(dClass.getResourceAsStream("/" + fileName));
            }
        } else {
            this.loadDirectory(codePath + "/lexicon");
        }
    }

    public void startAutoload() {
        if (this.autoloadThread != null || this.config.getLexiconPath() == null) {
            return;
        }
        this.autoloadThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String[] paths = ADictionary.this.config.getLexiconPath();
                AutoLoadFile[] files = new AutoLoadFile[paths.length];
                for (int i = 0; i < files.length; ++i) {
                    files[i] = new AutoLoadFile(paths[i] + "/" + ADictionary.AL_TODO_FILE);
                    files[i].setLastUpdateTime(files[i].getFile().lastModified());
                }
                block5: while (true) {
                    try {
                        Thread.sleep(ADictionary.this.config.getPollTime() * 1000);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    File f = null;
                    AutoLoadFile af = null;
                    int i = 0;
                    while (true) {
                        if (i >= files.length) continue block5;
                        af = files[i];
                        f = files[i].getFile();
                        if (f.exists() && f.lastModified() > af.getLastUpdateTime()) {
                            try {
                                BufferedReader reader = new BufferedReader(new FileReader(f));
                                String line = null;
                                while ((line = reader.readLine()) != null) {
                                    if ((line = line.trim()).indexOf(35) != -1 || "".equals(line)) continue;
                                    ADictionary.this.load(paths[i] + "/" + line);
                                }
                                reader.close();
                                FileWriter fw = new FileWriter(f);
                                fw.write("");
                                fw.close();
                                af.setLastUpdateTime(f.lastModified());
                            }
                            catch (IOException e) {
                                continue block5;
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
        });
        this.autoloadThread.setDaemon(true);
        this.autoloadThread.start();
    }

    public void stopAutoload() {
        if (this.autoloadThread != null) {
            this.autoloadThread.interrupt();
            this.autoloadThread = null;
        }
    }

    public boolean isSync() {
        return this.sync;
    }

    public abstract boolean match(int var1, String var2);

    public abstract void add(int var1, String var2, int var3);

    public abstract void add(int var1, String var2, int var3, int var4);

    public abstract IWord get(int var1, String var2);

    public abstract void remove(int var1, String var2);

    public abstract int size(int var1);

    public static int getIndex(String key) {
        if (key == null) {
            return -1;
        }
        if ((key = key.toUpperCase()).equals("CJK_WORDS")) {
            return 0;
        }
        if (key.equals("CJK_UNITS")) {
            return 1;
        }
        if (key.equals("EC_MIXED_WORD")) {
            return 2;
        }
        if (key.equals("CE_MIXED_WORD")) {
            return 10;
        }
        if (key.equals("CN_LNAME")) {
            return 3;
        }
        if (key.equals("CN_SNAME")) {
            return 4;
        }
        if (key.equals("CN_DNAME_1")) {
            return 5;
        }
        if (key.equals("CN_DNAME_2")) {
            return 6;
        }
        if (key.equals("CN_LNAME_ADORN")) {
            return 7;
        }
        if (key.equals("EN_PUN_WORDS")) {
            return 8;
        }
        if (key.equals("STOP_WORDS")) {
            return 9;
        }
        if (key.equals("EN_WORD")) {
            return 11;
        }
        return 0;
    }

    public JcsegTaskConfig getConfig() {
        return this.config;
    }

    public void setConfig(JcsegTaskConfig config) {
        this.config = config;
    }

    public static void loadWords(JcsegTaskConfig config, ADictionary dic, File file) throws NumberFormatException, FileNotFoundException, IOException {
        ADictionary.loadWords(config, dic, new FileInputStream(file));
    }

    public static void loadWords(JcsegTaskConfig config, ADictionary dic, String file) throws NumberFormatException, FileNotFoundException, IOException {
        ADictionary.loadWords(config, dic, new FileInputStream(file));
    }

    public static void loadWords(JcsegTaskConfig config, ADictionary dic, InputStream is) throws NumberFormatException, IOException {
        boolean isFirstLine = true;
        int t = -1;
        String line = null;
        BufferedReader buffReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        while ((line = buffReader.readLine()) != null) {
            int i;
            boolean add;
            int length;
            int j;
            if ("".equals(line = line.trim()) || line.charAt(0) == '#' && line.length() > 1) continue;
            if (isFirstLine) {
                t = ADictionary.getIndex(line);
                isFirstLine = false;
                if (t >= 0) continue;
            }
            if (t == 9) {
                if (line.charAt(0) > '\u007f' && (line.charAt(0) <= '\u007f' || line.length() > config.MAX_LENGTH)) continue;
                dic.add(9, line, 1);
                continue;
            }
            if (line.indexOf(47) == -1) {
                boolean olen = t == 2;
                olen = olen || t == 10;
                boolean bl = olen = olen || t == 8;
                if (!olen && line.length() > config.MAX_LENGTH) continue;
                dic.add(t, line, 1);
                continue;
            }
            String[] wd = line.split("/");
            if (wd.length < 4) {
                System.out.println("Word: \"" + wd[0] + "\" format error. -ignored");
                continue;
            }
            if (wd.length == 5 && !StringUtil.isDigit(wd[4])) {
                System.out.println("Word: \"" + wd[0] + "\" format error(single word degree should be an integer). -ignored");
                continue;
            }
            if (t == 0 && wd[0].length() > config.MAX_LENGTH) continue;
            if (dic.get(t, wd[0]) == null) {
                if (wd.length > 4) {
                    dic.add(t, wd[0], Integer.parseInt(wd[4]), 1);
                } else {
                    dic.add(t, wd[0], 1);
                }
            }
            IWord w = dic.get(t, wd[0]);
            if (config.LOAD_CJK_PINYIN && !"null".equals(wd[2])) {
                w.setPinyin(wd[2]);
            }
            boolean li = t == 0;
            String[] arr = w.getSyn();
            if (config.LOAD_CJK_SYN && !"null".equals(wd[3])) {
                String[] syns = wd[3].split(",");
                for (j = 0; j < syns.length; ++j) {
                    syns[j] = syns[j].trim();
                    if (li && syns[j].length() > config.MAX_LENGTH) continue;
                    if (arr != null) {
                        length = arr.length;
                        add = true;
                        for (i = 0; i < length; ++i) {
                            if (!syns[j].equals(arr[i])) continue;
                            add = false;
                            break;
                        }
                        if (!add) continue;
                    }
                    w.addSyn(syns[j]);
                }
            }
            arr = w.getPartSpeech();
            if (!config.LOAD_CJK_POS || "null".equals(wd[1])) continue;
            String[] pos = wd[1].split(",");
            for (j = 0; j < pos.length; ++j) {
                pos[j] = pos[j].trim();
                if (arr != null) {
                    length = arr.length;
                    add = true;
                    for (i = 0; i < length; ++i) {
                        if (!pos[j].equals(arr[i])) continue;
                        add = false;
                        break;
                    }
                    if (!add) continue;
                }
                w.addPartSpeech(pos[j].trim());
            }
        }
        buffReader.close();
        buffReader = null;
    }
}

