/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer.core;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.lionsoul.jcseg.tokenizer.Dictionary;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;

public class DictionaryFactory {
    private static final Object LOCK = new Object();
    private static ADictionary singletonDic = null;

    private DictionaryFactory() {
    }

    public static ADictionary createDictionary(Class<? extends ADictionary> _class, Class<?>[] paramType, Object[] args) {
        try {
            Constructor<? extends ADictionary> cons = _class.getConstructor(paramType);
            return cons.newInstance(args);
        }
        catch (Exception e) {
            System.err.println("can't create the ADictionary instance with classpath [" + _class.getName() + "]");
            e.printStackTrace();
            return null;
        }
    }

    public static ADictionary createDefaultDictionary(JcsegTaskConfig config, boolean sync, boolean loadDic) {
        ADictionary dic = DictionaryFactory.createDictionary(Dictionary.class, new Class[]{JcsegTaskConfig.class, Boolean.class}, new Object[]{config, sync});
        if (!loadDic) {
            return dic;
        }
        try {
            String[] lexpath = config.getLexiconPath();
            if (lexpath == null) {
                dic.loadClassPath();
            } else {
                for (String lpath : lexpath) {
                    dic.loadDirectory(lpath);
                }
                if (dic.getConfig().isAutoload()) {
                    dic.startAutoload();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dic;
    }

    public static ADictionary createDefaultDictionary(JcsegTaskConfig config) {
        return DictionaryFactory.createDefaultDictionary(config, true);
    }

    public static ADictionary createDefaultDictionary(JcsegTaskConfig config, boolean loadDic) {
        return DictionaryFactory.createDefaultDictionary(config, config.isAutoload(), loadDic);
    }

    public static ADictionary createSingletonDictionary(JcsegTaskConfig config) {
        return DictionaryFactory.createSingletonDictionary(config, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ADictionary createSingletonDictionary(JcsegTaskConfig config, boolean loadDic) {
        Object object = LOCK;
        synchronized (object) {
            if (singletonDic == null) {
                singletonDic = DictionaryFactory.createDefaultDictionary(config);
            }
        }
        return singletonDic;
    }
}

