/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer.core;

import java.io.Reader;
import java.lang.reflect.Constructor;
import org.lionsoul.jcseg.tokenizer.ComplexSeg;
import org.lionsoul.jcseg.tokenizer.DetectSeg;
import org.lionsoul.jcseg.tokenizer.SearchSeg;
import org.lionsoul.jcseg.tokenizer.SimpleSeg;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.ISegment;
import org.lionsoul.jcseg.tokenizer.core.JcsegException;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;

public class SegmentFactory {
    public static final String version = "1.9.9";

    public static ISegment createSegment(Class<? extends ISegment> _class, Class<?>[] paramtypes, Object[] args) {
        ISegment seg = null;
        try {
            Constructor<? extends ISegment> cons = _class.getConstructor(paramtypes);
            seg = cons.newInstance(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("can't load the ISegment implements class with path [" + _class.getName() + "] ");
        }
        return seg;
    }

    public static ISegment createJcseg(int mode, Object ... args) throws JcsegException {
        Class _clsname;
        if (mode == 1) {
            _clsname = SimpleSeg.class;
        } else if (mode == 2) {
            _clsname = ComplexSeg.class;
        } else if (mode == 3) {
            _clsname = DetectSeg.class;
        } else if (mode == 4) {
            _clsname = SearchSeg.class;
        } else {
            throw new JcsegException("No Such Algorithm Excpetion");
        }
        Class[] _paramtype = null;
        if (args.length == 2) {
            _paramtype = new Class[]{JcsegTaskConfig.class, ADictionary.class};
        } else if (args.length == 3) {
            _paramtype = new Class[]{Reader.class, JcsegTaskConfig.class, ADictionary.class};
        } else {
            throw new JcsegException("length of the arguments should be 2 or 3");
        }
        return SegmentFactory.createSegment(_clsname, _paramtype, args);
    }
}

