/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.util;

import java.util.HashMap;
import java.util.Map;
import org.lionsoul.jcseg.tokenizer.core.IWord;

public class IHashQueue<T extends IWord> {
    private int size = 0;
    private Entry<T> head;
    private Entry<T> tail = new Entry<Object>(null, null, null);
    private Map<String, T> index;

    public IHashQueue() {
        this.head = new Entry<Object>(null, null, this.tail);
        this.tail.prev = this.head;
        this.index = new HashMap<String, T>(16, 0.85f);
    }

    public boolean add(T word) {
        Entry<T> o = new Entry<T>(word, this.tail.prev, this.tail);
        this.tail.prev.next = o;
        this.tail.prev = o;
        ++this.size;
        this.index.put(word.getValue(), word);
        return true;
    }

    public boolean contains(T word) {
        return this.index.containsKey(word.getValue());
    }

    public T remove() {
        if (this.size == 0) {
            return null;
        }
        Entry o = this.head.next;
        this.head.next = o.next;
        o.next.prev = this.head;
        IWord v = (IWord)o.data;
        --this.size;
        this.index.remove(v.getValue());
        o = null;
        return (T)v;
    }

    public int size() {
        return this.size;
    }

    public static class Entry<T> {
        public T data;
        public Entry<T> prev;
        public Entry<T> next;

        public Entry(T data, Entry<T> prev, Entry<T> next) {
            this.data = data;
            this.prev = prev;
            this.next = next;
        }
    }
}

