/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer;

import org.lionsoul.jcseg.tokenizer.core.IChunk;
import org.lionsoul.jcseg.tokenizer.core.IWord;

public class Chunk
implements IChunk {
    private IWord[] words;
    private double averageWordsLength = -1.0;
    private double wordsVariance = -1.0;
    private double singleWordMorphemicFreedom = -1.0;
    private int length = -1;

    public Chunk(IWord[] words) {
        this.words = words;
    }

    @Override
    public IWord[] getWords() {
        return this.words;
    }

    @Override
    public double getAverageWordsLength() {
        if (this.averageWordsLength == -1.0) {
            this.averageWordsLength = (double)this.getLength() / (double)this.words.length;
        }
        return this.averageWordsLength;
    }

    @Override
    public double getWordsVariance() {
        if (this.wordsVariance == -1.0) {
            double variance = 0.0;
            for (int j = 0; j < this.words.length; ++j) {
                double temp = (double)this.words[j].getLength() - this.getAverageWordsLength();
                variance += temp * temp;
            }
            this.wordsVariance = variance / (double)this.words.length;
        }
        return this.wordsVariance;
    }

    @Override
    public double getSingleWordsMorphemicFreedom() {
        if (this.singleWordMorphemicFreedom == -1.0) {
            this.singleWordMorphemicFreedom = 0.0;
            for (int j = 0; j < this.words.length; ++j) {
                if (this.words[j].getLength() != 1) continue;
                this.singleWordMorphemicFreedom += Math.log(this.words[j].getFrequency());
            }
        }
        return this.singleWordMorphemicFreedom;
    }

    @Override
    public int getLength() {
        if (this.length == -1) {
            this.length = 0;
            for (int j = 0; j < this.words.length; ++j) {
                this.length += this.words[j].getLength();
            }
        }
        return this.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("chunk: ");
        for (int j = 0; j < this.words.length; ++j) {
            sb.append(this.words[j] + "/");
        }
        return sb.toString();
    }
}

