/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lionsoul.jcseg.tokenizer.Word;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;

public class Dictionary
extends ADictionary {
    private Map<String, IWord>[] dics = new Map[11];

    public Dictionary(JcsegTaskConfig config, Boolean sync) {
        super(config, sync);
        if (this.sync) {
            for (int j = 0; j < 11; ++j) {
                this.dics[j] = new ConcurrentHashMap<String, IWord>(16, 0.8f);
            }
        } else {
            for (int j = 0; j < 11; ++j) {
                this.dics[j] = new HashMap<String, IWord>(16, 0.8f);
            }
        }
    }

    @Override
    public boolean match(int t, String key) {
        if (t >= 0 && t < 11) {
            return this.dics[t].containsKey(key);
        }
        return false;
    }

    @Override
    public IWord add(int t, IWord word) {
        if (t >= 0 && t < 11) {
            if (this.dics[t].containsKey(word.getValue())) {
                return this.dics[t].get(word.getValue());
            }
            this.dics[t].put(word.getValue(), word);
            return word;
        }
        return null;
    }

    @Override
    public IWord add(int t, String key, int fre, int type, String[] entity) {
        if (t >= 0 && t < 11) {
            if (this.dics[t].containsKey(key)) {
                return this.dics[t].get(key);
            }
            Word word = new Word(key, fre, type, entity);
            this.dics[t].put(key, word);
            return word;
        }
        return null;
    }

    @Override
    public IWord add(int t, String key, int type) {
        return this.add(t, key, 0, type, null);
    }

    @Override
    public IWord add(int t, String key, int fre, int type) {
        return this.add(t, key, fre, type, null);
    }

    @Override
    public IWord add(int t, String key, int type, String[] entity) {
        return this.add(t, key, 0, type, entity);
    }

    @Override
    public IWord get(int t, String key) {
        if (t >= 0 && t < 11) {
            return this.dics[t].get(key);
        }
        return null;
    }

    @Override
    public void remove(int t, String key) {
        if (t >= 0 && t < 11) {
            this.dics[t].remove(key);
        }
    }

    @Override
    public int size(int t) {
        if (t >= 0 && t < 11) {
            return this.dics[t].size();
        }
        return 0;
    }
}

