/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Properties;
import org.lionsoul.jcseg.util.Util;

public class JcsegTaskConfig
implements Cloneable {
    public static final String LEX_PROPERTY_FILE = "jcseg.properties";
    public static final int SIMPLE_MODE = 1;
    public static final int COMPLEX_MODE = 2;
    public static final int DETECT_MODE = 3;
    public static final int SEARCH_MODE = 4;
    public static final int DELIMITER_MODE = 5;
    public static final int NLP_MODE = 6;
    public int MAX_LENGTH = 5;
    public int MAX_LATIN_LENGTH = 64;
    public int MAX_UNIT_LENGTH = 5;
    public boolean I_CN_NAME = false;
    public int MAX_CN_LNADRON = 1;
    public boolean LOAD_CJK_PINYIN = false;
    public boolean APPEND_CJK_PINYIN = false;
    public boolean APPEND_PART_OF_SPEECH = false;
    public boolean LOAD_CJK_SYN = false;
    public boolean APPEND_CJK_SYN = true;
    public boolean LOAD_CJK_POS = false;
    public boolean LOAD_CJK_ENTITY = true;
    public boolean APPEND_CJK_ENTITY = true;
    public int NAME_SINGLE_THRESHOLD = 1000000;
    public int PPT_MAX_LENGTH = 15;
    public boolean CLEAR_STOPWORD = false;
    public boolean CNNUM_TO_ARABIC = true;
    public boolean CNFRA_TO_ARABIC = true;
    public boolean EN_SECOND_SEG = true;
    public int STOKEN_MIN_LEN = 1;
    private String KEEP_PUNCTUATIONS = "@%&.'#+";
    public boolean KEEP_UNREG_WORDS = false;
    private String[] lexPath = null;
    private boolean lexAutoload = false;
    private int polltime = 10;
    private String pFile = null;

    public JcsegTaskConfig() {
    }

    public JcsegTaskConfig(boolean autoLoad) {
        if (autoLoad) {
            try {
                this.autoLoad();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public JcsegTaskConfig(String proFile) {
        try {
            this.load(proFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JcsegTaskConfig(InputStream is) {
        try {
            this.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(String proFile) throws IOException {
        this.load(new FileInputStream(proFile));
    }

    public void autoLoad() throws IOException {
        File proFile = new File(Util.getJarHome(this) + "/" + LEX_PROPERTY_FILE);
        if (proFile.exists()) {
            this.pFile = proFile.getAbsolutePath();
            this.load(proFile.getAbsolutePath());
            return;
        }
        InputStream is = this.getClass().getResourceAsStream("/jcseg.properties");
        if (is != null) {
            this.pFile = "classpath/jcseg.properties";
            this.load(is);
            return;
        }
        proFile = new File(System.getProperty("user.home") + "/" + LEX_PROPERTY_FILE);
        if (proFile.exists()) {
            this.pFile = proFile.getAbsolutePath();
            this.load(proFile.getAbsolutePath());
        }
        String errString = "jcseg properties \"jcseg.properties]\" file auto loaded failed: \n";
        errString = errString + "try the follwing ways to solve the problem: \n";
        errString = errString + "1. put jcseg.properties into the classpath.\n";
        errString = errString + "2. put jcseg.properties together with the jcseg-core-{version}.jar file.\n";
        errString = errString + "3. put jcseg.properties in directory " + System.getProperty("user.home") + "\n\n";
        throw new IOException(errString);
    }

    public void load(InputStream is) throws IOException {
        Properties lexPro = new Properties();
        lexPro.load(new BufferedInputStream(is));
        String lexDirs = lexPro.getProperty("lexicon.path");
        if (lexDirs == null) {
            throw new IOException("Missing lexicon.path property in jcseg.properties file!!!");
        }
        if (!"null".equalsIgnoreCase(lexDirs)) {
            if (lexDirs.indexOf("{jar.dir}") > -1) {
                lexDirs = lexDirs.replace("{jar.dir}", Util.getJarHome(this));
            }
            this.lexPath = lexDirs.split(";");
            File f = null;
            for (int i = 0; i < this.lexPath.length; ++i) {
                this.lexPath[i] = URLDecoder.decode(this.lexPath[i], "UTF-8");
                f = new File(this.lexPath[i]);
                if (!f.exists()) {
                    throw new IOException("Invalid sub lexicon path " + this.lexPath[i] + " for lexicon.path in jcseg.properties");
                }
                f = null;
            }
        }
        if (lexPro.getProperty("jcseg.maxlen") != null) {
            this.MAX_LENGTH = Integer.parseInt(lexPro.getProperty("jcseg.maxlen"));
        }
        if (lexPro.getProperty("jcseg.icnname") != null && lexPro.getProperty("jcseg.icnname").equals("1")) {
            this.I_CN_NAME = true;
        }
        if (lexPro.getProperty("jcseg.cnmaxlnadron") != null) {
            this.MAX_CN_LNADRON = Integer.parseInt(lexPro.getProperty("jcseg.cnmaxlnadron"));
        }
        if (lexPro.getProperty("jcseg.nsthreshold") != null) {
            this.NAME_SINGLE_THRESHOLD = Integer.parseInt(lexPro.getProperty("jcseg.nsthreshold"));
        }
        if (lexPro.getProperty("jcseg.pptmaxlen") != null) {
            this.PPT_MAX_LENGTH = Integer.parseInt(lexPro.getProperty("jcseg.pptmaxlen"));
        }
        if (lexPro.getProperty("jcseg.loadpinyin") != null && lexPro.getProperty("jcseg.loadpinyin").equals("1")) {
            this.LOAD_CJK_PINYIN = true;
        }
        if (lexPro.getProperty("jcseg.loadsyn") != null && lexPro.getProperty("jcseg.loadsyn").equals("1")) {
            this.LOAD_CJK_SYN = true;
        }
        if (lexPro.getProperty("jcseg.loadpos") != null && lexPro.getProperty("jcseg.loadpos").equals("1")) {
            this.LOAD_CJK_POS = true;
        }
        if (lexPro.getProperty("jcseg.loadentity") != null && lexPro.getProperty("jcseg.loadentity").equals("0")) {
            this.LOAD_CJK_ENTITY = false;
        }
        if (lexPro.getProperty("jcseg.clearstopword") != null && lexPro.getProperty("jcseg.clearstopword").equals("1")) {
            this.CLEAR_STOPWORD = true;
        }
        if (lexPro.getProperty("jcseg.cnnumtoarabic") != null && lexPro.getProperty("jcseg.cnnumtoarabic").equals("0")) {
            this.CNNUM_TO_ARABIC = false;
        }
        if (lexPro.getProperty("jcseg.cnfratoarabic") != null && lexPro.getProperty("jcseg.cnfratoarabic").equals("0")) {
            this.CNFRA_TO_ARABIC = false;
        }
        if (lexPro.getProperty("jcseg.keepunregword") != null && lexPro.getProperty("jcseg.keepunregword").equals("1")) {
            this.KEEP_UNREG_WORDS = true;
        }
        if (lexPro.getProperty("lexicon.autoload") != null && lexPro.getProperty("lexicon.autoload").equals("1")) {
            this.lexAutoload = true;
        }
        if (lexPro.getProperty("lexicon.polltime") != null) {
            this.polltime = Integer.parseInt(lexPro.getProperty("lexicon.polltime"));
        }
        if (lexPro.getProperty("jcseg.ensencondseg") != null && lexPro.getProperty("jcseg.ensencondseg").equals("0")) {
            this.EN_SECOND_SEG = false;
        }
        if (lexPro.getProperty("jcseg.stokenminlen") != null) {
            this.STOKEN_MIN_LEN = Integer.parseInt(lexPro.getProperty("jcseg.stokenminlen"));
        }
        if (lexPro.getProperty("jcseg.keeppunctuations") != null) {
            this.KEEP_PUNCTUATIONS = lexPro.getProperty("jcseg.keeppunctuations");
        }
    }

    public String[] getLexiconPath() {
        return this.lexPath;
    }

    public void setLexiconPath(String[] lexPath) {
        this.lexPath = lexPath;
    }

    public boolean isAutoload() {
        return this.lexAutoload;
    }

    public void setAutoload(boolean autoload) {
        this.lexAutoload = autoload;
    }

    public int getPollTime() {
        return this.polltime;
    }

    public void setPollTime(int polltime) {
        this.polltime = polltime;
    }

    public int getMaxLength() {
        return this.MAX_LENGTH;
    }

    public void setMaxLength(int maxLength) {
        this.MAX_LENGTH = maxLength;
    }

    public boolean identifyCnName() {
        return this.I_CN_NAME;
    }

    public void setICnName(boolean iCnName) {
        this.I_CN_NAME = iCnName;
    }

    public int getMaxCnLnadron() {
        return this.MAX_CN_LNADRON;
    }

    public void setMaxCnLnadron(int maxCnLnadron) {
        this.MAX_CN_LNADRON = maxCnLnadron;
    }

    public boolean loadCJKPinyin() {
        return this.LOAD_CJK_PINYIN;
    }

    public void setLoadCJKPinyin(boolean loadCJKPinyin) {
        this.LOAD_CJK_PINYIN = loadCJKPinyin;
    }

    public void setAppendPartOfSpeech(boolean partOfSpeech) {
        this.APPEND_PART_OF_SPEECH = partOfSpeech;
    }

    public boolean appendCJKPinyin() {
        return this.APPEND_CJK_PINYIN;
    }

    public void setAppendCJKPinyin(boolean appendCJKPinyin) {
        this.APPEND_CJK_PINYIN = appendCJKPinyin;
    }

    public boolean loadCJKSyn() {
        return this.LOAD_CJK_SYN;
    }

    public void setLoadCJKSyn(boolean loadCJKSyn) {
        this.LOAD_CJK_SYN = loadCJKSyn;
    }

    public boolean appendCJKSyn() {
        return this.APPEND_CJK_SYN;
    }

    public void setAppendCJKSyn(boolean appendCJKPinyin) {
        this.APPEND_CJK_SYN = appendCJKPinyin;
    }

    public boolean ladCJKPos() {
        return this.LOAD_CJK_POS;
    }

    public void setLoadCJKPos(boolean loadCJKPos) {
        this.LOAD_CJK_POS = loadCJKPos;
    }

    public boolean loadCJKEntity() {
        return this.LOAD_CJK_ENTITY;
    }

    public void setLoadEntity(boolean loadEntity) {
        this.LOAD_CJK_ENTITY = loadEntity;
    }

    public int getNameSingleThreshold() {
        return this.NAME_SINGLE_THRESHOLD;
    }

    public void setNameSingleThreshold(int thresold) {
        this.NAME_SINGLE_THRESHOLD = thresold;
    }

    public int getPPTMaxLength() {
        return this.PPT_MAX_LENGTH;
    }

    public void setPPT_MAX_LENGTH(int pptMaxLength) {
        this.PPT_MAX_LENGTH = pptMaxLength;
    }

    public boolean clearStopwords() {
        return this.CLEAR_STOPWORD;
    }

    public void setClearStopwords(boolean clearstopwords) {
        this.CLEAR_STOPWORD = clearstopwords;
    }

    public boolean cnNumToArabic() {
        return this.CNNUM_TO_ARABIC;
    }

    public void setCnNumToArabic(boolean cnNumToArabic) {
        this.CNNUM_TO_ARABIC = cnNumToArabic;
    }

    public boolean cnFractionToArabic() {
        return this.CNFRA_TO_ARABIC;
    }

    public void setCnFactionToArabic(boolean cnFractionToArabic) {
        this.CNFRA_TO_ARABIC = cnFractionToArabic;
    }

    public boolean getEnSecondSeg() {
        return this.EN_SECOND_SEG;
    }

    public void setEnSecondSeg(boolean enSecondSeg) {
        this.EN_SECOND_SEG = enSecondSeg;
    }

    public int getSTokenMinLen() {
        return this.STOKEN_MIN_LEN;
    }

    public void setSTokenMinLen(int len) {
        this.STOKEN_MIN_LEN = len;
    }

    public void setKeepPunctuations(String keepPunctuations) {
        this.KEEP_PUNCTUATIONS = keepPunctuations;
    }

    public boolean isKeepPunctuation(char c) {
        return this.KEEP_PUNCTUATIONS.indexOf(c) > -1;
    }

    public boolean keepUnregWords() {
        return this.KEEP_UNREG_WORDS;
    }

    public void setKeepUnregWords(boolean keepUnregWords) {
        this.KEEP_UNREG_WORDS = keepUnregWords;
    }

    public String getPropertieFile() {
        return this.pFile;
    }

    public JcsegTaskConfig clone() throws CloneNotSupportedException {
        return (JcsegTaskConfig)super.clone();
    }
}

