/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer.core;

import java.util.ArrayList;
import org.lionsoul.jcseg.tokenizer.core.IChunk;

public class MMSegFilter {
    public static IChunk[] getMaximumMatchChunks(IChunk[] chunks) {
        int j;
        int maxLength = chunks[0].getLength();
        for (j = 1; j < chunks.length; ++j) {
            if (chunks[j].getLength() <= maxLength) continue;
            maxLength = chunks[j].getLength();
        }
        ArrayList<IChunk> chunkArr = new ArrayList<IChunk>(chunks.length);
        for (j = 0; j < chunks.length; ++j) {
            if (chunks[j].getLength() != maxLength) continue;
            chunkArr.add(chunks[j]);
        }
        IChunk[] lchunk = new IChunk[chunkArr.size()];
        chunkArr.toArray(lchunk);
        chunkArr.clear();
        return lchunk;
    }

    public static IChunk[] getLargestAverageWordLengthChunks(IChunk[] chunks) {
        int j;
        double largetAverage = chunks[0].getAverageWordsLength();
        for (j = 1; j < chunks.length; ++j) {
            if (!(chunks[j].getAverageWordsLength() > largetAverage)) continue;
            largetAverage = chunks[j].getAverageWordsLength();
        }
        ArrayList<IChunk> chunkArr = new ArrayList<IChunk>(chunks.length);
        for (j = 0; j < chunks.length; ++j) {
            if (chunks[j].getAverageWordsLength() != largetAverage) continue;
            chunkArr.add(chunks[j]);
        }
        IChunk[] lchunk = new IChunk[chunkArr.size()];
        chunkArr.toArray(lchunk);
        chunkArr.clear();
        return lchunk;
    }

    public static IChunk[] getSmallestVarianceWordLengthChunks(IChunk[] chunks) {
        int j;
        double smallestVariance = chunks[0].getWordsVariance();
        for (j = 1; j < chunks.length; ++j) {
            if (!(chunks[j].getWordsVariance() < smallestVariance)) continue;
            smallestVariance = chunks[j].getWordsVariance();
        }
        ArrayList<IChunk> chunkArr = new ArrayList<IChunk>(chunks.length);
        for (j = 0; j < chunks.length; ++j) {
            if (chunks[j].getWordsVariance() != smallestVariance) continue;
            chunkArr.add(chunks[j]);
        }
        IChunk[] lchunk = new IChunk[chunkArr.size()];
        chunkArr.toArray(lchunk);
        chunkArr.clear();
        return lchunk;
    }

    public static IChunk[] getLargestSingleMorphemicFreedomChunks(IChunk[] chunks) {
        int j;
        double largestFreedom = chunks[0].getSingleWordsMorphemicFreedom();
        for (j = 1; j < chunks.length; ++j) {
            if (!(chunks[j].getSingleWordsMorphemicFreedom() > largestFreedom)) continue;
            largestFreedom = chunks[j].getSingleWordsMorphemicFreedom();
        }
        ArrayList<IChunk> chunkArr = new ArrayList<IChunk>(chunks.length);
        for (j = 0; j < chunks.length; ++j) {
            if (chunks[j].getSingleWordsMorphemicFreedom() != largestFreedom) continue;
            chunkArr.add(chunks[j]);
        }
        IChunk[] lchunk = new IChunk[chunkArr.size()];
        chunkArr.toArray(lchunk);
        chunkArr.clear();
        return lchunk;
    }
}

