/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.util;

import java.util.Arrays;

public class ByteCharCounter {
    private final byte[] buffer = new byte[95];

    public ByteCharCounter() {
        Arrays.fill(this.buffer, (byte)0);
    }

    private boolean isValidChar(char chr) {
        return chr >= ' ' && chr <= '~';
    }

    public ByteCharCounter increase(char chr) {
        return this.increase(chr, 1);
    }

    public ByteCharCounter increase(char chr, int val) {
        if (this.isValidChar(chr)) {
            int n = chr - 32;
            this.buffer[n] = (byte)(this.buffer[n] + val);
        }
        return this;
    }

    public ByteCharCounter decrease(char chr) {
        return this.decrease(chr, 1);
    }

    public ByteCharCounter decrease(char chr, int val) {
        int idx = chr - 32;
        if (this.isValidChar(chr) && this.buffer[idx] > 0) {
            int n = idx;
            this.buffer[n] = (byte)(this.buffer[n] - 1);
        }
        return this;
    }

    public int get(char chr) {
        return this.isValidChar(chr) ? this.buffer[chr - 32] : 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.buffer.length; ++i) {
            char chr = (char)(i + 32);
            int cunt = this.get(chr);
            if (cunt <= 0) continue;
            sb.append(chr).append(':').append(this.get(chr)).append('\n');
        }
        return sb.toString();
    }
}

