/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.DeploymentIdFilter;
import com.datical.liquibase.ext.command.RollbackOneUpdateCommand$1;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.command.AbstractSelfConfiguratingCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.hub.HubUpdater;
import liquibase.hub.listener.HubChangeExecListener;
import liquibase.hub.model.Connection;
import liquibase.hub.model.Operation;
import liquibase.license.LicenseServiceFactory;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;
import liquibase.logging.core.BufferedLogService;
import liquibase.logging.core.CompositeLogService;

public class RollbackOneUpdateCommand
extends AbstractSelfConfiguratingCommand {
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_COULD_NOT_RELEASE_LOCK = coreBundle.getString("could.not.release.lock");
    private Database database;
    private String deploymentId;
    private String changeSetId;
    private String changeSetAuthor;
    private String changeSetPath;
    private Writer outputWriter;
    private String changeLogFilePath;
    private Liquibase liquibase;
    private Contexts contexts;
    private LabelExpression labelExpression;
    private String rollbackScript;
    private ChangeExecListener changeExecListener;
    private DatabaseChangeLog changeLog;

    @Override
    public String getName() {
        return "rollbackOneUpdate";
    }

    @Override
    public CommandValidationErrors validate() {
        return new CommandValidationErrors(this);
    }

    @Override
    public int getPriority(String string) {
        if (!Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class).getLicenseService().licenseIsValid("Liquibase Pro")) {
            return -1;
        }
        return super.getPriority(string);
    }

    public void configure(Map object) {
        if (object.containsKey("help")) {
            if (object.containsKey("outputWriter")) {
                System.out.println("liquibase <global parameters> rollbackOneUpdateSQL [--deploymentId=<id>]\n\nrollbackOneUpdateSQL         Displays the SQL which will be executed when the corresponding rollbackOneUpdate command is executed, and does not\n                             perform the actual rollback.  (Liquibase Pro key required)\n\n  REQUIRED GLOBAL PARAMETERS\n    --url                    is the JDBC database connection URL\n    --username               is the database username\n    --password               is the database password\n    --changeLogFile          is the root changelog file\n    --liquibaseProLicenseKey is the Liquibase Pro license key to use\n  COMMAND PARAMETERS\n    [--deploymentId]         is the deployment ID for the update to be rolled back.\n                             If you do not specify the deployment ID, the ID for the last update will be used.");
            } else {
                System.out.println("liquibase <global parameters> rollbackOneUpdate [--deploymentId=id] --force\n\nrollbackOneUpdate            Rolls back all the changesets from one update, identified by \"deploymentId\",\n                             if all the changesets can be rolled back. If not, a WARNING message will provide\n                             details.  (Liquibase Pro key required)                             Note:  A list of deployment IDs may be viewed by using the \"history\" coammand.\n  REQUIRED GLOBAL PARAMETERS\n    --url                    is the JDBC database connection URL\n    --username               is the database username\n    --password               is the database password\n    --changeLogFile          is the root changelog file\n    --liquibaseProLicenseKey is the Liquibase Pro license key to use\n  COMMAND PARAMETERS\n    --force                  is required to make sure you intended to run this operation\n    [--deploymentId]         is the deployment ID for the update to be rolled back.\n                             If you do not specify the deployment ID, the ID for the last update will be used.");
            }
            System.exit(0);
        }
        this.deploymentId = (String)object.get("deploymentId");
        this.database = (Database)object.get("database");
        this.changeLog = (DatabaseChangeLog)object.get("changeLog");
        this.changeLogFilePath = (String)object.get("changeLogFile");
        Boolean bl2 = (Boolean)object.get("force");
        if (bl2 == null || !bl2.booleanValue()) {
            object = "\nWARNING: Targeted rollback of this update may result in unexpected outcomes.  To review the rollback\nSQL before executing it, please run 'rollbackOneUpdateSQL'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException(String.format((String)object, new Object[0]));
        }
        this.liquibase = (Liquibase)object.get("liquibase");
        this.outputWriter = (Writer)object.get("outputWriter");
    }

    protected RollbackVisitor createRollbackVisitor() {
        return new RollbackVisitor(this.database, this.changeExecListener);
    }

    protected void removeRunStatus(ChangeLogIterator changeLogIterator, Contexts contexts, LabelExpression labelExpression) {
        changeLogIterator.run(new RollbackOneUpdateCommand$1(this), new RuntimeEnvironment(this.database, contexts, labelExpression));
    }

    @Override
    protected CommandResult run() {
        Object object;
        Object object2;
        Object object3;
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        Object object4 = "rollbackOneUpdate";
        Executor executor = null;
        if (this.outputWriter != null) {
            object4 = "rollbackOneUpdateSQL";
            executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
            object3 = new LoggingExecutor(executor, this.outputWriter, this.database);
            Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, (Executor)object3);
            Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("logging", this.database, (Executor)object3);
        } else {
            object3 = new LoggingExecutor(null, null, this.database);
        }
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("logging", this.database, (Executor)object3);
        object3 = null;
        HubUpdater hubUpdater = new HubUpdater(new Date(), this.changeLog, this.database);
        BufferedLogService bufferedLogService = new BufferedLogService();
        Map.Entry<String, ChangeSet> entry2 = this.database.getRanChangeSetList();
        if (this.deploymentId == null) {
            this.deploymentId = this.getLastDeploymentId((List<RanChangeSet>)((Object)entry2));
            if (this.deploymentId == null) {
                throw new LiquibaseException(String.format(coreBundle.getString("no.deployment.ids.found"), new Object[0]));
            }
            Scope.getCurrentScope().getUI().sendMessage("Defaulting to last deployment ID '" + this.deploymentId + "'");
        } else {
            boolean bl2 = false;
            object2 = entry2.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!this.deploymentId.equals(((RanChangeSet)object).getDeploymentId())) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                object2 = String.format(coreBundle.getString("no.change.sets.found.for.deployment.id"), this.deploymentId);
                throw new LiquibaseException("\n".concat(String.valueOf(object2)));
            }
        }
        this.liquibase.outputHeader("Rollback deployment ID '" + this.deploymentId + "'");
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            this.checkLiquibaseTables(false, this.changeLog, this.contexts, this.labelExpression);
            this.changeLog.validate(this.database, this.contexts, this.labelExpression);
            object2 = new DeploymentIdFilter(this.deploymentId, this.database, (List<RanChangeSet>)((Object)entry2), this.changeLog, (String)object4);
            if (!((DeploymentIdFilter)object2).getNoInverseChangeSets().isEmpty()) {
                object = "\n\nThere are change sets associated with the deployment ID '" + this.deploymentId + "' which cannot be rolled back.\nNo rollback was performed.\n";
                object = (String)object + "\nChange Sets which cannot be rolled back:\n";
                for (Map.Entry<String, ChangeSet> entry2 : ((DeploymentIdFilter)object2).getNoInverseChangeSets().entrySet()) {
                    object = (String)object + entry2.getKey();
                    object = (String)object + "\n";
                }
                throw new LiquibaseException("\n".concat(String.valueOf(object)));
            }
            if (((DeploymentIdFilter)object2).isEmpty()) {
                object = "\n\nThere are no change sets associated with the deployment ID '" + this.deploymentId + "'.\nPlease check your parameters.  No rollback was performed.\n";
                throw new LiquibaseException("\n".concat(String.valueOf(object)));
            }
            object = this.createChangeLogIterator((List<RanChangeSet>)((Object)entry2), (ChangeSetFilter)object2);
            object4 = this.outputWriter == null ? this.liquibase.getConnection(this.changeLog) : null;
            if (object4 != null) {
                object3 = hubUpdater.preUpdateHub("ROLLBACK", (Connection)object4, this.changeLogFilePath, this.contexts, this.labelExpression, (ChangeLogIterator)object);
                this.changeExecListener = new HubChangeExecListener((Operation)object3, this.changeExecListener);
            }
            object4 = this.createChangeLogIterator((List<RanChangeSet>)((Object)entry2), (ChangeSetFilter)object2);
            entry2 = new CompositeLogService(true, bufferedLogService);
            Scope.child(Scope.Attr.logService.name(), entry2, () -> object4.run(this.createRollbackVisitor(), new RuntimeEnvironment(this.database, this.contexts, this.labelExpression)));
            hubUpdater.postUpdateHub((Operation)object3, bufferedLogService);
        }
        catch (LiquibaseException liquibaseException) {
            hubUpdater.postUpdateHubExceptionHandling((Operation)object3, bufferedLogService, liquibaseException.getMessage());
            if (liquibaseException.getCause() instanceof RollbackImpossibleException) {
                object4 = "\nError executing rollback:\nThe rollback for deployment ID '" + this.deploymentId + "' has at least one change set without a rollback defined\nPlease add a rollback change in the appropriate changeset.\n";
                logger.severe((String)object4, liquibaseException);
                if (this.changeExecListener != null) {
                    this.changeExecListener.runFailed(null, this.changeLog, this.database, liquibaseException);
                }
                throw new LiquibaseException((String)object4, liquibaseException);
            }
            logger.severe("\nError executing rollback for the deployment ID '" + this.deploymentId + "'.");
            throw new LiquibaseException("\nError executing rollback for the deployment ID '" + this.deploymentId + "':\n" + liquibaseException.getMessage(), liquibaseException);
        }
        finally {
            try {
                lockService.releaseLock();
            }
            catch (LockException lockException) {
                logger.severe(MSG_COULD_NOT_RELEASE_LOCK, lockException);
            }
            if (executor != null) {
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, executor);
            }
        }
        this.resetServices();
        return new CommandResult("rollbackOneChangeSet executed for " + this.database.getConnection().getConnectionUserName() + "@" + this.database.getConnection().getURL());
    }

    private String getLastDeploymentId(List<RanChangeSet> object) {
        if (object == null || object.size() == 0) {
            return null;
        }
        List<RanChangeSet> list = object;
        object = list.get(list.size() - 1).getDeploymentId();
        if (object == null) {
            return null;
        }
        return object;
    }

    protected ChangeLogIterator createChangeLogIterator(List<RanChangeSet> list, ChangeSetFilter changeSetFilter) {
        return new ChangeLogIterator(list, this.changeLog, changeSetFilter, new AlreadyRanChangeSetFilter(list), new ContextChangeSetFilter(this.contexts), new LabelChangeSetFilter(this.labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(this.database));
    }

    protected void checkLiquibaseTables(boolean bl2, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labelExpression) {
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
        changeLogHistoryService.init();
        if (bl2) {
            changeLogHistoryService.upgradeChecksums(databaseChangeLog, contexts, labelExpression);
        }
        LockServiceFactory.getInstance().getLockService(this.database).init();
    }

    protected void resetServices() {
        LockServiceFactory.getInstance().resetAll();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
        Scope.getCurrentScope().getSingleton(ExecutorService.class).reset();
    }
}

