/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import liquibase.configuration.ConfigurationValueHandler;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.util.ObjectUtil;
import liquibase.util.StringUtil;

public class ConfigurationProperty {
    private final String namespace;
    private final String name;
    private final Class type;
    private List<String> aliases = new ArrayList<String>();
    private Object value;
    private String description;
    private Object defaultValue;
    private boolean wasOverridden;
    private ConfigurationValueHandler valueHandler;

    public ConfigurationProperty(String namespace, String propertyName, Class type) {
        this.namespace = namespace;
        this.name = propertyName;
        this.type = type;
    }

    protected void init(ConfigurationValueProvider[] configurationValueProviders) {
        Object containerValue = null;
        block2: for (ConfigurationValueProvider container : configurationValueProviders) {
            containerValue = container.getValue(this.namespace, this.name);
            for (String alias : this.aliases) {
                if (containerValue != null) continue block2;
                containerValue = container.getValue(this.namespace, alias);
            }
        }
        if (containerValue == null) {
            this.value = this.defaultValue;
        } else {
            try {
                this.value = this.valueOf(containerValue);
                this.wasOverridden = true;
            }
            catch (NumberFormatException e2) {
                throw new UnexpectedLiquibaseException("Error parsing " + containerValue + " as a " + this.type.getSimpleName());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Class getType() {
        return this.type;
    }

    protected Object valueOf(Object value) {
        if (value == null) {
            return value;
        }
        if (this.type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value instanceof String) {
            if (this.type.equals(Boolean.class)) {
                return Boolean.valueOf((String)value);
            }
            if (this.type.equals(Integer.class)) {
                return Integer.valueOf((String)value);
            }
            if (this.type.equals(BigDecimal.class)) {
                return new BigDecimal((String)value);
            }
            if (this.type.equals(Long.class)) {
                return Long.valueOf((String)value);
            }
            if (this.type.equals(List.class)) {
                return StringUtil.splitAndTrim((String)value, ",");
            }
            throw new UnexpectedLiquibaseException("Cannot parse property " + value.getClass().getSimpleName() + " to a " + this.type.getSimpleName());
        }
        throw new UnexpectedLiquibaseException("Could not convert " + value.getClass().getSimpleName() + " to a " + this.type.getSimpleName());
    }

    public Object getValue() {
        return this.value;
    }

    public <T> T getValue(Class<T> type) {
        if (!this.type.isAssignableFrom(type)) {
            throw new UnexpectedLiquibaseException("Property " + this.name + " on is of type " + this.type.getSimpleName() + ", not " + type.getSimpleName());
        }
        return (T)this.value;
    }

    public void setValue(Object value) {
        value = this.valueHandler == null ? ObjectUtil.convert(value, this.type) : this.valueHandler.convert(value);
        if (value != null && !this.type.isAssignableFrom(value.getClass())) {
            throw new UnexpectedLiquibaseException("Property " + this.name + " is of type " + this.type.getSimpleName() + ", not " + value.getClass().getSimpleName());
        }
        this.value = value;
        this.wasOverridden = true;
    }

    public ConfigurationProperty addAlias(String ... aliases) {
        if (aliases != null) {
            this.aliases.addAll(Arrays.asList(aliases));
        }
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ConfigurationProperty setDescription(String description) {
        this.description = description;
        return this;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public ConfigurationProperty setDefaultValue(Object defaultValue) {
        if (defaultValue != null && !this.type.isAssignableFrom(defaultValue.getClass())) {
            if (this.type == Long.class && defaultValue instanceof Integer) {
                return this.setDefaultValue(((Integer)defaultValue).longValue());
            }
            throw new UnexpectedLiquibaseException("Property " + this.name + " on is of type " + this.type.getSimpleName() + ", not " + defaultValue.getClass().getSimpleName());
        }
        this.defaultValue = defaultValue;
        return this;
    }

    public boolean getWasOverridden() {
        return this.wasOverridden;
    }

    public ConfigurationProperty setValueHandler(ConfigurationValueHandler handler) {
        this.valueHandler = handler;
        return this;
    }
}

