/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration;

import java.util.Map;
import liquibase.configuration.AbstractConfigurationValueProvider;
import liquibase.configuration.ProvidedValue;
import liquibase.util.StringUtil;

public abstract class AbstractMapConfigurationValueProvider
extends AbstractConfigurationValueProvider {
    protected abstract Map<?, ?> getMap();

    protected abstract String getSourceDescription();

    @Override
    public ProvidedValue getProvidedValue(String ... keyAndAliases) {
        if (keyAndAliases == null || keyAndAliases.length == 0) {
            return null;
        }
        Map<?, ?> sourceData = this.getMap();
        if (sourceData == null) {
            return null;
        }
        for (String key : keyAndAliases) {
            Object foundValue;
            if (sourceData.containsKey(key) && this.isValueSet(foundValue = sourceData.get(key))) {
                return new ProvidedValue(keyAndAliases[0], key, foundValue, this.getSourceDescription(), this);
            }
            for (Map.Entry<?, ?> entry : sourceData.entrySet()) {
                Object value;
                String actualKey = String.valueOf(entry.getKey());
                if (!this.keyMatches(key, actualKey) || !this.isValueSet(value = entry.getValue())) continue;
                return new ProvidedValue(keyAndAliases[0], actualKey, value, this.getSourceDescription(), this);
            }
        }
        return null;
    }

    protected boolean isValueSet(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            return StringUtil.isNotEmpty((String)value);
        }
        return true;
    }

    protected boolean keyMatches(String wantedKey, String storedKey) {
        if (storedKey.equalsIgnoreCase(wantedKey)) {
            return true;
        }
        if (storedKey.equalsIgnoreCase(wantedKey = StringUtil.toKabobCase(wantedKey))) {
            return true;
        }
        if (storedKey.equalsIgnoreCase(wantedKey = wantedKey.replace(".", "-"))) {
            return true;
        }
        return storedKey.equalsIgnoreCase(wantedKey = wantedKey.replace("-", ""));
    }
}

