/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration.pro;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.configuration.AbstractMapConfigurationValueProvider;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.ProvidedValue;
import liquibase.license.LicenseServiceFactory;
import liquibase.util.StringUtil;

public class EnvironmentValueProvider
extends AbstractMapConfigurationValueProvider {
    private Map<String, String> environment = System.getenv();

    @Override
    public int getPrecedence() {
        return 150;
    }

    @Override
    protected Map<?, ?> getMap() {
        return this.environment;
    }

    @Override
    public ProvidedValue getProvidedValue(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        boolean bl2 = false;
        ConfigurationDefinition<?> configurationDefinition = Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class).getRegisteredDefinition(stringArray[0]);
        if (configurationDefinition != null) {
            bl2 = this.getUnlicensedVariables().contains(configurationDefinition);
        }
        if (!bl2) {
            Object object = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class);
            if (object == null) {
                return null;
            }
            if ((object = ((LicenseServiceFactory)object).getLicenseService()) == null) {
                return null;
            }
            if (!object.licenseIsValid("Liquibase Pro")) {
                return null;
            }
        }
        return super.getProvidedValue(stringArray);
    }

    @Override
    protected String getSourceDescription() {
        return "Environment variable";
    }

    public Set<ConfigurationDefinition<?>> getUnlicensedVariables() {
        HashSet hashSet = new HashSet();
        hashSet.add(GlobalConfiguration.FILTER_LOG_MESSAGES);
        hashSet.add(LiquibaseProConfiguration.LICENSE_KEY);
        return hashSet;
    }

    @Override
    protected boolean keyMatches(String string, String string2) {
        if (super.keyMatches(string, string2 = StringUtil.trimToNull(string2))) {
            return true;
        }
        if ((string = StringUtil.toKabobCase(string.replace(".", "-"))).equalsIgnoreCase(string2)) {
            return true;
        }
        return string.replace("-", "_").equalsIgnoreCase(string2);
    }
}

