/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandFactory;
import liquibase.command.core.CalculateChecksumCommandStep;
import liquibase.command.core.ChangelogSyncToTagCommandStep;
import liquibase.command.core.ChangelogSyncToTagSqlCommandStep;
import liquibase.command.core.DbDocCommandStep;
import liquibase.command.core.FutureRollbackCountSqlCommandStep;
import liquibase.command.core.FutureRollbackFromTagSqlCommandStep;
import liquibase.command.core.RollbackCommandStep;
import liquibase.command.core.RollbackCountCommandStep;
import liquibase.command.core.RollbackCountSqlCommandStep;
import liquibase.command.core.RollbackSqlCommandStep;
import liquibase.command.core.RollbackToDateCommandStep;
import liquibase.command.core.RollbackToDateSqlCommandStep;
import liquibase.command.core.TagCommandStep;
import liquibase.command.core.TagExistsCommandStep;
import liquibase.command.core.UpdateCountCommandStep;
import liquibase.command.core.UpdateCountSqlCommandStep;
import liquibase.command.core.UpdateToTagCommandStep;
import liquibase.command.core.UpdateToTagSqlCommandStep;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.core.DefaultsFileValueProvider;
import liquibase.exception.CommandLineParsingException;
import liquibase.exception.CommandValidationException;
import liquibase.hub.HubConfiguration;
import liquibase.integration.commandline.CommandLineArgumentValueProvider;
import liquibase.integration.commandline.CommandLineResourceAccessor;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.integration.commandline.CommandRunner;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.integration.commandline.Main;
import liquibase.license.LicenseServiceFactory;
import liquibase.logging.LogMessageFilter;
import liquibase.logging.LogService;
import liquibase.logging.core.JavaLogService;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.ui.ConsoleUIService;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtil;
import liquibase.util.SystemUtil;
import picocli.CommandLine;

public class LiquibaseCommandLine {
    private final Map<String, String> legacyPositionalArguments;
    private final Set<String> legacyNoLongerGlobalArguments;
    private final Set<String> legacyNoLongerCommandArguments;
    private Level configuredLogLevel;
    private final CommandLine commandLine;
    private FileHandler fileHandler;
    private final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    private CommandLine.IFactory defaultFactory = new CommandLine.IFactory(){

        public <K> K create(Class<K> cls) throws Exception {
            return cls.newInstance();
        }
    };

    public static void main(String[] args) {
        System.setProperty("org.fusesource.jansi.Ansi.disable", "true");
        LiquibaseCommandLine cli = new LiquibaseCommandLine();
        int returnCode = cli.execute(args);
        System.exit(returnCode);
    }

    private void cleanup() {
        if (this.fileHandler != null) {
            this.fileHandler.flush();
            this.fileHandler.close();
        }
    }

    public LiquibaseCommandLine() {
        this.legacyPositionalArguments = new HashMap<String, String>();
        this.legacyPositionalArguments.put("calculatechecksum", CalculateChecksumCommandStep.CHANGESET_IDENTIFIER_ARG.getName());
        this.legacyPositionalArguments.put("changelogsynctotag", ChangelogSyncToTagCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("changelogsynctotagsql", ChangelogSyncToTagSqlCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("dbdoc", DbDocCommandStep.OUTPUT_DIRECTORY_ARG.getName());
        this.legacyPositionalArguments.put("futurerollbackcountsql", FutureRollbackCountSqlCommandStep.COUNT_ARG.getName());
        this.legacyPositionalArguments.put("futurerollbackfromtagsql", FutureRollbackFromTagSqlCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("tag", TagCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("tagExists", TagExistsCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("rollback", RollbackCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("rollbacksql", RollbackSqlCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("rollbacktodate", RollbackToDateCommandStep.DATE_ARG.getName());
        this.legacyPositionalArguments.put("rollbacktodatesql", RollbackToDateSqlCommandStep.DATE_ARG.getName());
        this.legacyPositionalArguments.put("rollbackcount", RollbackCountCommandStep.COUNT_ARG.getName());
        this.legacyPositionalArguments.put("rollbackcountsql", RollbackCountSqlCommandStep.COUNT_ARG.getName());
        this.legacyPositionalArguments.put("updatecount", UpdateCountCommandStep.COUNT_ARG.getName());
        this.legacyPositionalArguments.put("updatecountsql", UpdateCountSqlCommandStep.COUNT_ARG.getName());
        this.legacyPositionalArguments.put("updatetotag", UpdateToTagCommandStep.TAG_ARG.getName());
        this.legacyPositionalArguments.put("updatetotagsql", UpdateToTagSqlCommandStep.TAG_ARG.getName());
        this.legacyNoLongerGlobalArguments = Stream.of("username", "password", "url", "outputDefaultSchema", "outputDefaultCatalog", "changelogFile", "hubConnectionId", "contexts", "labels", "diffTypes", "changesetAuthor", "changesetContext", "dataOutputDirectory", "referenceDriver", "referenceUrl", "referenceUsername", "referencePassword", "referenceDefaultCatalogName", "referenceDefaultSchemaName", "excludeObjects", "includeCatalog", "includeObjects", "includeSchema", "includeTablespace", "outputSchemasAs", "referenceSchemas", "schemas", "snapshotFormat", "sqlFile", "delimiter", "rollbackScript", "overwriteOutputFile", "changeExecListenerClass", "changeExecListenerPropertiesFile", "defaultSchemaName", "defaultCatalogName").collect(Collectors.toSet());
        this.legacyNoLongerCommandArguments = Stream.of("databaseClass", "liquibaseCatalogName", "liquibaseSchemaName", "databaseChangeLogTableName", "databaseChangeLogLockTableName", "databaseChangeLogTablespaceName", "classpath", "propertyProviderClass", "promptForNonLocalDatabase", "includeSystemClasspath", "defaultsFile", "currentDateTimeFunction", "logLevel", "logFile", "outputFile", "liquibaseProLicenseKey", "liquibaseHubApiKey", "outputFileEncoding", "outputLineSeparator").collect(Collectors.toSet());
        this.commandLine = this.buildPicoCommandLine();
    }

    private CommandLine buildPicoCommandLine() {
        CommandLine.Model.CommandSpec rootCommandSpec = CommandLine.Model.CommandSpec.wrapWithoutInspection(null, (CommandLine.IFactory)this.defaultFactory);
        rootCommandSpec.name("liquibase");
        this.configureHelp(rootCommandSpec, true);
        rootCommandSpec.subcommandsCaseInsensitive(true);
        rootCommandSpec.usageMessage().customSynopsis(new String[]{"liquibase [GLOBAL OPTIONS] [COMMAND] [COMMAND OPTIONS]\nCommand-specific help: \"liquibase <command-name> --help\""}).optionListHeading("\nGlobal Options\n").commandListHeading("\nCommands\n");
        CommandLine commandLine = new CommandLine((Object)rootCommandSpec, this.defaultFactory).setCaseInsensitiveEnumValuesAllowed(true).setOptionsCaseInsensitive(true).setUsageHelpAutoWidth(true);
        this.addGlobalArguments(commandLine);
        for (CommandDefinition commandDefinition : this.getCommands()) {
            this.addSubcommand(commandDefinition, commandLine);
        }
        commandLine.setExecutionExceptionHandler((ex2, commandLine1, parseResult) -> this.handleException(ex2));
        return commandLine;
    }

    private int handleException(Throwable exception) {
        Throwable cause = exception;
        String bestMessage = exception.getMessage();
        while (cause.getCause() != null) {
            if (StringUtil.trimToNull(cause.getMessage()) != null) {
                bestMessage = cause.getMessage();
            }
            cause = cause.getCause();
        }
        if (bestMessage == null) {
            bestMessage = exception.getClass().getName();
        } else {
            bestMessage = bestMessage.replaceFirst("^[\\w.]*exception[\\w.]*: ", "");
            bestMessage = bestMessage.replace("Unexpected error running Liquibase: ", "");
        }
        Scope.getCurrentScope().getLog(this.getClass()).severe(bestMessage, exception);
        boolean printUsage = false;
        try (StringWriter suggestionWriter = new StringWriter();
             PrintWriter suggestionsPrintWriter = new PrintWriter(suggestionWriter);){
            if (exception instanceof CommandLine.ParameterException) {
                if (exception instanceof CommandLine.UnmatchedArgumentException) {
                    System.err.println("Unexpected argument(s): " + StringUtil.join(((CommandLine.UnmatchedArgumentException)exception).getUnmatched(), ", "));
                } else {
                    System.err.println("Error parsing command line: " + bestMessage);
                }
                CommandLine.UnmatchedArgumentException.printSuggestions((CommandLine.ParameterException)((CommandLine.ParameterException)exception), (PrintWriter)suggestionsPrintWriter);
                printUsage = true;
            } else if (exception instanceof IllegalArgumentException || exception instanceof CommandValidationException || exception instanceof CommandLineParsingException) {
                System.err.println("Error parsing command line: " + bestMessage);
                printUsage = true;
            } else {
                System.err.println("Unexpected error running Liquibase: " + bestMessage);
                System.err.println();
                if (Level.OFF.equals(this.configuredLogLevel)) {
                    System.err.println("For more information, please use the --log-level flag");
                } else if (LiquibaseCommandLineConfiguration.LOG_FILE.getCurrentValue() == null) {
                    exception.printStackTrace(System.err);
                }
            }
            if (printUsage) {
                System.err.println();
                System.err.println("For detailed help, try 'liquibase --help' or 'liquibase <command-name> --help'");
            }
            suggestionsPrintWriter.flush();
            String suggestions = suggestionWriter.toString();
            if (suggestions.length() > 0) {
                System.err.println();
                System.err.println(suggestions);
            }
        }
        catch (IOException e2) {
            Scope.getCurrentScope().getLog(this.getClass()).warning("Error closing stream: " + e2.getMessage(), e2);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String[] args) {
        try {
            LiquibaseConfiguration liquibaseConfiguration;
            int n2;
            String[] finalArgs = this.adjustLegacyArgs(args);
            this.configureLogging(Level.OFF, null);
            Main.runningFromNewCli = true;
            List<ConfigurationValueProvider> valueProviders = this.registerValueProviders(finalArgs);
            try {
                n2 = Scope.child(this.configureScope(), () -> {
                    if (!LiquibaseCommandLineConfiguration.SHOULD_RUN.getCurrentValue().booleanValue()) {
                        Scope.getCurrentScope().getUI().sendErrorMessage(String.format(this.coreBundle.getString("did.not.run.because.param.was.set.to.false"), LiquibaseCommandLineConfiguration.SHOULD_RUN.getCurrentConfiguredValue().getProvidedValue().getActualKey()));
                        return 0;
                    }
                    this.configureVersionInfo();
                    if (!this.wasHelpOrVersionRequested()) {
                        Scope.getCurrentScope().getUI().sendMessage(CommandLineUtils.getBanner());
                        Scope.getCurrentScope().getUI().sendMessage(String.format(this.coreBundle.getString("version.number"), LiquibaseUtil.getBuildVersion()));
                        Scope.getCurrentScope().getUI().sendMessage(Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class).getLicenseService().getLicenseInfo());
                    }
                    int response = this.commandLine.execute(finalArgs);
                    if (!this.wasHelpOrVersionRequested()) {
                        ConfiguredValue<File> outputFile;
                        ConfiguredValue<File> logFile = LiquibaseCommandLineConfiguration.LOG_FILE.getCurrentConfiguredValue();
                        if (logFile.found()) {
                            Scope.getCurrentScope().getUI().sendMessage("Logs saved to " + logFile.getValue().getAbsolutePath());
                        }
                        if ((outputFile = LiquibaseCommandLineConfiguration.OUTPUT_FILE.getCurrentConfiguredValue()).found()) {
                            Scope.getCurrentScope().getUI().sendMessage("Output saved to " + outputFile.getValue().getAbsolutePath());
                        }
                        if (response == 0) {
                            List commandList = this.commandLine.getParseResult().asCommandLineList();
                            String commandName = StringUtil.join(LiquibaseCommandLine.getCommandNames((CommandLine)commandList.get(commandList.size() - 1)), " ");
                            Scope.getCurrentScope().getUI().sendMessage("Liquibase command '" + commandName + "' was executed successfully.");
                        }
                    }
                    return response;
                });
                liquibaseConfiguration = Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
            }
            catch (Throwable throwable) {
                try {
                    LiquibaseConfiguration liquibaseConfiguration2 = Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
                    for (ConfigurationValueProvider provider : valueProviders) {
                        liquibaseConfiguration2.unregisterProvider(provider);
                    }
                    throw throwable;
                }
                catch (Throwable e2) {
                    this.handleException(e2);
                    int n3 = 1;
                    return n3;
                }
            }
            for (ConfigurationValueProvider provider : valueProviders) {
                liquibaseConfiguration.unregisterProvider(provider);
            }
            return n2;
        }
        finally {
            this.cleanup();
        }
    }

    private boolean wasHelpOrVersionRequested() {
        for (CommandLine.ParseResult parseResult = this.commandLine.getParseResult(); parseResult != null; parseResult = parseResult.subcommand()) {
            if (!parseResult.isUsageHelpRequested() && !parseResult.isVersionHelpRequested()) continue;
            return true;
        }
        return false;
    }

    protected String[] adjustLegacyArgs(String[] args) {
        ArrayList<String> returnArgs = new ArrayList<String>();
        ListIterator<String> iterator = Arrays.asList(args).listIterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            String argAsKey = arg.replace("-", "").toLowerCase();
            if (arg.startsWith("-")) {
                returnArgs.add(arg);
                continue;
            }
            String legacyTag = this.legacyPositionalArguments.get(argAsKey);
            if (legacyTag == null) {
                returnArgs.add(arg);
                continue;
            }
            returnArgs.add(arg);
            String value = " ";
            while (iterator.hasNext()) {
                arg = iterator.next();
                if (arg.startsWith("-")) {
                    iterator.previous();
                    break;
                }
                value = value + arg + " ";
            }
            if ((value = StringUtil.trimToNull(value)) == null) continue;
            returnArgs.add("--" + legacyTag);
            returnArgs.add(value);
        }
        return returnArgs.toArray(new String[0]);
    }

    static String[] getCommandNames(CommandLine parseResult) {
        ArrayList<String> returnList = new ArrayList<String>();
        while (!parseResult.getCommandName().equals("liquibase")) {
            returnList.add(0, parseResult.getCommandName());
            parseResult = parseResult.getParent();
        }
        return returnList.toArray(new String[0]);
    }

    private List<ConfigurationValueProvider> registerValueProviders(String[] args) {
        LiquibaseConfiguration liquibaseConfiguration = Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
        ArrayList<ConfigurationValueProvider> returnList = new ArrayList<ConfigurationValueProvider>();
        CommandLineArgumentValueProvider argumentProvider = new CommandLineArgumentValueProvider(this.commandLine.parseArgs(args));
        liquibaseConfiguration.registerProvider(argumentProvider);
        returnList.add(argumentProvider);
        ConfiguredValue<String> defaultsFileConfig = LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getCurrentConfiguredValue();
        File defaultsFile = new File(defaultsFileConfig.getValue());
        if (defaultsFile.exists()) {
            DefaultsFileValueProvider fileProvider = new DefaultsFileValueProvider(defaultsFile);
            liquibaseConfiguration.registerProvider(fileProvider);
            returnList.add(fileProvider);
        } else {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Cannot find defaultsFile " + defaultsFile.getAbsolutePath());
            if (!defaultsFileConfig.wasDefaultValueUsed()) {
                System.err.println("Could not find defaults file " + defaultsFile.getAbsolutePath());
            }
        }
        File localDefaultsFile = new File(defaultsFile.getAbsolutePath().replaceFirst(".properties$", ".local.properties"));
        if (localDefaultsFile.exists()) {
            DefaultsFileValueProvider fileProvider = new DefaultsFileValueProvider(localDefaultsFile){

                @Override
                public int getPrecedence() {
                    return super.getPrecedence() + 1;
                }
            };
            liquibaseConfiguration.registerProvider(fileProvider);
            returnList.add(fileProvider);
        } else {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Cannot find local defaultsFile " + defaultsFile.getAbsolutePath());
        }
        return returnList;
    }

    private Map<String, Object> configureScope() throws Exception {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ClassLoader classLoader = this.configureClassLoader();
        returnMap.putAll(this.configureLogging());
        returnMap.putAll(this.configureResourceAccessor(classLoader));
        ConsoleUIService ui = new ConsoleUIService();
        ui.setAllowPrompt(true);
        ui.setOutputStream(System.err);
        returnMap.put(Scope.Attr.ui.name(), ui);
        returnMap.put(LiquibaseCommandLineConfiguration.ARGUMENT_CONVERTER.getKey(), argument -> "--" + StringUtil.toKabobCase(argument));
        return returnMap;
    }

    private void configureVersionInfo() {
        this.getRootCommand(this.commandLine).getCommandSpec().version(new String[]{CommandLineUtils.getBanner(), String.format("Running Java under %s (Version %s)", System.getProperties().getProperty("java.home"), System.getProperty("java.version")), "", "Liquibase Version: " + LiquibaseUtil.getBuildVersion(), Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class).getLicenseService().getLicenseInfo()});
    }

    protected Map<String, Object> configureLogging() throws IOException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ConfiguredValue<Level> currentConfiguredValue = LiquibaseCommandLineConfiguration.LOG_LEVEL.getCurrentConfiguredValue();
        File logFile = LiquibaseCommandLineConfiguration.LOG_FILE.getCurrentValue();
        Level logLevel = Level.OFF;
        if (!currentConfiguredValue.wasDefaultValueUsed()) {
            logLevel = currentConfiguredValue.getValue();
        }
        this.configureLogging(logLevel, logFile);
        if (logLevel != Level.OFF) {
            returnMap.put(HubConfiguration.LIQUIBASE_HUB_LOGLEVEL.getKey(), logLevel);
        }
        return returnMap;
    }

    private void configureLogging(Level logLevel, File logFile) throws IOException {
        this.configuredLogLevel = logLevel;
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT] %4$s [%2$s] %5$s%6$s%n");
        Logger liquibaseLogger = Logger.getLogger("liquibase");
        JavaLogService logService = (JavaLogService)((Object)Scope.getCurrentScope().get((Enum)Scope.Attr.logService, LogService.class));
        logService.setParent(liquibaseLogger);
        Logger rootLogger = Logger.getLogger("");
        Level cliLogLevel = logLevel;
        if (logFile != null) {
            if (this.fileHandler == null) {
                this.fileHandler = new FileHandler(logFile.getAbsolutePath(), true);
                this.fileHandler.setFormatter(new SimpleFormatter());
                rootLogger.addHandler(this.fileHandler);
            }
            this.fileHandler.setLevel(logLevel);
            if (logLevel == Level.OFF) {
                this.fileHandler.setLevel(Level.FINE);
            }
            cliLogLevel = Level.OFF;
        }
        rootLogger.setLevel(logLevel);
        liquibaseLogger.setLevel(logLevel);
        for (Handler handler : rootLogger.getHandlers()) {
            if (handler instanceof ConsoleHandler) {
                handler.setLevel(cliLogLevel);
            }
            handler.setFilter(new SecureLogFilter(logService.getFilter()));
        }
    }

    private CommandLine getRootCommand(CommandLine commandLine) {
        while (commandLine.getParent() != null) {
            commandLine = commandLine.getParent();
        }
        return commandLine;
    }

    private Map<String, Object> configureResourceAccessor(ClassLoader classLoader) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put(Scope.Attr.resourceAccessor.name(), new CompositeResourceAccessor(new FileSystemResourceAccessor(Paths.get(".", new String[0]).toAbsolutePath().toFile()), new CommandLineResourceAccessor(classLoader)));
        return returnMap;
    }

    protected ClassLoader configureClassLoader() throws IllegalArgumentException {
        String classpath = LiquibaseCommandLineConfiguration.CLASSPATH.getCurrentValue();
        ArrayList<URL> urls = new ArrayList<URL>();
        if (classpath != null) {
            String[] classpathSoFar = SystemUtil.isWindows() ? classpath.split(";") : classpath.split(":");
            for (String classpathEntry : classpathSoFar) {
                File classPathFile = new File(classpathEntry);
                if (!classPathFile.exists()) {
                    throw new IllegalArgumentException(classPathFile.getAbsolutePath() + " does.not.exist");
                }
                try {
                    URL newUrl = new File(classpathEntry).toURI().toURL();
                    Scope.getCurrentScope().getLog(this.getClass()).fine(newUrl.toExternalForm() + " added to class loader");
                    urls.add(newUrl);
                }
                catch (MalformedURLException e2) {
                    throw new IllegalArgumentException(e2);
                }
            }
        }
        ClassLoader classLoader = LiquibaseCommandLineConfiguration.INCLUDE_SYSTEM_CLASSPATH.getCurrentValue() != false ? (ClassLoader)AccessController.doPrivileged(() -> new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader())) : (ClassLoader)AccessController.doPrivileged(() -> new URLClassLoader(urls.toArray(new URL[0]), null));
        Thread.currentThread().setContextClassLoader(classLoader);
        return classLoader;
    }

    private void addSubcommand(CommandDefinition commandDefinition, CommandLine rootCommand) {
        List<String[]> commandNames = this.expandCommandNames(commandDefinition);
        boolean showCommand = true;
        for (String[] commandName : commandNames) {
            String shortDescription;
            CommandRunner commandRunner = new CommandRunner();
            CommandLine.Model.CommandSpec subCommandSpec = CommandLine.Model.CommandSpec.wrapWithoutInspection((Object)commandRunner, (CommandLine.IFactory)this.defaultFactory);
            commandRunner.setSpec(subCommandSpec);
            this.configureHelp(subCommandSpec, false);
            String displayDescription = shortDescription = commandDefinition.getShortDescription();
            String legacyCommand = commandName[commandName.length - 1];
            String camelCaseCommand = StringUtil.toCamelCase(legacyCommand);
            if (!legacyCommand.equals(camelCaseCommand)) {
                displayDescription = "\n" + shortDescription + "\n[deprecated: " + camelCaseCommand + "]";
            }
            subCommandSpec.usageMessage().header(new String[]{StringUtil.trimToEmpty(displayDescription) + "\n"}).description(new String[]{StringUtil.trimToEmpty(commandDefinition.getLongDescription())});
            subCommandSpec.optionsCaseInsensitive(true);
            subCommandSpec.subcommandsCaseInsensitive(true);
            if (!showCommand) {
                subCommandSpec.usageMessage().hidden(true);
            } else {
                subCommandSpec.usageMessage().hidden(commandDefinition.getHidden());
            }
            showCommand = false;
            for (CommandArgumentDefinition<?> def : commandDefinition.getArguments().values()) {
                String[] argNames = LiquibaseCommandLine.toArgNames(def);
                for (int i2 = 0; i2 < argNames.length; ++i2) {
                    CommandLine.Model.OptionSpec.Builder builder = this.createArgBuilder(def, argNames[i2]);
                    String argDisplaySuffix = "";
                    String argName = argNames[i2];
                    String camelCaseArg = StringUtil.toCamelCase(argName.substring(2));
                    if (!argName.equals("--" + camelCaseArg)) {
                        argDisplaySuffix = "\n[deprecated: --" + camelCaseArg + "]";
                    }
                    String description = "\n(liquibase.command." + def.getName() + " OR liquibase.command." + StringUtil.join(commandDefinition.getName(), ".") + "." + def.getName() + ")\n(" + this.toEnvVariable("liquibase.command." + def.getName()) + " OR " + this.toEnvVariable("liquibase.command." + StringUtil.join(commandDefinition.getName(), ".") + "." + def.getName()) + ")" + argDisplaySuffix;
                    if (def.getDefaultValue() != null) {
                        description = def.getDefaultValueDescription() == null ? "\nDEFAULT: " + def.getDefaultValue() + "\n" + description : "\nDEFAULT: " + def.getDefaultValueDescription() + "\n" + description;
                    }
                    if (def.getDescription() != null) {
                        description = def.getDescription() + description;
                    }
                    if (def.isRequired()) {
                        description = "[REQUIRED] " + description;
                    }
                    builder.description(new String[]{description + "\n"});
                    if (def.getDataType().equals(Boolean.class)) {
                        builder.arity("0..1");
                    }
                    if (i2 > 0) {
                        builder.hidden(true);
                    } else {
                        builder.hidden(def.getHidden());
                    }
                    subCommandSpec.addOption(builder.build());
                }
            }
            for (String legacyArg : this.legacyNoLongerCommandArguments) {
                CommandLine.Model.OptionSpec.Builder builder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)("--" + legacyArg), (String[])new String[0]).required(false)).type(String.class)).description(new String[]{"Legacy CLI argument"})).hidden(true);
                subCommandSpec.addOption(builder.build());
                String kabobArg = StringUtil.toKabobCase(legacyArg);
                if (kabobArg.equals(legacyArg)) continue;
                CommandLine.Model.OptionSpec.Builder kabobOptionBuilder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)("--" + kabobArg), (String[])new String[0]).required(false)).type(String.class)).hidden(true)).description(new String[]{"Legacy CLI argument"});
                subCommandSpec.addOption(kabobOptionBuilder.build());
            }
            this.getParentCommandSpec(commandDefinition, rootCommand).addSubcommand(commandName[commandName.length - 1], new CommandLine((Object)subCommandSpec, this.defaultFactory));
        }
    }

    private CommandLine.Model.OptionSpec.Builder createArgBuilder(CommandArgumentDefinition<?> def, String argName) {
        return (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)argName, (String[])new String[0]).required(false)).converters(new CommandLine.ITypeConverter[]{value -> {
            if (def.getDataType().equals(Boolean.class) && value.equals("")) {
                return "true";
            }
            return value;
        }})).type(String.class);
    }

    private List<String[]> expandCommandNames(CommandDefinition commandDefinition) {
        ArrayList<String[]> returnList = new ArrayList<String[]>();
        String[] standardName = (String[])commandDefinition.getName().clone();
        for (int i2 = 0; i2 < standardName.length; ++i2) {
            standardName[i2] = StringUtil.toKabobCase(commandDefinition.getName()[i2]);
        }
        returnList.add(standardName);
        if (!StringUtil.join(standardName, " ").equals(StringUtil.join(commandDefinition.getName(), " "))) {
            returnList.add(commandDefinition.getName());
        }
        return returnList;
    }

    private CommandLine.Model.CommandSpec getParentCommandSpec(CommandDefinition commandDefinition, CommandLine rootCommand) {
        String[] commandName = commandDefinition.getName();
        CommandLine.Model.CommandSpec parent = rootCommand.getCommandSpec();
        for (int i2 = 0; i2 < commandName.length - 1; ++i2) {
            CommandLine commandGroup = (CommandLine)parent.subcommands().get(commandName[i2]);
            String[] groupName = Arrays.copyOfRange(commandName, 0, i2 + 1);
            parent = commandGroup == null ? this.addSubcommandGroup(groupName, commandDefinition, parent) : commandGroup.getCommandSpec();
            this.configureSubcommandGroup(parent, groupName, commandDefinition);
        }
        return parent;
    }

    private void configureSubcommandGroup(CommandLine.Model.CommandSpec groupSpec, String[] groupName, CommandDefinition commandDefinition) {
        String header = StringUtil.trimToEmpty(commandDefinition.getGroupShortDescription(groupName));
        String description = StringUtil.trimToEmpty(commandDefinition.getGroupLongDescription(groupName));
        if (!header.equals("")) {
            groupSpec.usageMessage().header(new String[]{"< " + header + " >\n"});
        }
        if (!description.equals("")) {
            groupSpec.usageMessage().description(new String[]{description + "\n"});
        }
    }

    private CommandLine.Model.CommandSpec addSubcommandGroup(String[] groupName, CommandDefinition commandDefinition, CommandLine.Model.CommandSpec parent) {
        CommandLine.Model.CommandSpec groupSpec = CommandLine.Model.CommandSpec.wrapWithoutInspection(null, (CommandLine.IFactory)this.defaultFactory);
        this.configureHelp(groupSpec, false);
        groupSpec.optionsCaseInsensitive(true);
        groupSpec.subcommandsCaseInsensitive(true);
        parent.addSubcommand(groupName[groupName.length - 1], groupSpec);
        return groupSpec;
    }

    private String toEnvVariable(String property) {
        return StringUtil.toKabobCase(property).replace(".", "_").replace("-", "_").toUpperCase();
    }

    private SortedSet<CommandDefinition> getCommands() {
        CommandFactory commandFactory = Scope.getCurrentScope().getSingleton(CommandFactory.class);
        return commandFactory.getCommands(false);
    }

    private void addGlobalArguments(CommandLine commandLine) {
        CommandLine.Model.CommandSpec rootCommandSpec = commandLine.getCommandSpec();
        SortedSet<ConfigurationDefinition<?>> globalConfigurations = Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class).getRegisteredDefinitions(false);
        for (ConfigurationDefinition configurationDefinition : globalConfigurations) {
            String[] argNames = LiquibaseCommandLine.toArgNames(configurationDefinition);
            for (int i2 = 0; i2 < argNames.length; ++i2) {
                CommandLine.Model.OptionSpec.Builder optionBuilder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)argNames[i2], (String[])new String[0]).required(false)).type(String.class);
                String description = "(" + configurationDefinition.getKey() + ")\n(" + this.toEnvVariable(configurationDefinition.getKey()) + ")";
                if (configurationDefinition.getDefaultValue() != null) {
                    description = configurationDefinition.getDefaultValueDescription() == null ? "DEFAULT: " + configurationDefinition.getDefaultValue() + "\n" + description : "DEFAULT: " + configurationDefinition.getDefaultValueDescription() + "\n" + description;
                }
                if (configurationDefinition.getDescription() != null) {
                    description = configurationDefinition.getDescription() + "\n" + description;
                }
                if (i2 == 0) {
                    String primaryArg = argNames[i2];
                    String camelCaseArg = StringUtil.toCamelCase(primaryArg.substring(2));
                    if (!primaryArg.equals("--" + camelCaseArg)) {
                        description = "\n" + description + "\n[deprecated: --" + camelCaseArg + "]";
                    }
                }
                optionBuilder.description(new String[]{description + "\n"});
                if (configurationDefinition.getDataType().equals(Boolean.class)) {
                    optionBuilder.arity("1");
                }
                if (i2 > 0) {
                    optionBuilder.hidden(true);
                }
                CommandLine.Model.OptionSpec optionSpec = optionBuilder.build();
                rootCommandSpec.addOption(optionSpec);
            }
        }
        for (String string : this.legacyNoLongerGlobalArguments) {
            CommandLine.Model.OptionSpec.Builder optionBuilder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)("--" + string), (String[])new String[0]).required(false)).type(String.class)).hidden(true)).description(new String[]{"Legacy global argument"});
            rootCommandSpec.addOption(optionBuilder.build());
            String kabobArg = StringUtil.toKabobCase(string);
            if (kabobArg.equals(string)) continue;
            CommandLine.Model.OptionSpec.Builder kabobOptionBuilder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)("--" + kabobArg), (String[])new String[0]).required(false)).type(String.class)).hidden(true)).description(new String[]{"Legacy global argument"});
            rootCommandSpec.addOption(kabobOptionBuilder.build());
        }
    }

    private void configureHelp(CommandLine.Model.CommandSpec commandSpec, boolean includeVersion) {
        String footer = "Each argument contains the corresponding 'configuration key' in parentheses. As an alternative to passing values on the command line, these keys can be used as a basis for configuration settings in other locations.\n\nAvailable configuration locations, in order of priority:\n- Command line arguments (argument name in --help)\n- Java system properties (configuration key listed above)\n- Environment values (env variable listed above)\n- Defaults file (configuration key OR argument name)\n\nFull documentation is available at\nhttp://www.liquibase.org";
        commandSpec.addOption(((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)"--help", (String[])new String[]{"-h"}).description(new String[]{"Show this help message and exit"})).usageHelp(true).build());
        if (includeVersion) {
            commandSpec.addOption(((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)"--version", (String[])new String[]{"-v"}).description(new String[]{"Print version information and exit"})).versionHelp(true).build());
        }
        commandSpec.usageMessage().showDefaultValues(false).sortOptions(true).abbreviateSynopsis(true).footer(new String[]{"\n" + footer});
    }

    protected static String[] toArgNames(CommandArgumentDefinition<?> def) {
        LinkedHashSet<String> returnList = new LinkedHashSet<String>();
        returnList.add("--" + StringUtil.toKabobCase(def.getName()).replace(".", "-"));
        returnList.add("--" + def.getName().replaceAll("\\.", ""));
        return returnList.toArray(new String[0]);
    }

    protected static String[] toArgNames(ConfigurationDefinition<?> def) {
        LinkedHashSet<String> returnList = new LinkedHashSet<String>();
        returnList.add("--" + StringUtil.toKabobCase(def.getKey().replaceFirst("^liquibase.", "")).replace(".", "-"));
        returnList.add("--" + StringUtil.toKabobCase(def.getKey()).replace(".", "-"));
        returnList.add("--" + def.getKey().replaceFirst("^liquibase.", "").replaceAll("\\.", ""));
        return returnList.toArray(new String[0]);
    }

    public static class SecureLogFilter
    implements Filter {
        private LogMessageFilter filter;

        public SecureLogFilter(LogMessageFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            String filteredMessage = this.filter.filterMessage(record.getMessage());
            boolean equals = filteredMessage.equals(record.getMessage());
            return equals;
        }
    }
}

