/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import javax.lang.model.element.Element;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.ObjectFactoryMethodResolver;
import org.mapstruct.ap.internal.model.assignment.ExistingInstanceSetterWrapperForCollectionsAndMaps;
import org.mapstruct.ap.internal.model.assignment.GetterWrapperForCollectionsAndMaps;
import org.mapstruct.ap.internal.model.assignment.SetterWrapperForCollectionsAndMaps;
import org.mapstruct.ap.internal.model.assignment.SetterWrapperForCollectionsAndMapsWithNullCheck;
import org.mapstruct.ap.internal.model.assignment.UpdateWrapper;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.prism.CollectionMappingStrategyPrism;
import org.mapstruct.ap.internal.prism.NullValueCheckStrategyPrism;
import org.mapstruct.ap.internal.prism.NullValuePropertyMappingStrategyPrism;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.accessor.AccessorType;

public class CollectionAssignmentBuilder {
    private MappingBuilderContext ctx;
    private Method method;
    private Accessor targetReadAccessor;
    private Type targetType;
    private String targetPropertyName;
    private AccessorType targetAccessorType;
    private Assignment assignment;
    private SourceRHS sourceRHS;
    private NullValueCheckStrategyPrism nvcs;
    private NullValuePropertyMappingStrategyPrism nvpms;

    public CollectionAssignmentBuilder mappingBuilderContext(MappingBuilderContext ctx) {
        this.ctx = ctx;
        return this;
    }

    public CollectionAssignmentBuilder method(Method method) {
        this.method = method;
        return this;
    }

    public CollectionAssignmentBuilder targetReadAccessor(Accessor targetReadAccessor) {
        this.targetReadAccessor = targetReadAccessor;
        return this;
    }

    public CollectionAssignmentBuilder targetType(Type targetType) {
        this.targetType = targetType;
        return this;
    }

    public CollectionAssignmentBuilder targetPropertyName(String targetPropertyName) {
        this.targetPropertyName = targetPropertyName;
        return this;
    }

    public CollectionAssignmentBuilder targetAccessorType(AccessorType targetAccessorType) {
        this.targetAccessorType = targetAccessorType;
        return this;
    }

    public CollectionAssignmentBuilder assignment(Assignment assignment) {
        this.assignment = assignment;
        return this;
    }

    public CollectionAssignmentBuilder rightHandSide(SourceRHS sourceRHS) {
        this.sourceRHS = sourceRHS;
        return this;
    }

    public CollectionAssignmentBuilder nullValueCheckStrategy(NullValueCheckStrategyPrism nvcs) {
        this.nvcs = nvcs;
        return this;
    }

    public CollectionAssignmentBuilder nullValuePropertyMappingStrategy(NullValuePropertyMappingStrategyPrism nvpms) {
        this.nvpms = nvpms;
        return this;
    }

    public Assignment build() {
        boolean targetImmutable;
        Assignment result = this.assignment;
        CollectionMappingStrategyPrism cms = this.method.getMapperConfiguration().getCollectionMappingStrategy();
        boolean bl = targetImmutable = cms == CollectionMappingStrategyPrism.TARGET_IMMUTABLE || this.targetReadAccessor == null;
        if (this.targetAccessorType == AccessorType.SETTER || this.targetAccessorType == AccessorType.FIELD) {
            if (result.isCallingUpdateMethod() && !targetImmutable) {
                if (this.targetReadAccessor == null) {
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_NO_READ_ACCESSOR_FOR_TARGET_TYPE, this.targetPropertyName);
                }
                MethodReference factoryMethod = ObjectFactoryMethodResolver.getFactoryMethod(this.method, this.targetType, SelectionParameters.forSourceRHS(this.sourceRHS), this.ctx);
                result = new UpdateWrapper(result, this.method.getThrownTypes(), factoryMethod, this.targetAccessorType == AccessorType.FIELD, this.targetType, true, this.nvpms == NullValuePropertyMappingStrategyPrism.SET_TO_NULL && !this.targetType.isPrimitive(), this.nvpms == NullValuePropertyMappingStrategyPrism.SET_TO_DEFAULT);
            } else {
                result = this.method.isUpdateMethod() && !targetImmutable ? new ExistingInstanceSetterWrapperForCollectionsAndMaps(result, this.method.getThrownTypes(), this.targetType, this.nvcs, this.nvpms, this.ctx.getTypeFactory(), this.targetAccessorType == AccessorType.FIELD) : (result.getType() == Assignment.AssignmentType.DIRECT || this.nvcs == NullValueCheckStrategyPrism.ALWAYS ? new SetterWrapperForCollectionsAndMapsWithNullCheck(result, this.method.getThrownTypes(), this.targetType, this.ctx.getTypeFactory(), this.targetAccessorType == AccessorType.FIELD) : new SetterWrapperForCollectionsAndMaps(result, this.method.getThrownTypes(), this.targetType, this.targetAccessorType == AccessorType.FIELD));
            }
        } else {
            if (targetImmutable) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_NO_WRITE_ACCESSOR_FOR_TARGET_TYPE, this.targetPropertyName);
            }
            result = new GetterWrapperForCollectionsAndMaps(result, this.method.getThrownTypes(), this.targetType, this.targetAccessorType == AccessorType.FIELD);
        }
        return result;
    }
}

