/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.TypeUtils;

public class SubclassValidator {
    private final FormattingMessager messager;
    private final List<TypeMirror> handledSubclasses = new ArrayList<TypeMirror>();
    private final TypeUtils typeUtils;

    public SubclassValidator(FormattingMessager messager, TypeUtils typeUtils) {
        this.messager = messager;
        this.typeUtils = typeUtils;
    }

    public boolean isValidUsage(Element e, AnnotationMirror annotation, TypeMirror sourceType) {
        for (TypeMirror typeMirror : this.handledSubclasses) {
            if (this.typeUtils.isSameType(sourceType, typeMirror)) {
                this.messager.printMessage(e, annotation, Message.SUBCLASSMAPPING_DOUBLE_SOURCE_SUBCLASS, sourceType);
                return false;
            }
            if (!this.typeUtils.isAssignable(sourceType, typeMirror)) continue;
            this.messager.printMessage(e, annotation, Message.SUBCLASSMAPPING_ILLOGICAL_ORDER, sourceType, typeMirror, sourceType, typeMirror);
            return false;
        }
        this.handledSubclasses.add(sourceType);
        return true;
    }
}

