/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.gem;

import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.Gem;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.GemValue;

public class DeprecatedGem
implements Gem {
    private final GemValue<String> since;
    private final GemValue<Boolean> forRemoval;
    private final boolean isValid;
    private final AnnotationMirror mirror;

    private DeprecatedGem(BuilderImpl builder) {
        this.since = builder.since;
        this.forRemoval = builder.forRemoval;
        this.isValid = this.since != null && this.since.isValid() && this.forRemoval != null && this.forRemoval.isValid();
        this.mirror = builder.mirror;
    }

    public GemValue<String> since() {
        return this.since;
    }

    public GemValue<Boolean> forRemoval() {
        return this.forRemoval;
    }

    @Override
    public AnnotationMirror mirror() {
        return this.mirror;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public static DeprecatedGem instanceOn(Element element) {
        return DeprecatedGem.build(element, new BuilderImpl());
    }

    public static DeprecatedGem instanceOn(AnnotationMirror mirror) {
        return DeprecatedGem.build(mirror, new BuilderImpl());
    }

    public static <T> T build(Element element, Builder<T> builder) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream().filter(a -> "java.lang.Deprecated".contentEquals(((TypeElement)a.getAnnotationType().asElement()).getQualifiedName())).findAny().orElse(null);
        return DeprecatedGem.build(mirror, builder);
    }

    public static <T> T build(AnnotationMirror mirror, Builder<T> builder) {
        if (mirror == null || builder == null) {
            return null;
        }
        List<ExecutableElement> enclosed = ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements());
        HashMap defaultValues = new HashMap(enclosed.size());
        enclosed.forEach(e -> defaultValues.put(e.getSimpleName().toString(), e.getDefaultValue()));
        HashMap values = new HashMap(enclosed.size());
        mirror.getElementValues().entrySet().forEach(e -> values.put(((ExecutableElement)e.getKey()).getSimpleName().toString(), (AnnotationValue)e.getValue()));
        for (String methodName : defaultValues.keySet()) {
            if ("since".equals(methodName)) {
                builder.setSince(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), String.class));
                continue;
            }
            if (!"forRemoval".equals(methodName)) continue;
            builder.setForremoval(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), Boolean.class));
        }
        builder.setMirror(mirror);
        return builder.build();
    }

    private static class BuilderImpl
    implements Builder<DeprecatedGem> {
        private GemValue<String> since;
        private GemValue<Boolean> forRemoval;
        private AnnotationMirror mirror;

        private BuilderImpl() {
        }

        @Override
        public Builder setSince(GemValue<String> since) {
            this.since = since;
            return this;
        }

        @Override
        public Builder setForremoval(GemValue<Boolean> forRemoval) {
            this.forRemoval = forRemoval;
            return this;
        }

        @Override
        public Builder setMirror(AnnotationMirror mirror) {
            this.mirror = mirror;
            return this;
        }

        @Override
        public DeprecatedGem build() {
            return new DeprecatedGem(this);
        }
    }

    public static interface Builder<T> {
        public Builder setSince(GemValue<String> var1);

        public Builder setForremoval(GemValue<Boolean> var1);

        public Builder setMirror(AnnotationMirror var1);

        public T build();
    }
}

