/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.annotation;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Type;

public class AnnotationElement
extends ModelElement {
    private final String elementName;
    private final List<? extends Object> values;
    private final AnnotationElementType type;

    public AnnotationElement(AnnotationElementType type, List<? extends Object> values) {
        this(type, null, values);
    }

    public AnnotationElement(AnnotationElementType type, String elementName, List<? extends Object> values) {
        this.type = type;
        this.elementName = elementName;
        this.values = values;
    }

    public String getElementName() {
        return this.elementName;
    }

    public List<? extends Object> getValues() {
        return this.values;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> importTypes = null;
        for (Object object : this.values) {
            if (!(object instanceof ModelElement)) continue;
            if (importTypes == null) {
                importTypes = new HashSet<Type>();
            }
            importTypes.addAll(((ModelElement)object).getImportTypes());
        }
        return importTypes == null ? Collections.emptySet() : importTypes;
    }

    public boolean isBoolean() {
        return this.type == AnnotationElementType.BOOLEAN;
    }

    public boolean isByte() {
        return this.type == AnnotationElementType.BYTE;
    }

    public boolean isCharacter() {
        return this.type == AnnotationElementType.CHARACTER;
    }

    public boolean isClass() {
        return this.type == AnnotationElementType.CLASS;
    }

    public boolean isDouble() {
        return this.type == AnnotationElementType.DOUBLE;
    }

    public boolean isEnum() {
        return this.type == AnnotationElementType.ENUM;
    }

    public boolean isFloat() {
        return this.type == AnnotationElementType.FLOAT;
    }

    public boolean isInteger() {
        return this.type == AnnotationElementType.INTEGER;
    }

    public boolean isLong() {
        return this.type == AnnotationElementType.LONG;
    }

    public boolean isShort() {
        return this.type == AnnotationElementType.SHORT;
    }

    public boolean isString() {
        return this.type == AnnotationElementType.STRING;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.elementName, this.type, this.values});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationElement other = (AnnotationElement)obj;
        return Objects.equals(this.elementName, other.elementName) && this.type == other.type && Objects.equals(this.values, other.values);
    }

    public static enum AnnotationElementType {
        BOOLEAN,
        BYTE,
        CHARACTER,
        CLASS,
        DOUBLE,
        ENUM,
        FLOAT,
        INTEGER,
        LONG,
        SHORT,
        STRING;

    }
}

