/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.beanmapping;

import java.util.Arrays;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.accessor.PresenceCheckAccessor;
import org.mapstruct.ap.internal.util.accessor.ReadAccessor;

public class PropertyEntry {
    private final String[] fullName;
    private final ReadAccessor readAccessor;
    private final PresenceCheckAccessor presenceChecker;
    private final Type type;

    private PropertyEntry(String[] fullName, ReadAccessor readAccessor, PresenceCheckAccessor presenceChecker, Type type) {
        this.fullName = fullName;
        this.readAccessor = readAccessor;
        this.presenceChecker = presenceChecker;
        this.type = type;
    }

    public static PropertyEntry forSourceReference(String[] name, ReadAccessor readAccessor, PresenceCheckAccessor presenceChecker, Type type) {
        return new PropertyEntry(name, readAccessor, presenceChecker, type);
    }

    public String getName() {
        return this.fullName[this.fullName.length - 1];
    }

    public ReadAccessor getReadAccessor() {
        return this.readAccessor;
    }

    public PresenceCheckAccessor getPresenceChecker() {
        return this.presenceChecker;
    }

    public Type getType() {
        return this.type;
    }

    public String getFullName() {
        return Strings.join(Arrays.asList(this.fullName), ".");
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Arrays.deepHashCode(this.fullName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyEntry other = (PropertyEntry)obj;
        return Arrays.deepEquals(this.fullName, other.fullName);
    }

    public String toString() {
        return this.type + " " + Strings.join(Arrays.asList(this.fullName), ".");
    }
}

