/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public class GemValue<T> {
    private final T value;
    private final T defaultValue;
    private final AnnotationValue annotationValue;

    public static <V> GemValue<V> create(AnnotationValue annotationValue, AnnotationValue annotationDefaultValue, Class<V> valueClass) {
        ValueAnnotationValueVisitor visitor = new ValueAnnotationValueVisitor(Function.identity());
        Object value = GemValue.visit(annotationValue, visitor, valueClass);
        Object defaultValue = GemValue.visit(annotationDefaultValue, visitor, valueClass);
        return new GemValue(value, defaultValue, annotationValue);
    }

    public static <V> GemValue<List<V>> createArray(AnnotationValue annotationValue, AnnotationValue annotationDefaultValue, Class<V> valueClass) {
        ValueAnnotationValueListVisitor visitor = new ValueAnnotationValueListVisitor(Function.identity());
        List value = GemValue.visitList(annotationValue, visitor, valueClass);
        List defaultValue = GemValue.visitList(annotationDefaultValue, visitor, valueClass);
        return new GemValue<List<V>>(value, defaultValue, annotationValue);
    }

    public static GemValue<String> createEnum(AnnotationValue annotationValue, AnnotationValue annotationDefaultValue) {
        ValueAnnotationValueVisitor visitor = new ValueAnnotationValueVisitor(variableElement -> variableElement.getSimpleName().toString());
        String value = (String)GemValue.visit(annotationValue, visitor, VariableElement.class);
        String defaultValue = (String)GemValue.visit(annotationDefaultValue, visitor, VariableElement.class);
        return new GemValue<String>(value, defaultValue, annotationValue);
    }

    public static GemValue<List<String>> createEnumArray(AnnotationValue annotationValue, AnnotationValue annotationDefaultValue) {
        ValueAnnotationValueListVisitor visitor = new ValueAnnotationValueListVisitor(variableElement -> variableElement.getSimpleName().toString());
        List value = GemValue.visitList(annotationValue, visitor, VariableElement.class);
        List defaultValue = GemValue.visitList(annotationDefaultValue, visitor, VariableElement.class);
        return new GemValue<List<String>>(value, defaultValue, annotationValue);
    }

    public static <V> GemValue<V> create(AnnotationValue annotationValue, AnnotationValue annotationDefaultValue, Function<AnnotationMirror, V> creator) {
        ValueAnnotationValueVisitor visitor = new ValueAnnotationValueVisitor(creator);
        Object value = GemValue.visit(annotationValue, visitor, AnnotationMirror.class);
        Object defaultValue = GemValue.visit(annotationDefaultValue, visitor, AnnotationMirror.class);
        return new GemValue(value, defaultValue, annotationValue);
    }

    public static <V> GemValue<List<V>> createArray(AnnotationValue annotationValue, AnnotationValue annotationDefaultValue, Function<AnnotationMirror, V> creator) {
        ValueAnnotationValueListVisitor visitor = new ValueAnnotationValueListVisitor(creator);
        List value = GemValue.visitList(annotationValue, visitor, AnnotationMirror.class);
        List defaultValue = GemValue.visitList(annotationDefaultValue, visitor, AnnotationMirror.class);
        return new GemValue<List<V>>(value, defaultValue, annotationValue);
    }

    private static <V, R> R visit(AnnotationValue annotationValue, AnnotationValueVisitor<R, Class<V>> visitor, Class<V> vClass) {
        return annotationValue == null ? null : (R)annotationValue.accept(visitor, vClass);
    }

    private static <V, R> List<R> visitList(AnnotationValue annotationValue, AnnotationValueVisitor<List<R>, Class<V>> visitor, Class<V> vClass) {
        return annotationValue == null ? null : annotationValue.accept(visitor, vClass);
    }

    private GemValue(T value, T defaultValue, AnnotationValue annotationValue) {
        this.value = value;
        this.defaultValue = defaultValue;
        this.annotationValue = annotationValue;
    }

    public T get() {
        return this.value != null ? this.value : this.defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public AnnotationValue getAnnotationValue() {
        return this.annotationValue;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean isValid() {
        return this.value != null || this.defaultValue != null;
    }

    private static class ValueAnnotationValueListVisitor<V, R>
    extends SimpleAnnotationValueVisitor8<List<R>, Class<V>> {
        private final ValueAnnotationValueVisitor<V, R> arrayVisitor;

        private ValueAnnotationValueListVisitor(Function<V, R> valueMapper) {
            this.arrayVisitor = new ValueAnnotationValueVisitor(valueMapper);
        }

        @Override
        public List<R> visitArray(List<? extends AnnotationValue> vals, Class<V> vClass) {
            boolean valid = true;
            ArrayList<V> values = new ArrayList<V>(vals.size());
            for (AnnotationValue annotationValue : vals) {
                V value = annotationValue.accept(this.arrayVisitor, vClass);
                values.add(value);
            }
            return values;
        }
    }

    private static class ValueAnnotationValueVisitor<V, R>
    extends SimpleAnnotationValueVisitor8<R, Class<V>> {
        private final Function<V, R> valueMapper;

        private ValueAnnotationValueVisitor(Function<V, R> valueMapper) {
            this.valueMapper = valueMapper;
        }

        @Override
        protected R defaultAction(Object o, Class<V> vClass) {
            if (o == null) {
                return null;
            }
            if (vClass.isInstance(o)) {
                return this.valueMapper.apply(vClass.cast(o));
            }
            return null;
        }
    }
}

