/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.mariadb.jdbc.AbstractMariaDbPrepareStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbParameterMetaData;
import org.mariadb.jdbc.MariaDbResultSetMetaData;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiIntExecutionResult;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbServerPreparedStatement
extends AbstractMariaDbPrepareStatement
implements Cloneable {
    String sql;
    PrepareResult prepareResult;
    boolean returnTableAlias = false;
    int parameterCount;
    MariaDbResultSetMetaData metadata;
    MariaDbParameterMetaData parameterMetaData;
    ParameterHolder[] currentParameterHolder;
    List<ParameterHolder[]> queryParameters = new ArrayList<ParameterHolder[]>();

    public MariaDbServerPreparedStatement(MariaDbConnection connection, String sql, int resultSetScrollType) throws SQLException {
        super(connection, resultSetScrollType);
        this.useFractionalSeconds = connection.getProtocol().getOptions().useFractionalSeconds;
        this.sql = sql;
        this.prepare(sql);
    }

    @Override
    public MariaDbServerPreparedStatement clone() throws CloneNotSupportedException {
        MariaDbServerPreparedStatement clone = (MariaDbServerPreparedStatement)super.clone();
        clone.metadata = this.metadata;
        clone.parameterMetaData = this.parameterMetaData;
        clone.currentParameterHolder = new ParameterHolder[this.parameterCount];
        clone.queryParameters = new ArrayList<ParameterHolder[]>();
        try {
            clone.prepare(this.sql);
        }
        catch (SQLException e) {
            throw new CloneNotSupportedException("PrepareStatement not ");
        }
        return clone;
    }

    private void prepare(String sql) throws SQLException {
        try {
            this.prepareResult = this.protocol.prepare(sql);
            this.parameterCount = this.prepareResult.getParameters().length;
            this.currentParameterHolder = new ParameterHolder[this.prepareResult.getParameters().length];
            this.returnTableAlias = this.protocol.getOptions().useOldAliasMetadataBehavior;
            this.metadata = new MariaDbResultSetMetaData(this.prepareResult.getColumns(), this.protocol.getDataTypeMappingFlags(), this.returnTableAlias);
            this.parameterMetaData = new MariaDbParameterMetaData(this.prepareResult.getParameters());
        }
        catch (QueryException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ExceptionMapper.throwException(e, this.connection, this);
        }
    }

    @Override
    protected boolean isNoBackslashEscapes() {
        return this.connection.noBackslashEscapes;
    }

    @Override
    protected boolean useFractionalSeconds() {
        return this.useFractionalSeconds;
    }

    @Override
    protected Calendar cal() {
        return this.protocol.getCalendar();
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        try {
            this.currentParameterHolder[parameterIndex - 1] = holder;
        }
        catch (ArrayIndexOutOfBoundsException a) {
            throw ExceptionMapper.getSqlException("Could not set parameter at position " + parameterIndex + ", parameter length is " + this.parameterCount);
        }
    }

    protected ParameterHolder getCurrentParameterHolder(int parameterIndex) {
        return this.currentParameterHolder[parameterIndex];
    }

    @Override
    public void addBatch() throws SQLException {
        this.validParameters();
        this.queryParameters.add((ParameterHolder[])this.currentParameterHolder.clone());
    }

    protected void setCurrentParameterHolder(ParameterHolder[] currentParameterHolder) throws SQLException {
        this.currentParameterHolder = currentParameterHolder;
    }

    @Override
    public void clearBatch() {
        this.queryParameters.clear();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.parameterMetaData;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClose();
        this.batchResultSet = null;
        if (this.queryParameters.size() == 0) {
            return new int[0];
        }
        MariaDbType[] parameterTypeHeader = new MariaDbType[this.parameterCount];
        this.lock.lock();
        this.executing = true;
        QueryException exception = null;
        MultiIntExecutionResult internalExecutionResult = null;
        try {
            this.executeQueryProlog(this.prepareResult);
            try {
                int queryParameterSize = this.queryParameters.size();
                internalExecutionResult = new MultiIntExecutionResult((Statement)this, queryParameterSize, 0, false);
                for (int counter = 0; counter < queryParameterSize; ++counter) {
                    try {
                        this.protocol.executePreparedQuery(this.prepareResult, internalExecutionResult, this.sql, this.queryParameters.get(counter), parameterTypeHeader, this.resultSetScrollType);
                        this.cacheMoreResults(internalExecutionResult, 0, false);
                        continue;
                    }
                    catch (QueryException queryException) {
                        if (this.protocol.getOptions().continueBatchOnError) {
                            if (exception != null) continue;
                            exception = queryException;
                            continue;
                        }
                        throw queryException;
                    }
                }
                this.executionResult = internalExecutionResult;
            }
            catch (QueryException queryException) {
                exception = queryException;
            }
            finally {
                this.executeQueryEpilog(exception);
                this.executing = false;
            }
            int[] queryException = internalExecutionResult.getAffectedRows();
            return queryException;
        }
        catch (SQLException sqle) {
            this.clearBatch();
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), internalExecutionResult.getAffectedRows(), (Throwable)sqle);
        }
        finally {
            this.lock.unlock();
            this.clearBatch();
        }
    }

    private void executeQueryProlog(PrepareResult prepareResult) throws SQLException {
        if (this.closed) {
            throw new SQLException("execute() is called on closed statement");
        }
        this.protocol.prologProxy(prepareResult, this.executionResult, this.maxRows, this.protocol.getProxy() != null, this.connection, this);
        if (this.queryTimeout != 0) {
            this.setTimerTask();
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.execute()) {
            return this.executionResult.getResult();
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        return this.getUpdateCount();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.currentParameterHolder = new ParameterHolder[this.parameterCount];
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeInternal(this.getFetchSize(), false);
    }

    protected void validParameters() throws SQLException {
        for (int i = 0; i < this.parameterCount; ++i) {
            if (this.currentParameterHolder[i] != null) continue;
            ExceptionMapper.throwException(new QueryException("Parameter at position " + (i + 1) + " is not set", -1, "07004"), this.connection, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeInternal(int fetchSize, boolean canHaveCallableResultset) throws SQLException {
        this.validParameters();
        this.lock.lock();
        try {
            boolean bl;
            this.executing = true;
            QueryException exception = null;
            this.executeQueryProlog(this.prepareResult);
            try {
                this.batchResultSet = null;
                SingleExecutionResult internalExecutionResult = new SingleExecutionResult(this, fetchSize, true, canHaveCallableResultset);
                this.protocol.executePreparedQuery(this.prepareResult, internalExecutionResult, this.sql, this.currentParameterHolder, new MariaDbType[this.parameterCount], this.resultSetScrollType);
                this.cacheMoreResults(internalExecutionResult, fetchSize, canHaveCallableResultset);
                this.executionResult = internalExecutionResult;
                bl = this.executionResult.getResult() != null;
            }
            catch (QueryException e) {
                boolean bl2;
                try {
                    exception = e;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    try {
                        this.executeQueryEpilog(exception);
                        this.executing = false;
                        throw throwable;
                    }
                    catch (SQLException sqle) {
                        throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), new int[]{0}, (Throwable)sqle);
                    }
                }
                this.executeQueryEpilog(exception);
                this.executing = false;
                this.lock.unlock();
                this.clearBatch();
                return bl2;
            }
            this.executeQueryEpilog(exception);
            this.executing = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            this.clearBatch();
        }
    }

    @Override
    public void close() throws SQLException {
        this.lock.lock();
        try {
            this.closed = true;
            if (this.protocol != null && this.protocol.isConnected()) {
                try {
                    this.prepareResult.getUnProxiedProtocol().releasePrepareStatement(this.prepareResult, this.sql);
                }
                catch (QueryException queryException) {
                    // empty catch block
                }
            }
            this.prepareResult = null;
            this.protocol = null;
            if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
                return;
            }
            this.connection.pooledConnection.fireStatementClosed(this);
            this.connection = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected int getParameterCount() {
        return this.parameterCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("sql : '" + this.sql + "'");
        if (this.parameterCount > 0) {
            sb.append(", parameters : [");
            for (int i = 0; i < this.parameterCount; ++i) {
                if (this.currentParameterHolder[i] == null) {
                    sb.append("null");
                } else {
                    sb.append(this.currentParameterHolder[i].toString());
                }
                if (i == this.parameterCount - 1) continue;
                sb.append(",");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    protected ExecutionResult getExecutionResult() {
        return this.executionResult;
    }
}

