/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.zip.DeflaterOutputStream;
import org.mariadb.jdbc.internal.stream.MaxAllowedPacketException;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class PacketOutputStream
extends OutputStream {
    private static final int MIN_COMPRESSION_SIZE = 16384;
    private static final float MIN_COMPRESSION_RATIO = 0.9f;
    private static final int MAX_PACKET_LENGTH = 0xFFFFFF;
    private static final int HEADER_LENGTH = 4;
    private static final int BUFFER_DEFAULT_SIZE = 4096;
    private static final float NORMAL_INCREASE = 4.0f;
    private static final float BIG_SIZE_INCREASE = 1.5f;
    public ByteBuffer buffer;
    public ByteBuffer firstBuffer;
    int seqNo;
    int compressSeqNo;
    int lastSeq;
    int maxAllowedPacket = 0xFFFFFF;
    int maxPacketSize = 0xFFFFFF;
    boolean checkPacketLength;
    int maxRewritableLengthAllowed;
    boolean useCompression;
    public OutputStream outputStream;
    private volatile boolean closed = false;

    public PacketOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.buffer = this.firstBuffer = ByteBuffer.allocate(4096).order(ByteOrder.LITTLE_ENDIAN);
        this.useCompression = false;
        this.buffer.position(4);
    }

    protected void increase(int newCapacity) {
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity).order(ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(this.buffer.array(), 0, newBuffer.array(), 0, this.buffer.position());
        newBuffer.position(this.buffer.position());
        this.buffer = newBuffer;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public void startPacket(int seqNo, boolean checkPacketLength) throws IOException {
        if (this.closed) {
            throw new IOException("Stream has already closed");
        }
        this.seqNo = seqNo;
        this.compressSeqNo = seqNo;
        this.checkPacketLength = checkPacketLength;
        this.buffer.clear();
        this.buffer.position(4);
    }

    public void startPacket(int seqNo) throws IOException {
        this.startPacket(seqNo, true);
    }

    public void writeEmptyPacket(int seqNo) throws IOException {
        if (!this.useCompression) {
            byte[] header = new byte[]{0, 0, 0, (byte)seqNo};
            this.outputStream.write(header, 0, 4);
        } else {
            byte[] header = new byte[]{4, 0, 0, (byte)this.compressSeqNo, 0, 0, 0};
            this.outputStream.write(header, 0, 7);
            header = new byte[]{0, 0, 0, (byte)seqNo};
            this.outputStream.write(header, 0, 4);
        }
        this.outputStream.flush();
    }

    public void sendFile(InputStream is, int seq) throws IOException {
        this.seqNo = seq;
        this.compressSeqNo = 2;
        if (!this.useCompression) {
            int len;
            this.buffer.clear();
            this.buffer.position(4);
            this.checkPacketLength = false;
            byte[] buffer = new byte[4096];
            while ((len = is.read(buffer)) > 0) {
                this.write(buffer, 0, len);
            }
            this.finishPacket();
            this.writeEmptyPacket(this.seqNo++);
        } else {
            int len;
            this.buffer.clear();
            this.buffer.position(4);
            this.checkPacketLength = false;
            byte[] readFileBuffer = new byte[4096];
            while ((len = is.read(readFileBuffer)) > 0) {
                this.write(readFileBuffer, 0, len);
            }
            if (this.buffer.position() > 4) {
                this.checkPacketMaxSize(this.buffer.position());
                this.buffer.flip();
                int limit = this.buffer.limit();
                this.buffer.position(4);
                int position = 0;
                int expectedPacketSize = limit + 4 * (limit / this.maxPacketSize + 1);
                byte[] bufferBytes = new byte[expectedPacketSize];
                while (position < expectedPacketSize - 4) {
                    int length = this.buffer.remaining();
                    if (length > this.maxPacketSize) {
                        length = this.maxPacketSize;
                    }
                    bufferBytes[position++] = (byte)(length & 0xFF);
                    bufferBytes[position++] = (byte)(length >>> 8);
                    bufferBytes[position++] = (byte)(length >>> 16);
                    bufferBytes[position++] = (byte)this.seqNo++;
                    if (length <= 0) continue;
                    this.buffer.get(bufferBytes, position, length);
                    position += length;
                }
                bufferBytes[position++] = 0;
                bufferBytes[position++] = 0;
                bufferBytes[position++] = 0;
                bufferBytes[position++] = (byte)this.seqNo++;
                this.compressedAndSend(position, bufferBytes);
            } else {
                this.writeEmptyPacket(this.seqNo);
            }
            if (this.buffer.capacity() > 4096) {
                this.buffer = this.firstBuffer;
            }
            this.buffer.clear();
            this.buffer.position(4);
        }
    }

    public void sendStream(InputStream is) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = is.read(buffer)) > 0) {
            this.write(buffer, 0, len);
        }
    }

    public void sendStream(InputStream is, long readLength) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        for (long remainingReadLength = readLength; remainingReadLength > 0L; remainingReadLength -= (long)read) {
            read = is.read(buffer, 0, Math.min((int)remainingReadLength, 4096));
            if (read == -1) {
                return;
            }
            this.write(buffer, 0, read);
        }
    }

    public void sendStream(Reader reader) throws IOException {
        int len;
        char[] buffer = new char[4096];
        while ((len = reader.read(buffer)) > 0) {
            byte[] bytes = new String(buffer, 0, len).getBytes("UTF-8");
            this.write(bytes, 0, bytes.length);
        }
    }

    public void sendStream(Reader reader, long readLength) throws IOException {
        int read;
        char[] buffer = new char[4096];
        for (long remainingReadLength = readLength; remainingReadLength > 0L; remainingReadLength -= (long)read) {
            read = reader.read(buffer, 0, Math.min((int)remainingReadLength, 4096));
            if (read == -1) {
                return;
            }
            byte[] bytes = new String(buffer, 0, read).getBytes("UTF-8");
            this.write(bytes, 0, bytes.length);
        }
    }

    public void finishPacket() throws IOException {
        if (this.buffer.position() > 4) {
            this.checkPacketMaxSize(this.buffer.position());
            if (this.useCompression) {
                this.flushWithCompression();
            } else {
                this.flushDirect();
            }
        }
        if (this.buffer.limit() * 2 < this.buffer.capacity()) {
            this.buffer = this.firstBuffer;
        }
        this.lastSeq = this.useCompression ? this.compressSeqNo : this.seqNo;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(int byteInt) throws IOException {
        byte[] byteArray = new byte[]{(byte)byteInt};
        this.write(byteArray);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.assureBufferCapacity(len);
        this.buffer.put(bytes, off, len);
    }

    @Override
    public void flush() throws IOException {
        throw new AssertionError((Object)"Do not call flush() on PacketOutputStream. use finishPacket() instead.");
    }

    public boolean checkRewritableLength(int length) {
        return !this.checkPacketLength || this.buffer.position() + length <= this.maxRewritableLengthAllowed;
    }

    private void checkPacketMaxSize(int limit) throws MaxAllowedPacketException {
        if (this.checkPacketLength && this.maxAllowedPacket > 0 && limit > this.maxAllowedPacket - 1) {
            this.seqNo = -1;
            throw new MaxAllowedPacketException("max_allowed_packet=" + this.maxAllowedPacket + ". stream size " + limit + " is > to max_allowed_packet", this.seqNo != 0);
        }
    }

    private void flushDirect() throws IOException {
        this.buffer.flip();
        int dataLength = this.buffer.remaining() - 4;
        if (dataLength < this.maxPacketSize) {
            this.buffer.put((byte)(dataLength & 0xFF)).put((byte)(dataLength >>> 8)).put((byte)(dataLength >>> 16)).put((byte)this.seqNo++);
            this.outputStream.write(this.buffer.array(), 0, this.buffer.limit());
            this.outputStream.flush();
        } else {
            this.buffer.put((byte)(this.maxPacketSize & 0xFF)).put((byte)(this.maxPacketSize >>> 8)).put((byte)(this.maxPacketSize >>> 16)).put((byte)this.seqNo++);
            this.outputStream.write(this.buffer.array(), 0, this.maxPacketSize + 4);
            this.outputStream.flush();
            this.buffer.position(this.maxPacketSize + 4);
            while (this.buffer.remaining() > 0) {
                int length = this.buffer.remaining();
                this.buffer.position(this.buffer.position() - 4);
                if (length > this.maxPacketSize) {
                    this.buffer.put((byte)(this.maxPacketSize & 0xFF)).put((byte)(this.maxPacketSize >>> 8)).put((byte)(this.maxPacketSize >>> 16)).put((byte)this.seqNo++);
                    this.outputStream.write(this.buffer.array(), this.buffer.position() - 4, this.maxPacketSize + 4);
                    this.outputStream.flush();
                    this.buffer.position(this.buffer.position() + this.maxPacketSize);
                    continue;
                }
                this.buffer.put((byte)(length & 0xFF)).put((byte)(length >>> 8)).put((byte)(length >>> 16)).put((byte)this.seqNo++);
                this.outputStream.write(this.buffer.array(), this.buffer.position() - 4, length + 4);
                this.outputStream.flush();
                break;
            }
        }
    }

    private void flushWithCompression() throws IOException {
        this.buffer.flip();
        int limit = this.buffer.limit();
        this.buffer.position(4);
        int position = 0;
        int expectedPacketSize = limit - 4 + 4 * (limit / this.maxPacketSize + 1);
        byte[] bufferBytes = new byte[expectedPacketSize];
        while (position < expectedPacketSize) {
            int length = this.buffer.remaining();
            if (length > this.maxPacketSize) {
                length = this.maxPacketSize;
            }
            bufferBytes[position++] = (byte)(length & 0xFF);
            bufferBytes[position++] = (byte)(length >>> 8);
            bufferBytes[position++] = (byte)(length >>> 16);
            bufferBytes[position++] = (byte)this.seqNo++;
            if (length <= 0) continue;
            this.buffer.get(bufferBytes, position, length);
            position += length;
        }
        this.compressedAndSend(position, bufferBytes);
    }

    private void compressedAndSend(int notCompressPosition, byte[] bufferBytes) throws IOException {
        int position = 0;
        while (position - notCompressPosition < 0) {
            int packetLength = Math.min(notCompressPosition - position, this.maxPacketSize);
            boolean compressedPacketSend = false;
            if (packetLength > 16384) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DeflaterOutputStream deflater = new DeflaterOutputStream(baos);
                deflater.write(bufferBytes, position, packetLength);
                deflater.finish();
                deflater.close();
                byte[] compressedBytes = baos.toByteArray();
                baos.close();
                if (compressedBytes.length < (int)(0.9f * (float)packetLength)) {
                    int compressedLength = compressedBytes.length;
                    this.writeCompressedHeader(compressedLength, packetLength);
                    this.outputStream.write(compressedBytes, 0, compressedLength);
                    compressedPacketSend = true;
                }
            }
            if (!compressedPacketSend) {
                this.writeCompressedHeader(packetLength, 0);
                this.outputStream.write(bufferBytes, position, packetLength);
            }
            position += packetLength;
            this.outputStream.flush();
        }
    }

    private void writeCompressedHeader(int packetLength, int initialLength) throws IOException {
        byte[] header = new byte[]{(byte)(packetLength & 0xFF), (byte)(packetLength >> 8 & 0xFF), (byte)(packetLength >> 16 & 0xFF), (byte)this.compressSeqNo++, (byte)(initialLength & 0xFF), (byte)(initialLength >> 8 & 0xFF), (byte)(initialLength >> 16 & 0xFF)};
        this.outputStream.write(header);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
        this.buffer = null;
        this.firstBuffer = null;
        this.closed = true;
    }

    public void setMaxAllowedPacket(int maxAllowedPacket) {
        this.maxAllowedPacket = maxAllowedPacket;
        if (maxAllowedPacket > 0) {
            this.maxPacketSize = Math.min(maxAllowedPacket - 1, 0xFFFFFF);
            this.maxRewritableLengthAllowed = (int)((double)maxAllowedPacket - 4.0 * Math.ceil((double)maxAllowedPacket / (double)this.maxPacketSize));
        } else {
            this.maxPacketSize = 0xFFFFFF;
        }
    }

    public void assureBufferCapacity(int len) {
        while (len > this.buffer.remaining()) {
            int newCapacity = Math.max((int)((float)len + (float)this.buffer.position() * 4.0f), (int)(this.buffer.capacity() > 0x400000 ? (float)this.buffer.capacity() * 1.5f : (float)this.buffer.capacity() * 4.0f));
            this.increase(newCapacity);
        }
    }

    public PacketOutputStream writeByte(byte theByte) {
        this.assureBufferCapacity(1);
        this.buffer.put(theByte);
        return this;
    }

    public PacketOutputStream writeBytes(byte theByte, int count) {
        for (int i = 0; i < count; ++i) {
            this.writeByte(theByte);
        }
        return this;
    }

    public PacketOutputStream writeByteArray(byte[] bytes) {
        this.assureBufferCapacity(bytes.length);
        this.buffer.put(bytes);
        return this;
    }

    public PacketOutputStream writeByteArrayLength(byte[] bytes) {
        this.assureBufferCapacity(bytes.length + 9);
        this.writeFieldLength(bytes.length);
        this.buffer.put(bytes);
        return this;
    }

    public PacketOutputStream writeString(String str) {
        try {
            byte[] strBytes = str.getBytes("UTF-8");
            return this.writeByteArray(strBytes);
        }
        catch (UnsupportedEncodingException u) {
            return this;
        }
    }

    public PacketOutputStream writeShort(short theShort) {
        this.assureBufferCapacity(2);
        this.buffer.putShort(theShort);
        return this;
    }

    public PacketOutputStream writeInt(int theInt) {
        this.assureBufferCapacity(4);
        this.buffer.putInt(theInt);
        return this;
    }

    public PacketOutputStream writeLong(long theLong) {
        this.assureBufferCapacity(8);
        this.buffer.putLong(theLong);
        return this;
    }

    public PacketOutputStream writeFieldLength(long length) {
        if (length < 251L) {
            this.buffer.put((byte)length);
        } else if (length < 65536L) {
            this.assureBufferCapacity(3);
            this.buffer.put((byte)-4);
            this.buffer.putShort((short)length);
        } else if (length < 0x1000000L) {
            this.assureBufferCapacity(4);
            this.buffer.put((byte)-3);
            this.buffer.put((byte)(length & 0xFFL));
            this.buffer.put((byte)(length >>> 8));
            this.buffer.put((byte)(length >>> 16));
        } else {
            this.assureBufferCapacity(9);
            this.buffer.put((byte)-2);
            this.buffer.putLong(length);
        }
        return this;
    }

    public PacketOutputStream writeStringLength(String str) {
        try {
            byte[] strBytes = str.getBytes("UTF-8");
            this.assureBufferCapacity(strBytes.length + 9);
            this.writeFieldLength(strBytes.length);
            this.buffer.put(strBytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this;
    }

    public PacketOutputStream writeTimestampLength(Calendar calendar, Timestamp ts, boolean fractionalSeconds) {
        this.assureBufferCapacity(fractionalSeconds ? 12 : 8);
        this.buffer.put((byte)(fractionalSeconds ? 11 : 7));
        this.buffer.putShort((short)calendar.get(1));
        this.buffer.put((byte)(calendar.get(2) + 1 & 0xFF));
        this.buffer.put((byte)(calendar.get(5) & 0xFF));
        this.buffer.put((byte)calendar.get(11));
        this.buffer.put((byte)calendar.get(12));
        this.buffer.put((byte)calendar.get(13));
        if (fractionalSeconds) {
            this.buffer.putInt(ts.getNanos() / 1000);
        }
        return this;
    }

    public PacketOutputStream writeDateLength(Calendar calendar) {
        this.assureBufferCapacity(8);
        this.buffer.put((byte)7);
        this.buffer.putShort((short)calendar.get(1));
        this.buffer.put((byte)(calendar.get(2) + 1 & 0xFF));
        this.buffer.put((byte)(calendar.get(5) & 0xFF));
        this.buffer.put((byte)0);
        this.buffer.put((byte)0);
        this.buffer.put((byte)0);
        return this;
    }

    public PacketOutputStream writeTimeLength(Calendar calendar, boolean fractionalSeconds) {
        if (fractionalSeconds) {
            this.assureBufferCapacity(13);
            this.buffer.put((byte)12);
            this.buffer.put((byte)0);
            this.buffer.putInt(0);
            this.buffer.put((byte)calendar.get(11));
            this.buffer.put((byte)calendar.get(12));
            this.buffer.put((byte)calendar.get(13));
            this.buffer.putInt(calendar.get(14) * 1000);
        } else {
            this.assureBufferCapacity(9);
            this.buffer.put((byte)8);
            this.buffer.put((byte)0);
            this.buffer.putInt(0);
            this.buffer.put((byte)calendar.get(11));
            this.buffer.put((byte)calendar.get(12));
            this.buffer.put((byte)calendar.get(13));
        }
        return this;
    }

    public void sendPreparePacket(String sql) throws IOException, QueryException {
        if (this.closed) {
            throw new IOException("Stream has already closed");
        }
        this.compressSeqNo = 0;
        byte[] sqlBytes = sql.getBytes("UTF-8");
        int sqlLength = sqlBytes.length + 1;
        if (sqlLength > this.maxAllowedPacket) {
            throw new QueryException("Could not send query: max_allowed_packet=" + this.maxAllowedPacket + " but packet size is : " + sqlLength, -1, ExceptionMapper.SqlStates.INTERRUPTED_EXCEPTION.getSqlState());
        }
        byte[] packetBuffer = new byte[sqlLength + 4];
        packetBuffer[0] = (byte)(sqlLength & 0xFF);
        packetBuffer[1] = (byte)(sqlLength >>> 8);
        packetBuffer[2] = (byte)(sqlLength >>> 16);
        packetBuffer[3] = 0;
        packetBuffer[4] = 22;
        System.arraycopy(sqlBytes, 0, packetBuffer, 5, sqlLength - 1);
        if (!this.useCompression) {
            this.outputStream.write(packetBuffer);
            this.outputStream.flush();
        } else {
            this.compressedAndSend(sqlLength + 4, packetBuffer);
        }
    }

    public void sendTextPacket(String sql) throws IOException, QueryException {
        if (this.closed) {
            throw new IOException("Stream has already closed");
        }
        this.seqNo = 0;
        this.compressSeqNo = 0;
        byte[] sqlBytes = sql.getBytes("UTF-8");
        int sqlLength = sqlBytes.length;
        if (sqlLength + 1 > this.maxAllowedPacket) {
            throw new QueryException("Could not send query: max_allowed_packet=" + this.maxAllowedPacket + " but packet size is : " + (sqlLength + 1), -1, ExceptionMapper.SqlStates.INTERRUPTED_EXCEPTION.getSqlState());
        }
        if (!this.useCompression) {
            if (sqlLength + 1 <= this.maxPacketSize) {
                byte[] packetBuffer = new byte[sqlLength + 5];
                packetBuffer[0] = (byte)(sqlLength + 1 & 0xFF);
                packetBuffer[1] = (byte)(sqlLength + 1 >>> 8);
                packetBuffer[2] = (byte)(sqlLength + 1 >>> 16);
                packetBuffer[3] = (byte)this.seqNo++;
                packetBuffer[4] = 3;
                System.arraycopy(sqlBytes, 0, packetBuffer, 5, sqlLength);
                this.outputStream.write(packetBuffer);
                this.outputStream.flush();
            } else {
                int length;
                byte[] packetBuffer = new byte[this.maxPacketSize + 4];
                packetBuffer[0] = (byte)(this.maxPacketSize & 0xFF);
                packetBuffer[1] = (byte)(this.maxPacketSize >>> 8);
                packetBuffer[2] = (byte)(this.maxPacketSize >>> 16);
                packetBuffer[3] = (byte)this.seqNo++;
                packetBuffer[4] = 3;
                System.arraycopy(sqlBytes, 0, packetBuffer, 5, this.maxPacketSize - 1);
                int sqlBytesPosition = this.maxPacketSize - 1;
                this.outputStream.write(packetBuffer);
                this.outputStream.flush();
                while ((length = sqlLength - sqlBytesPosition) > 0) {
                    if (length > this.maxPacketSize) {
                        packetBuffer[0] = (byte)(this.maxPacketSize & 0xFF);
                        packetBuffer[1] = (byte)(this.maxPacketSize >>> 8);
                        packetBuffer[2] = (byte)(this.maxPacketSize >>> 16);
                        packetBuffer[3] = (byte)this.seqNo++;
                        System.arraycopy(sqlBytes, sqlBytesPosition, packetBuffer, 4, this.maxPacketSize);
                        this.outputStream.write(packetBuffer);
                        this.outputStream.flush();
                        sqlBytesPosition += this.maxPacketSize;
                        continue;
                    }
                    packetBuffer[0] = (byte)(length & 0xFF);
                    packetBuffer[1] = (byte)(length >>> 8);
                    packetBuffer[2] = (byte)(length >>> 16);
                    packetBuffer[3] = (byte)this.seqNo++;
                    System.arraycopy(sqlBytes, sqlBytesPosition, packetBuffer, 4, length);
                    this.outputStream.write(packetBuffer, 0, length + 4);
                    this.outputStream.flush();
                    break;
                }
            }
        } else if (sqlLength < this.maxPacketSize) {
            byte[] packetBuffer = new byte[sqlLength + 5];
            packetBuffer[0] = (byte)(sqlLength + 1 & 0xFF);
            packetBuffer[1] = (byte)(sqlLength + 1 >>> 8);
            packetBuffer[2] = (byte)(sqlLength + 1 >>> 16);
            packetBuffer[3] = (byte)this.seqNo++;
            packetBuffer[4] = 3;
            System.arraycopy(sqlBytes, 0, packetBuffer, 5, sqlLength);
            this.compressedAndSend(sqlLength + 5, packetBuffer);
        } else {
            int length;
            int expectedPacketSize = sqlLength + 1 + 4 * ((sqlLength + 1) / this.maxPacketSize + 1);
            byte[] packetBuffer = new byte[expectedPacketSize];
            packetBuffer[0] = (byte)(this.maxPacketSize & 0xFF);
            packetBuffer[1] = (byte)(this.maxPacketSize >>> 8);
            packetBuffer[2] = (byte)(this.maxPacketSize >>> 16);
            packetBuffer[3] = (byte)this.seqNo++;
            packetBuffer[4] = 3;
            System.arraycopy(sqlBytes, 0, packetBuffer, 5, this.maxPacketSize - 1);
            int sqlBytesPosition = this.maxPacketSize - 1;
            int positionDest = this.maxPacketSize + 4;
            while ((length = sqlLength - sqlBytesPosition) > 0) {
                if (length > this.maxPacketSize) {
                    packetBuffer[positionDest++] = (byte)(this.maxPacketSize & 0xFF);
                    packetBuffer[positionDest++] = (byte)(this.maxPacketSize >>> 8);
                    packetBuffer[positionDest++] = (byte)(this.maxPacketSize >>> 16);
                    packetBuffer[positionDest++] = (byte)this.seqNo++;
                    System.arraycopy(sqlBytes, sqlBytesPosition, packetBuffer, positionDest, this.maxPacketSize);
                    sqlBytesPosition += this.maxPacketSize;
                    positionDest += this.maxPacketSize;
                    continue;
                }
                packetBuffer[positionDest++] = (byte)(length & 0xFF);
                packetBuffer[positionDest++] = (byte)(length >>> 8);
                packetBuffer[positionDest++] = (byte)(length >>> 16);
                packetBuffer[positionDest++] = (byte)this.seqNo++;
                System.arraycopy(sqlBytes, sqlBytesPosition, packetBuffer, positionDest, length);
                break;
            }
            this.compressedAndSend(expectedPacketSize, packetBuffer);
        }
    }
}

