/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.failover.HandleErrorResult;
import org.mariadb.jdbc.internal.failover.Listener;
import org.mariadb.jdbc.internal.failover.thread.ConnectionValidator;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.SqlStates;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;
import org.mariadb.jdbc.internal.util.pool.GlobalStateInfo;

public abstract class AbstractMastersListener
implements Listener {
    private static final ConcurrentMap<HostAddress, Long> blacklist = new ConcurrentHashMap<HostAddress, Long>();
    private static final ConnectionValidator connectionValidationLoop = new ConnectionValidator();
    private static final Logger logger = LoggerFactory.getLogger(AbstractMastersListener.class);
    public final UrlParser urlParser;
    protected final AtomicInteger currentConnectionAttempts = new AtomicInteger();
    protected final AtomicBoolean explicitClosed = new AtomicBoolean(false);
    protected final GlobalStateInfo globalInfo;
    private final AtomicBoolean masterHostFail = new AtomicBoolean();
    protected volatile boolean currentReadOnlyAsked = false;
    protected Protocol currentProtocol = null;
    protected FailoverProxy proxy;
    protected long lastRetry = 0L;
    protected long lastQueryNanos = 0L;
    private volatile long masterHostFailNanos = 0L;

    protected AbstractMastersListener(UrlParser urlParser, GlobalStateInfo globalInfo) {
        this.urlParser = urlParser;
        this.globalInfo = globalInfo;
        this.masterHostFail.set(true);
        this.lastQueryNanos = System.nanoTime();
    }

    public static void clearBlacklist() {
        blacklist.clear();
    }

    @Override
    public void initializeConnection() throws SQLException {
        long connectionTimeoutMillis = TimeUnit.SECONDS.toMillis(this.urlParser.getOptions().validConnectionTimeout);
        this.lastQueryNanos = System.nanoTime();
        if (connectionTimeoutMillis > 0L) {
            connectionValidationLoop.addListener(this, connectionTimeoutMillis);
        }
    }

    protected void removeListenerFromSchedulers() {
        connectionValidationLoop.removeListener(this);
    }

    protected void preAutoReconnect() throws SQLException {
        if (!this.isExplicitClosed()) {
            try {
                boolean currentReadOnlyAsked = this.currentReadOnlyAsked;
                this.reconnectFailedConnection(new SearchFilter(!currentReadOnlyAsked, currentReadOnlyAsked));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        } else {
            throw new SQLException("Connection is closed", SqlStates.CONNECTION_EXCEPTION.getSqlState());
        }
        this.handleFailLoop();
    }

    @Override
    public FailoverProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(FailoverProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public Set<HostAddress> getBlacklistKeys() {
        return blacklist.keySet();
    }

    @Override
    public HandleErrorResult handleFailover(SQLException qe, Method method, Object[] args, Protocol protocol, boolean isClosed) throws SQLException {
        if (this.isExplicitClosed()) {
            throw new SQLException("Connection has been closed !");
        }
        if (this.setMasterHostFail()) {
            logger.warn("SQL Primary node [{}, conn={}, local_port={}, timeout={}] connection fail. Reason : {}", this.currentProtocol.getHostAddress().toString(), this.currentProtocol.getServerThreadId(), this.currentProtocol.getSocket().getLocalPort(), this.currentProtocol.getTimeout(), qe.getMessage());
            this.addToBlacklist(this.currentProtocol.getHostAddress());
        }
        boolean killCmd = qe != null && qe.getSQLState() != null && qe.getSQLState().equals("70100") && 1927 == qe.getErrorCode();
        return this.primaryFail(method, args, killCmd, isClosed);
    }

    @Override
    public void addToBlacklist(HostAddress hostAddress) {
        if (hostAddress != null && !this.isExplicitClosed()) {
            blacklist.putIfAbsent(hostAddress, System.nanoTime());
        }
    }

    @Override
    public void removeFromBlacklist(HostAddress hostAddress) {
        if (hostAddress != null) {
            blacklist.remove(hostAddress);
        }
    }

    public void resetOldsBlackListHosts() {
        long currentTimeNanos = System.nanoTime();
        Set entries = blacklist.entrySet();
        for (Map.Entry blEntry : entries) {
            long entryNanos = (Long)blEntry.getValue();
            long durationSeconds = TimeUnit.NANOSECONDS.toSeconds(currentTimeNanos - entryNanos);
            if (durationSeconds < (long)this.urlParser.getOptions().loadBalanceBlacklistTimeout) continue;
            blacklist.remove(blEntry.getKey(), entryNanos);
        }
    }

    protected void resetMasterFailoverData() {
        if (this.masterHostFail.compareAndSet(true, false)) {
            this.masterHostFailNanos = 0L;
        }
    }

    protected void setSessionReadOnly(boolean readOnly, Protocol protocol) throws SQLException {
        if (protocol.versionGreaterOrEqual(5, 6, 5)) {
            logger.info("SQL node [{}, conn={}] is now in {} mode.", protocol.getHostAddress().toString(), protocol.getServerThreadId(), readOnly ? "read-only" : "write");
            protocol.executeQuery("SET SESSION TRANSACTION " + (readOnly ? "READ ONLY" : "READ WRITE"));
        }
    }

    public abstract void handleFailLoop();

    @Override
    public Protocol getCurrentProtocol() {
        return this.currentProtocol;
    }

    public long getMasterHostFailNanos() {
        return this.masterHostFailNanos;
    }

    @Override
    public boolean setMasterHostFail() {
        if (this.masterHostFail.compareAndSet(false, true)) {
            this.masterHostFailNanos = System.nanoTime();
            this.currentConnectionAttempts.set(0);
            return true;
        }
        return false;
    }

    @Override
    public boolean isMasterHostFail() {
        return this.masterHostFail.get();
    }

    @Override
    public boolean hasHostFail() {
        return this.masterHostFail.get();
    }

    @Override
    public SearchFilter getFilterForFailedHost() {
        return new SearchFilter(this.isMasterHostFail(), false);
    }

    public HandleErrorResult relaunchOperation(Method method, Object[] args) throws SQLException {
        HandleErrorResult handleErrorResult = new HandleErrorResult(true);
        if (method != null) {
            switch (method.getName()) {
                case "executeQuery": {
                    String query;
                    if (!(args[2] instanceof String) || "ALTER SYSTEM CRASH".equals(query = ((String)args[2]).toUpperCase(Locale.ROOT)) || query.startsWith("KILL")) break;
                    logger.debug("relaunch query to new connection {}", (Object)(this.currentProtocol != null ? "(conn=" + this.currentProtocol.getServerThreadId() + ")" : ""));
                    try {
                        handleErrorResult.resultObject = method.invoke((Object)this.currentProtocol, args);
                        handleErrorResult.mustThrowError = false;
                        break;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new SQLException(e);
                    }
                }
                case "executePreparedQuery": {
                    try {
                        boolean mustBeOnMaster = (Boolean)args[0];
                        ServerPrepareResult oldServerPrepareResult = (ServerPrepareResult)args[1];
                        ServerPrepareResult serverPrepareResult = this.currentProtocol.prepare(oldServerPrepareResult.getSql(), mustBeOnMaster);
                        oldServerPrepareResult.failover(serverPrepareResult.getStatementId(), this.currentProtocol);
                        logger.debug("relaunch query to new connection " + (this.currentProtocol != null ? "server thread id " + this.currentProtocol.getServerThreadId() : ""));
                        handleErrorResult.resultObject = method.invoke((Object)this.currentProtocol, args);
                        handleErrorResult.mustThrowError = false;
                    }
                    catch (Exception mustBeOnMaster) {}
                    break;
                }
                default: {
                    try {
                        handleErrorResult.resultObject = method.invoke((Object)this.currentProtocol, args);
                        handleErrorResult.mustThrowError = false;
                        break;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new SQLException(e);
                    }
                }
            }
        }
        return handleErrorResult;
    }

    public boolean isQueryRelaunchable(Method method, Object[] args) {
        if (method != null) {
            switch (method.getName()) {
                case "executeQuery": {
                    if (!((Boolean)args[0]).booleanValue()) {
                        return true;
                    }
                    if (args[2] instanceof String) {
                        return ((String)args[2]).toUpperCase(Locale.ROOT).startsWith("SELECT");
                    }
                    if (!(args[2] instanceof ClientPrepareResult)) break;
                    String query = new String(((ClientPrepareResult)args[2]).getQueryParts().get(0)).toUpperCase(Locale.ROOT);
                    return query.startsWith("SELECT");
                }
                case "executePreparedQuery": {
                    if (!((Boolean)args[0]).booleanValue()) {
                        return true;
                    }
                    ServerPrepareResult serverPrepareResult = (ServerPrepareResult)args[1];
                    return serverPrepareResult.getSql().toUpperCase(Locale.ROOT).startsWith("SELECT");
                }
                case "executeBatchStmt": 
                case "executeBatchClient": 
                case "executeBatchServer": {
                    return (Boolean)args[0] == false;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public Object invoke(Method method, Object[] args, Protocol specificProtocol) throws Throwable {
        return method.invoke((Object)specificProtocol, args);
    }

    @Override
    public Object invoke(Method method, Object[] args) throws Throwable {
        return method.invoke((Object)this.currentProtocol, args);
    }

    @Override
    public void syncConnection(Protocol from, Protocol to) throws SQLException {
        if (from != null) {
            this.proxy.lock.lock();
            try {
                to.resetStateAfterFailover(from.getMaxRows(), from.getTransactionIsolationLevel(), from.getDatabase(), from.getAutocommit());
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public boolean versionGreaterOrEqual(int major, int minor, int patch) {
        return this.currentProtocol.versionGreaterOrEqual(major, minor, patch);
    }

    @Override
    public boolean sessionStateAware() {
        return this.currentProtocol.sessionStateAware();
    }

    @Override
    public boolean noBackslashEscapes() {
        return this.currentProtocol.noBackslashEscapes();
    }

    @Override
    public int getMajorServerVersion() {
        return this.currentProtocol.getMajorServerVersion();
    }

    @Override
    public boolean isClosed() {
        return this.currentProtocol.isClosed();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.currentProtocol.isValid(timeout);
    }

    @Override
    public boolean isReadOnly() {
        return this.currentReadOnlyAsked;
    }

    @Override
    public boolean inTransaction() {
        return this.currentProtocol.inTransaction();
    }

    @Override
    public boolean isMasterConnection() {
        return true;
    }

    @Override
    public boolean isExplicitClosed() {
        return this.explicitClosed.get();
    }

    @Override
    public int getRetriesAllDown() {
        return this.urlParser.getOptions().retriesAllDown;
    }

    @Override
    public boolean isAutoReconnect() {
        return this.urlParser.getOptions().autoReconnect;
    }

    @Override
    public UrlParser getUrlParser() {
        return this.urlParser;
    }

    @Override
    public abstract void preExecute() throws SQLException;

    @Override
    public abstract void preClose();

    @Override
    public abstract void reconnectFailedConnection(SearchFilter var1) throws SQLException;

    @Override
    public abstract void switchReadOnlyConnection(Boolean var1) throws SQLException;

    @Override
    public abstract HandleErrorResult primaryFail(Method var1, Object[] var2, boolean var3, boolean var4) throws SQLException;

    @Override
    public void throwFailoverMessage(HostAddress failHostAddress, boolean wasMaster, SQLException queryException, boolean reconnected) throws SQLException {
        String sqlState;
        String message;
        String firstPart = "Communications link failure with " + (wasMaster ? "primary" : "secondary") + (failHostAddress != null ? " host " + failHostAddress.host + ":" + failHostAddress.port : "") + ". ";
        String error = "";
        if (reconnected) {
            error = error + " Driver has reconnect connection";
        } else if (this.currentConnectionAttempts.get() > this.urlParser.getOptions().retriesAllDown) {
            error = error + " Driver will not try to reconnect (too much failure > " + this.urlParser.getOptions().retriesAllDown + ")";
        }
        int vendorCode = 0;
        Throwable cause = null;
        if (queryException == null) {
            message = firstPart + error;
            sqlState = SqlStates.CONNECTION_EXCEPTION.getSqlState();
        } else {
            message = firstPart + queryException.getMessage() + ". " + error;
            sqlState = queryException.getSQLState();
            vendorCode = queryException.getErrorCode();
            cause = queryException.getCause();
        }
        if (sqlState != null && sqlState.startsWith("08")) {
            if (reconnected) {
                sqlState = "25S03";
            } else {
                throw new SQLNonTransientConnectionException(message, sqlState, vendorCode, cause);
            }
        }
        throw new SQLException(message, sqlState, vendorCode, cause);
    }

    @Override
    public boolean canRetryFailLoop() {
        return this.currentConnectionAttempts.get() < this.urlParser.getOptions().failoverLoopRetries;
    }

    @Override
    public void prolog(long maxRows, MariaDbConnection connection, MariaDbStatement statement) throws SQLException {
        this.currentProtocol.prolog(maxRows, true, connection, statement);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.currentProtocol.getCatalog();
    }

    @Override
    public int getTimeout() throws SocketException {
        return this.currentProtocol.getTimeout();
    }

    @Override
    public abstract void reconnect() throws SQLException;

    @Override
    public abstract boolean checkMasterStatus(SearchFilter var1);

    @Override
    public long getLastQueryNanos() {
        return this.lastQueryNanos;
    }

    protected boolean pingMasterProtocol(Protocol protocol) {
        try {
            if (protocol.isValid(1000)) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.proxy.lock.lock();
        try {
            protocol.close();
            if (this.setMasterHostFail()) {
                this.addToBlacklist(protocol.getHostAddress());
            }
        }
        finally {
            this.proxy.lock.unlock();
        }
        return false;
    }

    public void closeConnection(Protocol protocol) {
        if (protocol != null && protocol.isConnected()) {
            protocol.close();
        }
    }

    public void abortConnection(Protocol protocol) {
        if (protocol != null && protocol.isConnected()) {
            protocol.abort();
        }
    }
}

