/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.scribe.invoker;

import java.util.Map;
import org.milyn.assertion.AssertArgument;
import org.milyn.scribe.NoMethodWithAnnotationFoundException;
import org.milyn.scribe.annotation.Delete;
import org.milyn.scribe.annotation.Flush;
import org.milyn.scribe.annotation.Insert;
import org.milyn.scribe.annotation.Lookup;
import org.milyn.scribe.annotation.LookupByQuery;
import org.milyn.scribe.annotation.Update;
import org.milyn.scribe.invoker.DaoInvoker;
import org.milyn.scribe.reflection.AnnotatedDaoRuntimeInfo;
import org.milyn.scribe.reflection.EntityMethod;
import org.milyn.scribe.reflection.FlushMethod;
import org.milyn.scribe.reflection.LookupMethod;
import org.milyn.scribe.reflection.LookupWithNamedQueryMethod;
import org.milyn.scribe.reflection.LookupWithPositionalQueryMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedDaoInvoker
implements DaoInvoker {
    private final Object dao;
    private final AnnotatedDaoRuntimeInfo daoRuntimeInfo;

    public AnnotatedDaoInvoker(Object dao, AnnotatedDaoRuntimeInfo daoRuntimeInfo) {
        AssertArgument.isNotNull((Object)dao, (String)"dao");
        AssertArgument.isNotNull((Object)daoRuntimeInfo, (String)"daoRuntimeInfo");
        this.dao = dao;
        this.daoRuntimeInfo = daoRuntimeInfo;
    }

    @Override
    public void flush() {
        FlushMethod method = this.daoRuntimeInfo.getFlushMethod();
        this.assertMethod(method, Flush.class);
        method.invoke(this.dao);
    }

    @Override
    public Object update(Object entity) {
        EntityMethod method = this.daoRuntimeInfo.getDefaultUpdateMethod();
        this.assertMethod(method, Update.class);
        return method.invoke(this.dao, entity);
    }

    @Override
    public Object update(String name, Object entity) {
        EntityMethod method = this.daoRuntimeInfo.getUpdateMethod(name);
        this.assertMethod(method, name, Update.class);
        return method.invoke(this.dao, entity);
    }

    @Override
    public Object insert(Object entity) {
        EntityMethod method = this.daoRuntimeInfo.getDefaultInsertMethod();
        this.assertMethod(method, Insert.class);
        return method.invoke(this.dao, entity);
    }

    @Override
    public Object insert(String name, Object entity) {
        EntityMethod method = this.daoRuntimeInfo.getInsertMethod(name);
        this.assertMethod(method, name, Insert.class);
        return method.invoke(this.dao, entity);
    }

    @Override
    public Object delete(Object entity) {
        EntityMethod method = this.daoRuntimeInfo.getDefaultDeleteMethod();
        this.assertMethod(method, Delete.class);
        return method.invoke(this.dao, entity);
    }

    @Override
    public Object delete(String name, Object entity) {
        EntityMethod method = this.daoRuntimeInfo.getDeleteMethod(name);
        this.assertMethod(method, name, Delete.class);
        return method.invoke(this.dao, entity);
    }

    @Override
    public Object lookupByQuery(String query, Object ... parameters) {
        LookupWithPositionalQueryMethod method = this.daoRuntimeInfo.getLookupByPositionalQueryMethod();
        if (method == null) {
            throw new NoMethodWithAnnotationFoundException("No method found in DAO class '" + this.dao.getClass().getName() + "' that is annotated " + "with '" + LookupByQuery.class.getSimpleName() + "' annotation and has an Array argument for the positional parameters.");
        }
        return method.invoke(this.dao, query, parameters);
    }

    @Override
    public Object lookupByQuery(String query, Map<String, ?> parameters) {
        LookupWithNamedQueryMethod method = this.daoRuntimeInfo.getLookupByNamedQueryMethod();
        if (method == null) {
            throw new NoMethodWithAnnotationFoundException("No method found in DAO class '" + this.dao.getClass().getName() + "' that is annotated " + "with '" + LookupByQuery.class.getSimpleName() + "' annotation and has a Map argument for the named parameters.");
        }
        return method.invoke(this.dao, query, parameters);
    }

    @Override
    public Object lookup(String name, Map<String, ?> parameters) {
        LookupMethod method = this.daoRuntimeInfo.getLookupWithNamedParametersMethod(name);
        this.assertMethod(method, name, Lookup.class);
        return method.invoke(this.dao, parameters);
    }

    @Override
    public Object lookup(String name, Object ... parameters) {
        LookupMethod method = this.daoRuntimeInfo.getLookupWithNamedParametersMethod(name);
        this.assertMethod(method, name, Lookup.class);
        return method.invoke(this.dao, parameters);
    }

    private void assertMethod(Object method, Class<?> annotation) {
        if (method == null) {
            throw new NoMethodWithAnnotationFoundException("No method found in DAO class '" + this.dao.getClass().getName() + "' that is annotated with the '" + annotation.getSimpleName() + "' annotation.");
        }
    }

    private void assertMethod(Object method, String name, Class<?> annotation) {
        if (method == null) {
            throw new NoMethodWithAnnotationFoundException("No method found in DAO class '" + this.dao.getClass().getName() + "' that is annotated with the '" + annotation.getSimpleName() + "' annotation and has the name '" + name + "'.");
        }
    }
}

