/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.db;

import java.sql.Connection;
import java.sql.SQLException;
import org.milyn.assertion.AssertArgument;
import org.milyn.db.TransactionException;
import org.milyn.db.TransactionManager;

class JdbcTransactionManager
implements TransactionManager {
    private final Connection connection;
    private final boolean autoCommit;

    public JdbcTransactionManager(Connection connection, boolean autoCommit) {
        AssertArgument.isNotNull(connection, "connection");
        this.connection = connection;
        this.autoCommit = autoCommit;
    }

    public void begin() {
        try {
            if (this.connection.getAutoCommit() != this.autoCommit) {
                this.connection.setAutoCommit(this.autoCommit);
            }
        }
        catch (SQLException e) {
            throw new TransactionException("Exception while setting the autoCommit flag of the connection", e);
        }
    }

    public void commit() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new TransactionException("Exception while committing the connection", e);
        }
    }

    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new TransactionException("Exception while rolling back the connection", e);
        }
    }
}

