/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.xpath.SelectorStep;
import org.milyn.delivery.ContentHandlerConfigMap;
import org.milyn.delivery.VisitLifecycleCleanable;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.delivery.sax.SAXVisitChildren;
import org.milyn.delivery.sax.SAXVisitor;
import org.milyn.delivery.sax.annotation.StreamResultWriter;
import org.milyn.delivery.sax.annotation.TextConsumer;
import org.milyn.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAXElementVisitorMap {
    private List<ContentHandlerConfigMap<SAXVisitBefore>> visitBefores;
    private List<ContentHandlerConfigMap<SAXVisitChildren>> childVisitors;
    private List<ContentHandlerConfigMap<SAXVisitAfter>> visitAfters;
    private List<ContentHandlerConfigMap<VisitLifecycleCleanable>> visitCleanables;
    private boolean accumulateText = false;
    private SAXVisitor acquireWriterFor = null;

    public List<ContentHandlerConfigMap<SAXVisitBefore>> getVisitBefores() {
        return this.visitBefores;
    }

    public void setVisitBefores(List<ContentHandlerConfigMap<SAXVisitBefore>> visitBefores) {
        this.visitBefores = visitBefores;
    }

    public List<ContentHandlerConfigMap<SAXVisitChildren>> getChildVisitors() {
        return this.childVisitors;
    }

    public void setChildVisitors(List<ContentHandlerConfigMap<SAXVisitChildren>> childVisitors) {
        this.childVisitors = childVisitors;
    }

    public List<ContentHandlerConfigMap<SAXVisitAfter>> getVisitAfters() {
        return this.visitAfters;
    }

    public void setVisitAfters(List<ContentHandlerConfigMap<SAXVisitAfter>> visitAfters) {
        this.visitAfters = visitAfters;
    }

    public List<ContentHandlerConfigMap<VisitLifecycleCleanable>> getVisitCleanables() {
        return this.visitCleanables;
    }

    public void setVisitCleanables(List<ContentHandlerConfigMap<VisitLifecycleCleanable>> visitCleanables) {
        this.visitCleanables = visitCleanables;
    }

    public boolean accumulateText() {
        return this.accumulateText;
    }

    public SAXVisitor acquireWriterFor() {
        return this.acquireWriterFor;
    }

    public void initAccumulateText() {
        if (this.getAnnotatedHandler(this.visitBefores, TextConsumer.class, false) != null) {
            this.accumulateText = true;
            return;
        }
        if (this.getAnnotatedHandler(this.visitAfters, TextConsumer.class, false) != null) {
            this.accumulateText = true;
            return;
        }
        if (this.visitAfters == null) {
            return;
        }
        for (ContentHandlerConfigMap<SAXVisitAfter> contentHandlerMap : this.visitAfters) {
            SmooksResourceConfiguration resourceConfig = contentHandlerMap.getResourceConfig();
            SelectorStep selectorStep = resourceConfig.getSelectorStep();
            if (!selectorStep.accessesText()) continue;
            this.accumulateText = true;
            break;
        }
    }

    public void initAccumulateText(SAXElementVisitorMap srcMap) {
        this.accumulateText = this.accumulateText || srcMap.accumulateText;
    }

    public void initAcquireWriterFor(SAXElementVisitorMap srcMap) {
        if (this.acquireWriterFor == null) {
            this.acquireWriterFor = srcMap.acquireWriterFor;
        }
    }

    public void initAcquireWriterFor() {
        this.acquireWriterFor = this.getAnnotatedHandler(this.visitBefores, StreamResultWriter.class, true);
        if (this.acquireWriterFor == null) {
            this.acquireWriterFor = this.getAnnotatedHandler(this.visitAfters, StreamResultWriter.class, true);
        }
    }

    public SAXElementVisitorMap merge(SAXElementVisitorMap map) {
        if (map == null) {
            return this;
        }
        SAXElementVisitorMap merge = new SAXElementVisitorMap();
        merge.visitBefores = new ArrayList<ContentHandlerConfigMap<SAXVisitBefore>>();
        merge.childVisitors = new ArrayList<ContentHandlerConfigMap<SAXVisitChildren>>();
        merge.visitAfters = new ArrayList<ContentHandlerConfigMap<SAXVisitAfter>>();
        merge.visitCleanables = new ArrayList<ContentHandlerConfigMap<VisitLifecycleCleanable>>();
        merge.visitBefores.addAll(this.visitBefores);
        merge.visitBefores.addAll(map.visitBefores);
        merge.childVisitors.addAll(this.childVisitors);
        merge.childVisitors.addAll(map.childVisitors);
        merge.visitAfters.addAll(this.visitAfters);
        merge.visitAfters.addAll(map.visitAfters);
        merge.visitCleanables.addAll(this.visitCleanables);
        merge.visitCleanables.addAll(map.visitCleanables);
        merge.accumulateText = this.accumulateText || merge.accumulateText;
        return merge;
    }

    private <T extends SAXVisitor> T getAnnotatedHandler(List<ContentHandlerConfigMap<T>> handlerMaps, Class<? extends Annotation> annotationClass, boolean checkFields) {
        if (handlerMaps == null) {
            return null;
        }
        for (ContentHandlerConfigMap<T> handlerMap : handlerMaps) {
            SAXVisitor contentHandler = (SAXVisitor)handlerMap.getContentHandler();
            if (contentHandler.getClass().isAnnotationPresent(annotationClass)) {
                return (T)contentHandler;
            }
            if (!checkFields || ClassUtil.getAnnotatedFields(contentHandler.getClass(), annotationClass).isEmpty()) continue;
            return (T)contentHandler;
        }
        return null;
    }
}

