/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.payload;

import com.thoughtworks.xstream.XStream;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.milyn.assertion.AssertArgument;
import org.milyn.javabean.context.StandaloneBeanContext;
import org.milyn.payload.Export;
import org.milyn.payload.FilterResult;
import org.milyn.payload.ResultExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaResult
extends FilterResult
implements ResultExtractor<JavaResult> {
    private Map<String, Object> resultMap;

    public JavaResult() {
        this(false);
    }

    public JavaResult(boolean preserveOrder) {
        this.resultMap = preserveOrder ? new LinkedHashMap<String, Object>() : new HashMap<String, Object>();
    }

    public JavaResult(Map<String, Object> resultMap) {
        AssertArgument.isNotNull(resultMap, "resultMap");
        this.resultMap = resultMap;
    }

    public Object getBean(String name) {
        return this.resultMap.get(name);
    }

    public <T> T getBean(Class<T> beanType) {
        return StandaloneBeanContext.getBean(beanType, this.resultMap);
    }

    public Map<String, Object> getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(Map<String, Object> resultMap) {
        this.resultMap = resultMap;
    }

    public String toString() {
        StringWriter stringBuilder = new StringWriter();
        XStream xstream = new XStream();
        if (this.resultMap != null && !this.resultMap.isEmpty()) {
            Set<Map.Entry<String, Object>> entries = this.resultMap.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                stringBuilder.write(entry.getKey() + ":\n");
                stringBuilder.write(xstream.toXML(entry.getValue()) + "\n\n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public Object extractFromResult(JavaResult result, Export export) {
        Set<String> extractSet = export.getExtractSet();
        if (extractSet == null) {
            return this.extractBeans(result, result.getResultMap().keySet());
        }
        if (extractSet.size() == 1) {
            return result.getBean(extractSet.iterator().next());
        }
        return this.extractBeans(result, extractSet);
    }

    private Object extractBeans(JavaResult result, Collection<String> extractSet) {
        ResultMap<String, Object> extractedObjects = new ResultMap<String, Object>();
        for (String extract : extractSet) {
            Object bean = result.getBean(extract);
            if (bean == null) continue;
            extractedObjects.put(extract, bean);
        }
        return extractedObjects;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResultMap<K, V>
    extends HashMap<K, V> {
    }
}

