/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.payload;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.milyn.assertion.AssertArgument;
import org.milyn.payload.FilterSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSource
extends FilterSource {
    public static final String FEATURE_GENERATE_EVENT_STREAM = "http://www.smooks.org/sax/features/generate-java-event-stream";
    private List<Object> sourceObjects;
    private Map<String, Object> beans;
    private boolean eventStreamRequired = true;

    public JavaSource() {
        this.eventStreamRequired = false;
    }

    public JavaSource(Object sourceObject) {
        AssertArgument.isNotNull(sourceObject, "sourceObject");
        this.sourceObjects = new ArrayList<Object>();
        this.sourceObjects.add(sourceObject);
        if (sourceObject instanceof Map) {
            this.beans = (Map)sourceObject;
        } else {
            this.beans = new HashMap<String, Object>();
            this.beans.put(this.toPropertyName(sourceObject.getClass().getSimpleName()), sourceObject);
        }
    }

    public JavaSource(String objectName, Object sourceObject) {
        AssertArgument.isNotNull(sourceObject, "sourceObject");
        this.sourceObjects = new ArrayList<Object>();
        this.sourceObjects.add(sourceObject);
        this.beans = new HashMap<String, Object>();
        this.beans.put(objectName, sourceObject);
    }

    public JavaSource(List<Object> sourceObjects) {
        AssertArgument.isNotNull(sourceObjects, "sourceObjects");
        this.sourceObjects = sourceObjects;
        this.beans = new HashMap<String, Object>();
        this.beans.put("objects", sourceObjects);
    }

    public boolean isEventStreamRequired() {
        return this.eventStreamRequired;
    }

    public void setEventStreamRequired(boolean eventStreamRequired) {
        this.eventStreamRequired = eventStreamRequired;
    }

    public List<Object> getSourceObjects() {
        return this.sourceObjects;
    }

    public Map<String, Object> getBeans() {
        return this.beans;
    }

    public void setBeans(Map<String, Object> beans) {
        this.beans = beans;
    }

    private String toPropertyName(String simpleName) {
        char charAt;
        StringBuilder stringBuilder = new StringBuilder(simpleName);
        int stringLength = stringBuilder.length();
        for (int i = 0; i < stringLength && !Character.isLowerCase(charAt = stringBuilder.charAt(i)); ++i) {
            stringBuilder.setCharAt(i, Character.toLowerCase(charAt));
        }
        return stringBuilder.toString();
    }
}

