/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.fixedlength;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.VisitorAppender;
import org.milyn.delivery.VisitorConfigMap;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMVisitAfter;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.fixedlength.FixedLengthBindingType;
import org.milyn.function.StringFunctionExecutor;
import org.milyn.javabean.Bean;
import org.milyn.javabean.context.BeanContext;
import org.milyn.xml.SmooksXMLReader;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

public class FixedLengthReader
implements SmooksXMLReader,
VisitorAppender {
    private static Log logger = LogFactory.getLog(FixedLengthReader.class);
    private static final AttributesImpl EMPTY_ATTRIBS = new AttributesImpl();
    private static final String IGNORE_FIELD = "$ignore$";
    private static final char FUNCTION_SEPARATOR = '?';
    private static char[] INDENT_LF = new char[]{'\n'};
    private static char[] INDENT_1 = new char[]{'\t'};
    private static char[] INDENT_2 = new char[]{'\t', '\t'};
    private ContentHandler contentHandler;
    private ExecutionContext execContext;
    @ConfigParam(name="fields")
    private String[] flFields;
    private Field[] fields;
    private int totalFieldLenght;
    @ConfigParam(defaultVal="false")
    private boolean lineNumber;
    @ConfigParam(defaultVal="0")
    private int skipLines;
    @ConfigParam(defaultVal="true")
    private boolean strict;
    @ConfigParam(defaultVal="UTF-8")
    private Charset encoding;
    @ConfigParam(defaultVal="set")
    private String rootElementName;
    @ConfigParam(defaultVal="record")
    private String recordElementName;
    @ConfigParam(defaultVal="number")
    private String lineNumberAttributeName;
    @ConfigParam(defaultVal="truncated")
    private String truncatedAttributeName;
    @ConfigParam(defaultVal="false")
    private boolean indent;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String bindBeanId;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private Class<?> bindBeanClass;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private FixedLengthBindingType bindingType;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String bindMapKeyField;
    private static final String RECORD_BEAN = "flRecordBean";
    public boolean initialized = false;

    @Override
    public void addVisitors(VisitorConfigMap visitorMap) {
        this.initialize();
        if (this.bindBeanId != null && this.bindBeanClass != null) {
            if (this.bindingType == FixedLengthBindingType.LIST) {
                Bean listBean = new Bean(ArrayList.class, this.bindBeanId, "$document");
                Bean bean = listBean.newBean(this.bindBeanClass, this.recordElementName);
                listBean.bindTo(bean);
                this.addFieldBindings(bean);
                listBean.addVisitors(visitorMap);
            } else if (this.bindingType == FixedLengthBindingType.MAP) {
                if (this.bindMapKeyField == null) {
                    throw new SmooksConfigurationException("FixedLenght 'MAP' Binding must specify a 'keyField' property on the binding configuration.");
                }
                this.assertValidFieldName(this.bindMapKeyField);
                Bean mapBean = new Bean(LinkedHashMap.class, this.bindBeanId, "$document");
                Bean recordBean = new Bean(this.bindBeanClass, RECORD_BEAN, this.recordElementName);
                MapBindingWiringVisitor wiringVisitor = new MapBindingWiringVisitor(this.bindMapKeyField, this.bindBeanId);
                this.addFieldBindings(recordBean);
                mapBean.addVisitors(visitorMap);
                recordBean.addVisitors(visitorMap);
                visitorMap.addVisitor(wiringVisitor, this.recordElementName, null, false);
            } else {
                Bean bean = new Bean(this.bindBeanClass, this.bindBeanId, this.recordElementName);
                this.addFieldBindings(bean);
                bean.addVisitors(visitorMap);
            }
        }
    }

    private void addFieldBindings(Bean bean) {
        for (Field field1 : this.fields) {
            String field = field1.getName();
            if (field.equals(IGNORE_FIELD)) continue;
            bean.bindTo(field, this.recordElementName + "/" + field);
        }
    }

    @Override
    public void setExecutionContext(ExecutionContext request) {
        this.execContext = request;
    }

    @Initialize
    public void initialize() {
        this.buildFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource flInputSource) throws IOException, SAXException {
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse Fixed Length stream.");
        }
        if (this.execContext == null) {
            throw new IllegalStateException("'execContext' not set.  Cannot parse Fixed Length stream.");
        }
        try {
            String flRecord;
            int lineNumber = 0;
            Reader flStreamReader = flInputSource.getCharacterStream();
            if (flStreamReader == null) {
                flStreamReader = new InputStreamReader(flInputSource.getByteStream(), this.encoding);
            }
            BufferedReader flLineReader = new BufferedReader(flStreamReader);
            this.contentHandler.startDocument();
            this.contentHandler.startElement("", this.rootElementName, "", EMPTY_ATTRIBS);
            while ((flRecord = flLineReader.readLine()) != null) {
                boolean invalidLength;
                if (++lineNumber <= this.skipLines) continue;
                boolean bl = invalidLength = flRecord.length() < this.totalFieldLenght;
                if (invalidLength && this.strict) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.debug((Object)("[WARNING-FIXEDLENGTH] Fixed Length line #" + lineNumber + " is invalid.  The line doesn't contain enough characters to fill all the fields. This line is skipped."));
                    continue;
                }
                char[] recordChars = flRecord.toCharArray();
                if (this.indent) {
                    this.contentHandler.characters(INDENT_LF, 0, 1);
                    this.contentHandler.characters(INDENT_1, 0, 1);
                }
                AttributesImpl attrs = EMPTY_ATTRIBS;
                if (this.lineNumber || invalidLength) {
                    attrs = new AttributesImpl();
                    if (this.lineNumber) {
                        attrs.addAttribute("", this.lineNumberAttributeName, this.lineNumberAttributeName, "xs:int", Integer.toString(lineNumber));
                    }
                    if (invalidLength) {
                        attrs.addAttribute("", this.truncatedAttributeName, this.truncatedAttributeName, "xs:boolean", Boolean.TRUE.toString());
                    }
                }
                this.contentHandler.startElement("", this.recordElementName, "", attrs);
                int fieldLengthTotal = 0;
                for (int i = 0; i < this.flFields.length; ++i) {
                    String fieldName = this.fields[i].getName();
                    int fieldLength = this.fields[i].getLength();
                    StringFunctionExecutor stringFunctionExecutor = this.fields[i].getStringFunctionExecutor();
                    if (!this.fields[i].ignore()) {
                        if (this.indent) {
                            this.contentHandler.characters(INDENT_LF, 0, 1);
                            this.contentHandler.characters(INDENT_2, 0, 2);
                        }
                        boolean truncated = fieldLengthTotal + fieldLength > flRecord.length();
                        AttributesImpl recordAttrs = EMPTY_ATTRIBS;
                        if (truncated) {
                            recordAttrs = new AttributesImpl();
                            recordAttrs.addAttribute("", this.truncatedAttributeName, this.truncatedAttributeName, "xs:boolean", Boolean.TRUE.toString());
                        }
                        this.contentHandler.startElement("", fieldName, "", recordAttrs);
                        if (!truncated) {
                            if (stringFunctionExecutor == null) {
                                this.contentHandler.characters(recordChars, fieldLengthTotal, fieldLength);
                            } else {
                                String value = flRecord.substring(fieldLengthTotal, fieldLengthTotal + fieldLength);
                                value = stringFunctionExecutor.execute(value);
                                this.contentHandler.characters(value.toCharArray(), 0, value.length());
                            }
                        }
                        this.contentHandler.endElement("", fieldName, "");
                    }
                    fieldLengthTotal += fieldLength;
                }
                if (this.indent) {
                    this.contentHandler.characters(INDENT_LF, 0, 1);
                    this.contentHandler.characters(INDENT_1, 0, 1);
                }
                this.contentHandler.endElement(null, this.recordElementName, "");
            }
            if (this.indent) {
                this.contentHandler.characters(INDENT_LF, 0, 1);
            }
            this.contentHandler.endElement("", this.rootElementName, "");
            this.contentHandler.endDocument();
        }
        finally {
            this.contentHandler = null;
            this.execContext = null;
        }
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    private void assertValidFieldName(String fieldName) {
        for (Field field : this.fields) {
            if (!field.getName().equals(fieldName)) continue;
            return;
        }
        String fieldNames = "";
        for (Field field : this.fields) {
            if (field.ignore()) continue;
            if (fieldNames.length() > 0) {
                fieldNames = fieldNames + ", ";
            }
            fieldNames = fieldNames + field.getName();
        }
        throw new SmooksConfigurationException("Invalid field name '" + fieldName + "'.  Valid names: [" + fieldNames + "].");
    }

    private void buildFields() {
        Field[] fields = new Field[this.flFields.length];
        int totalFieldLenght = 0;
        for (int i = 0; i < this.flFields.length; ++i) {
            String fieldInfos = this.flFields[i].trim();
            String fieldName = fieldInfos.substring(0, fieldInfos.lastIndexOf(91));
            int fieldLength = Integer.parseInt(fieldInfos.substring(fieldInfos.lastIndexOf(91) + 1, fieldInfos.lastIndexOf(93)));
            String functionDefinition = fieldInfos.substring(fieldInfos.lastIndexOf(93) + 1);
            if (functionDefinition.length() != 0 && functionDefinition.charAt(0) == '?') {
                functionDefinition = functionDefinition.substring(1);
            }
            StringFunctionExecutor stringFunctionExecutor = null;
            if (functionDefinition.length() != 0) {
                stringFunctionExecutor = StringFunctionExecutor.getInstance(functionDefinition);
            }
            fields[i] = new Field(fieldName, fieldLength, stringFunctionExecutor);
            totalFieldLenght += fieldLength;
        }
        this.fields = fields;
        this.totalFieldLenght = totalFieldLenght;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supported by this reader.");
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler arg0) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver arg0) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void setErrorHandler(ErrorHandler arg0) {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    private class MapBindingWiringVisitor
    implements DOMVisitAfter,
    SAXVisitAfter,
    Consumer {
        private MVELExpressionEvaluator keyExtractor = new MVELExpressionEvaluator();
        private String mapBindingKey;

        private MapBindingWiringVisitor(String bindKeyField, String mapBindingKey) {
            this.keyExtractor.setExpression("flRecordBean." + bindKeyField);
            this.mapBindingKey = mapBindingKey;
        }

        @Override
        public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
            this.wireObject(executionContext);
        }

        @Override
        public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
            this.wireObject(executionContext);
        }

        private void wireObject(ExecutionContext executionContext) {
            BeanContext beanContext = executionContext.getBeanContext();
            Map<String, Object> beanMap = beanContext.getBeanMap();
            Object key = this.keyExtractor.getValue(beanMap);
            Map map = (Map)beanContext.getBean(this.mapBindingKey);
            Object record = beanContext.getBean(FixedLengthReader.RECORD_BEAN);
            map.put(key, record);
        }

        @Override
        public boolean consumes(Object object) {
            return this.keyExtractor.getExpression().indexOf(object.toString()) != -1;
        }
    }

    private class Field {
        private final String name;
        private final int length;
        private final boolean ignore;
        private final StringFunctionExecutor stringFunctionExecutor;

        public Field(String name, int length, StringFunctionExecutor stringFunctionExecutor) {
            this.name = name;
            this.length = length;
            this.stringFunctionExecutor = stringFunctionExecutor;
            this.ignore = FixedLengthReader.IGNORE_FIELD.equals(name);
        }

        public String getName() {
            return this.name;
        }

        public int getLength() {
            return this.length;
        }

        public boolean ignore() {
            return this.ignore;
        }

        public StringFunctionExecutor getStringFunctionExecutor() {
            return this.stringFunctionExecutor;
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("name", (Object)this.name).append("length", this.length).append("stringFunctionExecutor", (Object)this.stringFunctionExecutor);
            return builder.toString();
        }
    }
}

