/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.flatfile.variablefield;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.flatfile.Field;
import org.milyn.flatfile.FieldMetaData;
import org.milyn.flatfile.Record;
import org.milyn.flatfile.RecordMetaData;
import org.milyn.flatfile.RecordParser;
import org.milyn.flatfile.variablefield.VariableFieldRecordMetaData;
import org.milyn.flatfile.variablefield.VariableFieldRecordParserFactory;
import org.milyn.function.StringFunctionExecutor;

public abstract class VariableFieldRecordParser<T extends VariableFieldRecordParserFactory>
implements RecordParser<T> {
    private Log logger = LogFactory.getLog(this.getClass());
    private T factory;
    private int lineNumber = 0;
    private int recordCount = 0;
    private RecordMetaData inMessageRecordMetaData;

    public abstract List<String> nextRecordFieldValues() throws IOException;

    @Override
    public final void setRecordParserFactory(T factory) {
        this.factory = factory;
    }

    @Override
    public void initialize() throws IOException {
        int skipLines = ((VariableFieldRecordParserFactory)this.factory).getSkipLines();
        while (this.lineNumber < skipLines) {
            this._nextRecordFieldValues();
        }
        if (((VariableFieldRecordParserFactory)this.factory).fieldsInMessage() || ((VariableFieldRecordParserFactory)this.factory).validateHeader()) {
            List<String> fields = this._nextRecordFieldValues();
            if (((VariableFieldRecordParserFactory)this.factory).validateHeader()) {
                this.validateHeader(fields);
            }
            if (((VariableFieldRecordParserFactory)this.factory).fieldsInMessage()) {
                this.inMessageRecordMetaData = VariableFieldRecordMetaData.buildRecordMetaData(((VariableFieldRecordParserFactory)this.factory).getRecordElementName(), fields);
            }
        }
    }

    @Override
    public void uninitialize() {
    }

    public T getFactory() {
        return this.factory;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    private List<String> _nextRecordFieldValues() throws IOException {
        ++this.lineNumber;
        return this.nextRecordFieldValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Record nextRecord() throws IOException {
        List<String> fieldValues = this._nextRecordFieldValues();
        if (fieldValues == null || fieldValues.isEmpty()) {
            return null;
        }
        RecordMetaData recordMetaData = this.inMessageRecordMetaData != null ? this.inMessageRecordMetaData : ((VariableFieldRecordParserFactory)this.factory).getRecordMetaData(fieldValues);
        List<FieldMetaData> fieldsMetaData = recordMetaData.getFields();
        if (((VariableFieldRecordParserFactory)this.factory).strict() && fieldValues.size() < this.getUnignoredFieldCount(recordMetaData)) {
            this.logger.debug((Object)("[CORRUPT] Record #" + this.recordCount + " invalid [" + fieldValues + "].  The record should contain " + fieldsMetaData.size() + " fields [" + recordMetaData.getFieldNames() + "], but contains " + fieldValues.size() + " fields.  Ignoring!!"));
            return this.nextRecord();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        try {
            if (recordMetaData == VariableFieldRecordMetaData.UNKNOWN_RECORD_TYPE) {
                fields.add(new Field(recordMetaData.getFields().get(0).getName(), fieldValues.get(0)));
                Record record = new Record(recordMetaData.getName(), fields, recordMetaData);
                return record;
            }
            int fieldValueOffset = 0;
            if (this.inMessageRecordMetaData == null && ((VariableFieldRecordParserFactory)this.factory).isMultiTypeRecordSet()) {
                fieldValueOffset = 1;
            }
            for (int i = 0; i < fieldValues.size(); ++i) {
                Field field;
                int fieldValueIndex = i + fieldValueOffset;
                if (fieldValueIndex > fieldValues.size() - 1) {
                    break;
                }
                if (!recordMetaData.isWildCardRecord() && i > fieldsMetaData.size() - 1) {
                    break;
                }
                String value = fieldValues.get(fieldValueIndex);
                if (recordMetaData.isWildCardRecord() || i > fieldsMetaData.size() - 1) {
                    field = new Field("field_" + i, value);
                } else {
                    FieldMetaData fieldMetaData = fieldsMetaData.get(i);
                    if (fieldMetaData.ignore()) {
                        if ((i += fieldMetaData.getIgnoreCount() - 1) >= 0) continue;
                        i = 0x7FFFFFFE;
                        continue;
                    }
                    StringFunctionExecutor stringFunction = fieldMetaData.getStringFunctionExecutor();
                    if (stringFunction != null) {
                        value = stringFunction.execute(value);
                    }
                    field = new Field(fieldMetaData.getName(), value);
                    field.setMetaData(fieldMetaData);
                }
                fields.add(field);
            }
        }
        finally {
            ++this.recordCount;
        }
        return new Record(recordMetaData.getName(), fields, recordMetaData);
    }

    public int getUnignoredFieldCount(RecordMetaData recordMetaData) {
        if (((VariableFieldRecordParserFactory)this.factory).isMultiTypeRecordSet()) {
            return recordMetaData.getUnignoredFieldCount() + 1;
        }
        return recordMetaData.getUnignoredFieldCount();
    }

    protected void validateHeader(List<String> headers) throws IOException {
        if (((VariableFieldRecordParserFactory)this.factory).isMultiTypeRecordSet()) {
            throw new IOException("Cannot validate the 'header' field of a Multi-Type Record Set.  Reader fields definition defines multiple record definitions.");
        }
        RecordMetaData recordMetaData = ((VariableFieldRecordParserFactory)this.factory).getRecordMetaData();
        if (headers == null) {
            throw new IOException("Null header.");
        }
        if (this.validateHeader(headers, recordMetaData.getFields())) {
            return;
        }
        throw new IOException("Invalid header.");
    }

    private boolean validateHeader(List<String> headers, List<FieldMetaData> fieldsMetaData) {
        if (fieldsMetaData.size() != headers.size()) {
            return false;
        }
        int n = 0;
        for (FieldMetaData field : fieldsMetaData) {
            if (!field.ignore()) {
                String name;
                if (headers.size() <= n) {
                    return false;
                }
                String header = headers.get(n);
                if (header == null) {
                    header = "";
                }
                if ((name = field.getName()) == null) {
                    name = "";
                }
                if (!name.equals(header)) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }
}

