/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.delivery.sax.SAXText;
import org.milyn.delivery.sax.SAXUtil;
import org.milyn.delivery.sax.SAXVisitor;
import org.milyn.delivery.sax.SAXWriterAccessException;
import org.milyn.delivery.sax.TextType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAXElement {
    private QName name;
    private AttributesImpl attributes;
    private SAXElement parent;
    private Writer writer;
    private List<SAXText> text;
    private StringWriter textAccumulator;
    private String accumulatedText;
    private Object l1Cache;
    private SAXVisitor l1CacheOwner;
    private Map<SAXVisitor, Object> l2Caches;

    public SAXElement(String namespaceURI, String localName) {
        this(namespaceURI, localName, null, new AttributesImpl(), null);
    }

    public SAXElement(String namespaceURI, String localName, SAXElement parent) {
        this(namespaceURI, localName, null, new AttributesImpl(), parent);
    }

    public SAXElement(String namespaceURI, String localName, String qName, Attributes attributes, SAXElement parent) {
        this.name = SAXUtil.toQName(namespaceURI, localName, qName);
        this.attributes = this.copyAttributes(attributes);
        this.parent = parent;
    }

    public SAXElement(QName name, Attributes attributes, SAXElement parent) {
        this.name = name;
        this.attributes = this.copyAttributes(attributes);
        this.parent = parent;
    }

    private AttributesImpl copyAttributes(Attributes attributes) {
        AttributesImpl attributesCopy = new AttributesImpl();
        attributesCopy.setAttributes(attributes);
        return attributesCopy;
    }

    public void accumulateText() {
        if (this.text == null) {
            this.text = new ArrayList<SAXText>(){

                @Override
                public boolean add(SAXText saxText) {
                    if (SAXElement.this.textAccumulator != null) {
                        SAXElement.this.accumulatedText = null;
                    }
                    return super.add((SAXText)saxText.clone());
                }
            };
        }
    }

    public List<SAXText> getText() {
        return this.text;
    }

    public void addText(String text) {
        this.addText(text, TextType.TEXT);
    }

    public void addText(String text, TextType type) {
        if (this.text == null) {
            this.accumulateText();
        }
        this.text.add(new SAXText(text, type));
    }

    public String getTextContent() throws SmooksException {
        if (this.text == null) {
            throw new SmooksException("Illegal call to getTextContent().  SAXElement instance not accumulating SAXText Objects.  You must call SAXElement.accumulateText(), or annotate the Visitor implementation class with the @TextConsumer annotation.");
        }
        if (this.textAccumulator == null) {
            this.textAccumulator = new StringWriter();
        }
        if (this.accumulatedText == null) {
            this.textAccumulator.getBuffer().setLength(0);
            for (SAXText textObj : this.text) {
                try {
                    textObj.toWriter(this.textAccumulator, false);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected IOException.", e);
                }
            }
            this.accumulatedText = this.textAccumulator.toString();
        }
        return this.accumulatedText;
    }

    public Writer getWriter(SAXVisitor visitor) throws SAXWriterAccessException {
        return this.writer;
    }

    public void setWriter(Writer writer, SAXVisitor visitor) throws SAXWriterAccessException {
        this.writer = writer;
    }

    public boolean isWriterOwner(SAXVisitor visitor) {
        return true;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        AssertArgument.isNotNull((Object)name, (String)"name");
        this.name = name;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        AssertArgument.isNotNull((Object)attributes, (String)"attributes");
        this.attributes = this.copyAttributes(attributes);
    }

    public String getAttribute(String attribute) {
        return SAXUtil.getAttribute(attribute, this.attributes);
    }

    public String getAttributeNS(String namespaceURI, String attribute) {
        return SAXUtil.getAttribute(namespaceURI, attribute, this.attributes, "");
    }

    public String getAttribute(String namespaceURI, String attribute) {
        return this.getAttributeNS(namespaceURI, attribute);
    }

    public void setAttribute(String attribute, String value) {
        this.setAttributeNS("", attribute, value);
    }

    public void setAttributeNS(String namespaceURI, String name, String value) {
        this.removeAttributeNS(namespaceURI, name);
        int prefixIndex = name.indexOf(":");
        if (prefixIndex != -1) {
            this.attributes.addAttribute(namespaceURI, name.substring(prefixIndex + 1), name, "CDATA", value);
        } else {
            this.attributes.addAttribute(namespaceURI, name, "", "CDATA", value);
        }
    }

    public void removeAttribute(String name) {
        this.removeAttributeNS("", name);
    }

    public void removeAttributeNS(String namespaceURI, String name) {
        int attribCount = this.attributes.getLength();
        for (int i = 0; i < attribCount; ++i) {
            boolean isQName;
            if (!namespaceURI.equals(this.attributes.getURI(i))) continue;
            boolean bl = isQName = name.indexOf(":") != -1;
            if (isQName && name.equals(this.attributes.getQName(i))) {
                this.attributes.removeAttribute(i);
                continue;
            }
            if (isQName || !name.equals(this.attributes.getLocalName(i))) continue;
            this.attributes.removeAttribute(i);
        }
    }

    public Object getCache() {
        return this.l1Cache;
    }

    public void setCache(Object cache) {
        this.l1Cache = cache;
    }

    public Object getCache(SAXVisitor visitor) {
        if (visitor == this.l1CacheOwner) {
            return this.l1Cache;
        }
        if (this.l2Caches == null) {
            return null;
        }
        return this.l2Caches.get(visitor);
    }

    public void setCache(SAXVisitor visitor, Object cache) {
        if (this.l1Cache == null && this.l1CacheOwner == null) {
            this.l1Cache = cache;
            this.l1CacheOwner = visitor;
            return;
        }
        if (this.l2Caches == null) {
            this.l2Caches = new HashMap<SAXVisitor, Object>();
        }
        this.l2Caches.put(visitor, cache);
    }

    public SAXElement getParent() {
        return this.parent;
    }

    public void setParent(SAXElement parent) {
        this.parent = parent;
    }

    public String toString() {
        return this.getName().toString();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Element toDOMElement(Document document) {
        Element element = this.name.getNamespaceURI() != null ? (this.name.getPrefix().length() != 0 ? document.createElementNS(this.name.getNamespaceURI(), this.name.getPrefix() + ":" + this.name.getLocalPart()) : document.createElementNS(this.name.getNamespaceURI(), this.name.getLocalPart())) : document.createElement(this.name.getLocalPart());
        int attributeCount = this.attributes.getLength();
        for (int i = 0; i < attributeCount; ++i) {
            String namespace = this.attributes.getURI(i);
            String value = this.attributes.getValue(i);
            if (namespace != null) {
                String qName = this.attributes.getQName(i);
                if (namespace.equals("")) {
                    if (qName.startsWith("xmlns")) {
                        namespace = "http://www.w3.org/2000/xmlns/";
                    } else if (qName.startsWith("xml:")) {
                        namespace = "http://www.w3.org/XML/1998/namespace";
                    }
                }
                element.setAttributeNS(namespace, qName, value);
                continue;
            }
            String localName = this.attributes.getLocalName(i);
            element.setAttribute(localName, value);
        }
        return element;
    }
}

