/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Filter;
import org.milyn.delivery.sax.SAXParser;
import org.milyn.delivery.sax.SAXUtil;
import org.milyn.delivery.sax.terminate.TerminateException;
import org.milyn.payload.FilterResult;
import org.milyn.payload.FilterSource;
import org.milyn.payload.JavaSource;
import org.milyn.payload.StringSource;
import org.milyn.xml.XmlUtil;

public class SmooksSAXFilter
extends Filter {
    private static Log logger = LogFactory.getLog(SmooksSAXFilter.class);
    private ExecutionContext executionContext;
    private SAXParser parser;
    private boolean closeSource;
    private boolean closeResult;

    public SmooksSAXFilter(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.closeSource = ParameterAccessor.getBoolParameter("close.source", true, executionContext.getDeliveryConfig());
        this.closeResult = ParameterAccessor.getBoolParameter("close.result", true, executionContext.getDeliveryConfig());
        this.parser = new SAXParser(executionContext);
    }

    @Override
    public void doFilter() throws SmooksException {
        Source source = FilterSource.getSource(this.executionContext);
        Result result = FilterResult.getResult(this.executionContext, StreamResult.class);
        this.doFilter(source, result);
    }

    protected void doFilter(Source source, Result result) {
        if (source instanceof DOMSource) {
            String serializedDOM = XmlUtil.serialize(((DOMSource)source).getNode(), false);
            source = new StringSource(serializedDOM);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"DOMSource converted to a StringSource.");
            }
        }
        if (!(source instanceof StreamSource) && !(source instanceof JavaSource)) {
            throw new IllegalArgumentException(source.getClass().getName() + " Source types not yet supported by the SAX Filter. Only supports StreamSource and JavaSource at present.");
        }
        if (!(result instanceof FilterResult) && !(result instanceof StreamResult) && result != null) {
            throw new IllegalArgumentException(result.getClass().getName() + " Result types not yet supported by the SAX Filter. Only supports StreamResult at present.");
        }
        try {
            Writer writer = this.parser.parse(source, result, this.executionContext);
            writer.flush();
        }
        catch (TerminateException e) {
            if (logger.isDebugEnabled()) {
                if (e.isTerminateBefore()) {
                    logger.debug((Object)("Terminated filtering on visitBefore of element '" + SAXUtil.getXPath(e.getElement()) + "'."));
                } else {
                    logger.debug((Object)("Terminated filtering on visitAfter of element '" + SAXUtil.getXPath(e.getElement()) + "'."));
                }
            }
        }
        catch (Exception e) {
            throw new SmooksException("Failed to filter source.", e);
        }
        finally {
            if (this.closeSource) {
                this.close(source);
            }
            if (this.closeResult) {
                this.close(result);
            }
        }
    }

    @Override
    public void cleanup() {
        this.parser.cleanup();
    }
}

